/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty.cluster;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.geronimo.clustering.Session;
import org.apache.geronimo.clustering.SessionAlreadyExistException;
import org.apache.geronimo.clustering.SessionListener;
import org.apache.geronimo.clustering.SessionManager;
import org.mortbay.jetty.servlet.AbstractSessionManager;
import org.mortbay.util.MultiMap;

public class ClusteredSessionManager
extends AbstractSessionManager {
    private static final Object ALL_SESSION_PLACEHOLDER = new Object();
    private final SessionManager sessionManager;

    public ClusteredSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
        String workerName = sessionManager.getNode().getName();
        workerName = workerName.replaceAll(" ", "");
        this.setWorkerName(workerName);
        this.setCrossContextSessionIDs(true);
        sessionManager.registerListener((SessionListener)new MigrationListener());
        this.setMaxInactiveInterval(-1);
    }

    protected AbstractSessionManager.Session newSession(HttpServletRequest request) {
        return new ClusteredSession(request);
    }

    private class RequestWithBoundSession
    implements HttpServletRequest {
        private final Session session;

        public RequestWithBoundSession(Session session) {
            this.session = session;
        }

        public void setAttribute(String arg0, Object arg1) {
        }

        public Object getAttribute(String arg0) {
            return null;
        }

        public String getRequestedSessionId() {
            return this.session.getSessionId();
        }

        public String getAuthType() {
            throw new UnsupportedOperationException();
        }

        public String getContextPath() {
            throw new UnsupportedOperationException();
        }

        public Cookie[] getCookies() {
            throw new UnsupportedOperationException();
        }

        public long getDateHeader(String arg0) {
            throw new UnsupportedOperationException();
        }

        public String getHeader(String arg0) {
            throw new UnsupportedOperationException();
        }

        public Enumeration getHeaderNames() {
            throw new UnsupportedOperationException();
        }

        public Enumeration getHeaders(String arg0) {
            throw new UnsupportedOperationException();
        }

        public int getIntHeader(String arg0) {
            throw new UnsupportedOperationException();
        }

        public String getMethod() {
            throw new UnsupportedOperationException();
        }

        public String getPathInfo() {
            throw new UnsupportedOperationException();
        }

        public String getPathTranslated() {
            throw new UnsupportedOperationException();
        }

        public String getQueryString() {
            throw new UnsupportedOperationException();
        }

        public String getRemoteUser() {
            throw new UnsupportedOperationException();
        }

        public String getRequestURI() {
            throw new UnsupportedOperationException();
        }

        public StringBuffer getRequestURL() {
            throw new UnsupportedOperationException();
        }

        public String getServletPath() {
            throw new UnsupportedOperationException();
        }

        public HttpSession getSession() {
            throw new UnsupportedOperationException();
        }

        public HttpSession getSession(boolean arg0) {
            throw new UnsupportedOperationException();
        }

        public Principal getUserPrincipal() {
            throw new UnsupportedOperationException();
        }

        public boolean isRequestedSessionIdFromCookie() {
            throw new UnsupportedOperationException();
        }

        public boolean isRequestedSessionIdFromURL() {
            throw new UnsupportedOperationException();
        }

        public boolean isRequestedSessionIdFromUrl() {
            throw new UnsupportedOperationException();
        }

        public boolean isRequestedSessionIdValid() {
            throw new UnsupportedOperationException();
        }

        public boolean isUserInRole(String arg0) {
            throw new UnsupportedOperationException();
        }

        public Enumeration getAttributeNames() {
            throw new UnsupportedOperationException();
        }

        public String getCharacterEncoding() {
            throw new UnsupportedOperationException();
        }

        public int getContentLength() {
            throw new UnsupportedOperationException();
        }

        public String getContentType() {
            throw new UnsupportedOperationException();
        }

        public ServletInputStream getInputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        public String getLocalAddr() {
            throw new UnsupportedOperationException();
        }

        public String getLocalName() {
            throw new UnsupportedOperationException();
        }

        public int getLocalPort() {
            throw new UnsupportedOperationException();
        }

        public Locale getLocale() {
            throw new UnsupportedOperationException();
        }

        public Enumeration getLocales() {
            throw new UnsupportedOperationException();
        }

        public String getParameter(String arg0) {
            throw new UnsupportedOperationException();
        }

        public Map getParameterMap() {
            throw new UnsupportedOperationException();
        }

        public Enumeration getParameterNames() {
            throw new UnsupportedOperationException();
        }

        public String[] getParameterValues(String arg0) {
            throw new UnsupportedOperationException();
        }

        public String getProtocol() {
            throw new UnsupportedOperationException();
        }

        public BufferedReader getReader() throws IOException {
            throw new UnsupportedOperationException();
        }

        public String getRealPath(String arg0) {
            throw new UnsupportedOperationException();
        }

        public String getRemoteAddr() {
            throw new UnsupportedOperationException();
        }

        public String getRemoteHost() {
            throw new UnsupportedOperationException();
        }

        public int getRemotePort() {
            throw new UnsupportedOperationException();
        }

        public RequestDispatcher getRequestDispatcher(String arg0) {
            throw new UnsupportedOperationException();
        }

        public String getScheme() {
            throw new UnsupportedOperationException();
        }

        public String getServerName() {
            throw new UnsupportedOperationException();
        }

        public int getServerPort() {
            throw new UnsupportedOperationException();
        }

        public boolean isSecure() {
            throw new UnsupportedOperationException();
        }

        public void removeAttribute(String arg0) {
            throw new UnsupportedOperationException();
        }

        public void setCharacterEncoding(String arg0) throws UnsupportedEncodingException {
            throw new UnsupportedOperationException();
        }
    }

    protected class ClusteredSession
    extends AbstractSessionManager.Session {
        private static final String FORCE_SET_VALUES = "$$$JETTY_FORCE_SET_VALUES$$$";
        private final Session session;

        protected ClusteredSession(HttpServletRequest request) {
            super((AbstractSessionManager)ClusteredSessionManager.this, request);
            if (request instanceof RequestWithBoundSession) {
                this.session = ((RequestWithBoundSession)request).session;
                this.setAttribute(FORCE_SET_VALUES, FORCE_SET_VALUES);
            } else {
                try {
                    this.session = ClusteredSessionManager.this.sessionManager.createSession(this.getId());
                }
                catch (SessionAlreadyExistException e) {
                    throw (IllegalStateException)new IllegalStateException().initCause(e);
                }
            }
        }

        protected Map newAttributeMap() {
            return this.session.getState();
        }
    }

    private class MigrationListener
    implements SessionListener {
        private MigrationListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyInboundSessionMigration(Session session) {
            String sessionId = session.getSessionId();
            MultiMap multiMap = __allSessions;
            synchronized (multiMap) {
                if (__allSessions.containsKey((Object)sessionId)) {
                    throw new IllegalStateException("ID [" + sessionId + "] is already defined.");
                }
                __allSessions.add((Object)sessionId, ALL_SESSION_PLACEHOLDER);
                ClusteredSessionManager.this.newHttpSession(new RequestWithBoundSession(session));
                __allSessions.removeValue((Object)sessionId, ALL_SESSION_PLACEHOLDER);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyOutboundSessionMigration(Session session) {
            String sessionId = session.getSessionId();
            Object object = __allSessions;
            synchronized (object) {
                __allSessions.remove((Object)sessionId);
            }
            object = ClusteredSessionManager.this._sessions;
            synchronized (object) {
                ClusteredSessionManager.this._sessions.remove(sessionId);
            }
        }
    }
}

