/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.jetty.JettyServletRegistration;
import org.apache.geronimo.management.Servlet;
import org.apache.geronimo.security.Callers;
import org.apache.geronimo.security.ContextManager;
import org.mortbay.jetty.servlet.ServletHolder;

public class JettyServletHolder
extends ServletHolder
implements Servlet {
    private static final ThreadLocal currentServletName = new ThreadLocal();
    private final Subject runAsSubject;
    private final String objectName;
    public static final GBeanInfo GBEAN_INFO;

    public JettyServletHolder() {
        this.objectName = null;
        this.runAsSubject = null;
    }

    public JettyServletHolder(String objectName, String servletName, String servletClassName, String jspFile, Map initParams, Integer loadOnStartup, Set servletMappings, Subject runAsSubject, ServletHolder previous, JettyServletRegistration context) throws Exception {
        super(context == null ? null : context.getServletHandler(), servletName, servletClassName, jspFile);
        if (context != null) {
            this.putAll(initParams);
            if (loadOnStartup != null) {
                this.setInitOrder(loadOnStartup);
            }
            context.registerServletHolder(this, servletName, servletMappings, objectName);
        }
        this.runAsSubject = runAsSubject;
        this.objectName = objectName;
    }

    public String getServletName() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(ServletRequest request, ServletResponse response) throws ServletException, UnavailableException, IOException {
        JettyServletHolder.setCurrentServletName(this.getServletName());
        if (this.runAsSubject == null) {
            super.handle(request, response);
        } else {
            Callers oldCallers = ContextManager.pushNextCaller((Subject)this.runAsSubject);
            try {
                super.handle(request, response);
            }
            finally {
                ContextManager.popCallers((Callers)oldCallers);
            }
        }
    }

    static String getCurrentServletName() {
        return (String)currentServletName.get();
    }

    static void setCurrentServletName(String servletName) {
        currentServletName.set(servletName);
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isStateManageable() {
        return false;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    public boolean isEventProvider() {
        return false;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic((Class)JettyServletHolder.class, (String)"Servlet");
        infoBuilder.addInterface(ServletHolder.class);
        infoBuilder.addAttribute("servletName", String.class, true);
        infoBuilder.addAttribute("servletClass", String.class, true);
        infoBuilder.addAttribute("jspFile", String.class, true);
        infoBuilder.addAttribute("initParams", Map.class, true);
        infoBuilder.addAttribute("loadOnStartup", Integer.class, true);
        infoBuilder.addAttribute("servletMappings", Set.class, true);
        infoBuilder.addAttribute("runAsSubject", Subject.class, true);
        infoBuilder.addAttribute("objectName", String.class, false);
        infoBuilder.addInterface(Servlet.class);
        infoBuilder.addReference("Previous", ServletHolder.class, "Servlet");
        infoBuilder.addReference("JettyServletRegistration", JettyServletRegistration.class, "WebModule");
        infoBuilder.setConstructor(new String[]{"objectName", "servletName", "servletClass", "jspFile", "initParams", "loadOnStartup", "servletMappings", "runAsSubject", "Previous", "JettyServletRegistration"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

