/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty;

import java.io.Serializable;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.jetty.JettyFilterHolder;
import org.apache.geronimo.jetty.JettyServletHolder;
import org.apache.geronimo.jetty.JettyServletRegistration;
import org.mortbay.jetty.servlet.WebApplicationHandler;

public class JettyFilterMapping
implements Serializable {
    private final String urlPattern;
    private final boolean requestDispatch;
    private final boolean forwardDispatch;
    private final boolean includeDispatch;
    private final boolean errorDispatch;
    private final JettyFilterHolder jettyFilterHolder;
    private final JettyServletHolder jettyServletHolder;
    private final JettyFilterMapping previous;
    private final JettyServletRegistration jettyServletRegistration;
    public static final GBeanInfo GBEAN_INFO;
    static final /* synthetic */ boolean $assertionsDisabled;

    public JettyFilterMapping() {
        this.urlPattern = null;
        this.requestDispatch = false;
        this.forwardDispatch = false;
        this.includeDispatch = false;
        this.errorDispatch = false;
        this.jettyFilterHolder = null;
        this.jettyServletHolder = null;
        this.previous = null;
        this.jettyServletRegistration = null;
    }

    public JettyFilterMapping(String urlPattern, boolean requestDispatch, boolean forwardDispatch, boolean includeDispatch, boolean errorDispatch, JettyFilterHolder jettyFilterHolder, JettyServletHolder jettyServletHolder, JettyFilterMapping previous, JettyServletRegistration jettyServletRegistration) {
        this.urlPattern = urlPattern;
        this.requestDispatch = requestDispatch;
        this.forwardDispatch = forwardDispatch;
        this.includeDispatch = includeDispatch;
        this.errorDispatch = errorDispatch;
        this.jettyFilterHolder = jettyFilterHolder;
        this.jettyServletHolder = jettyServletHolder;
        this.previous = previous;
        this.jettyServletRegistration = jettyServletRegistration;
        if (jettyServletRegistration != null) {
            if (!$assertionsDisabled && !(jettyServletHolder != null ^ urlPattern != null)) {
                throw new AssertionError();
            }
            String filterName = jettyFilterHolder.getFilterName();
            int dispatches = 0;
            if (requestDispatch) {
                dispatches |= 1;
            }
            if (forwardDispatch) {
                dispatches |= 2;
            }
            if (includeDispatch) {
                dispatches |= 4;
            }
            if (errorDispatch) {
                dispatches |= 8;
            }
            if (jettyServletHolder == null) {
                ((WebApplicationHandler)jettyServletRegistration.getServletHandler()).addFilterPathMapping(urlPattern, filterName, dispatches);
            } else {
                String servletName = jettyServletHolder.getServletName();
                ((WebApplicationHandler)jettyServletRegistration.getServletHandler()).addFilterServletMapping(servletName, filterName, dispatches);
            }
        }
    }

    public String getUrlPattern() {
        return this.urlPattern;
    }

    public boolean isRequestDispatch() {
        return this.requestDispatch;
    }

    public boolean isForwardDispatch() {
        return this.forwardDispatch;
    }

    public boolean isIncludeDispatch() {
        return this.includeDispatch;
    }

    public boolean isErrorDispatch() {
        return this.errorDispatch;
    }

    public JettyFilterHolder getFilter() {
        return this.jettyFilterHolder;
    }

    public JettyServletHolder getServlet() {
        return this.jettyServletHolder;
    }

    public JettyFilterMapping getPrevious() {
        return this.previous;
    }

    public JettyServletRegistration getJettyServletRegistration() {
        return this.jettyServletRegistration;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        $assertionsDisabled = !JettyFilterMapping.class.desiredAssertionStatus();
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic((Class)JettyFilterMapping.class, (String)"URLWebFilterMapping");
        infoBuilder.addAttribute("urlPattern", String.class, true);
        infoBuilder.addAttribute("requestDispatch", Boolean.TYPE, true);
        infoBuilder.addAttribute("forwardDispatch", Boolean.TYPE, true);
        infoBuilder.addAttribute("includeDispatch", Boolean.TYPE, true);
        infoBuilder.addAttribute("errorDispatch", Boolean.TYPE, true);
        infoBuilder.addReference("Filter", JettyFilterHolder.class, "WebFilter");
        infoBuilder.addReference("Servlet", JettyServletHolder.class, "Servlet");
        infoBuilder.addReference("Previous", JettyFilterMapping.class, "URLWebFilterMapping");
        infoBuilder.addReference("JettyServletRegistration", JettyServletRegistration.class, "WebModule");
        infoBuilder.setConstructor(new String[]{"urlPattern", "requestDispatch", "forwardDispatch", "includeDispatch", "errorDispatch", "Filter", "Servlet", "Previous", "JettyServletRegistration"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

