/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;
import org.apache.geronimo.jaxws.annotations.AnnotationException;
import org.apache.geronimo.jaxws.annotations.AnnotationProcessor;
import org.apache.geronimo.jaxws.handler.AnnotationHandlerChainFinder;
import org.apache.geronimo.jaxws.handler.GeronimoHandlerChainBuilder;
import org.apache.geronimo.jaxws.info.HandlerChainInfo;
import org.apache.geronimo.jaxws.info.HandlerChainsInfo;
import org.osgi.framework.Bundle;

public class GeronimoHandlerResolver
implements HandlerResolver {
    private HandlerChainsInfo handlerChainsInfo;
    private Bundle bundle;
    private Class serviceClass;
    private AnnotationProcessor annotationProcessor;

    public GeronimoHandlerResolver(Bundle bundle, Class serviceClass, HandlerChainsInfo handlerChainsInfo, AnnotationProcessor annotationProcessor) {
        this.bundle = bundle;
        this.serviceClass = serviceClass;
        this.handlerChainsInfo = handlerChainsInfo;
        this.annotationProcessor = annotationProcessor;
    }

    public List<Handler> getHandlerChain(PortInfo portInfo) {
        GeronimoHandlerChainBuilder builder = new GeronimoHandlerChainBuilder(this.bundle, portInfo);
        if (this.handlerChainsInfo == null) {
            AnnotationHandlerChainFinder annotationHandlerChainFinder = new AnnotationHandlerChainFinder();
            this.handlerChainsInfo = annotationHandlerChainFinder.buildHandlerChainFromClass(this.serviceClass);
        }
        if (this.handlerChainsInfo == null || this.handlerChainsInfo.handleChains.size() == 0) {
            return Collections.emptyList();
        }
        List<Handler> handlers = new ArrayList<Handler>();
        for (HandlerChainInfo handlerChain : this.handlerChainsInfo.handleChains) {
            handlers.addAll(builder.buildHandlerChainFromConfiguration(handlerChain));
        }
        handlers = builder.sortHandlers(handlers);
        if (this.annotationProcessor != null) {
            try {
                for (Handler handler : handlers) {
                    this.annotationProcessor.processAnnotations(handler);
                    this.annotationProcessor.invokePostConstruct(handler);
                }
            }
            catch (AnnotationException e) {
                throw new WebServiceException("Handler annotation failed", (Throwable)e);
            }
        }
        return handlers;
    }
}

