/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws.client;

import java.io.Serializable;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.geronimo.jaxws.feature.MTOMFeatureInfo;
import org.apache.geronimo.jaxws.feature.WebServiceFeatureInfo;

public class EndpointInfo
implements Serializable {
    private URL location;
    private String credentialsName;
    private Map<String, Object> properties;
    private List<WebServiceFeatureInfo> webServiceFeatureInfos;

    public EndpointInfo(URL location, String credentialsName, Map<String, Object> properties, List<WebServiceFeatureInfo> webServiceFeatureInfos) {
        this.location = location;
        this.credentialsName = credentialsName;
        this.properties = properties;
        this.webServiceFeatureInfos = webServiceFeatureInfos;
    }

    public boolean isMTOMEnabled() {
        for (WebServiceFeatureInfo webServiceFeatureInfo : this.webServiceFeatureInfos) {
            if (!(webServiceFeatureInfo instanceof MTOMFeatureInfo)) continue;
            return ((MTOMFeatureInfo)webServiceFeatureInfo).isEnabled();
        }
        return false;
    }

    public URL getLocation() {
        return this.location;
    }

    public String getCredentialsName() {
        return this.credentialsName;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public List<WebServiceFeatureInfo> getWebServiceFeatureInfos() {
        return this.webServiceFeatureInfos;
    }

    public String toString() {
        return "EndpointInfo [location=" + this.location + ", properties=" + this.properties + ", webServiceFeatureInfos=" + this.webServiceFeatureInfos + "]";
    }
}

