/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws.wsdl;

import java.io.IOException;
import javax.wsdl.xml.WSDLLocator;
import org.apache.geronimo.jaxws.wsdl.SimpleURIResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class SimpleWSDLLocator
implements WSDLLocator {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleWSDLLocator.class);
    private String baseURI;
    private String lastImportLocation;
    private SimpleURIResolver resolver;

    public SimpleWSDLLocator(String baseURI) {
        this.baseURI = baseURI;
        this.resolver = new SimpleURIResolver();
    }

    public InputSource getBaseInputSource() {
        return this.resolve("", this.baseURI);
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public InputSource getImportInputSource(String parentLocation, String importLocation) {
        return this.resolve(parentLocation, importLocation);
    }

    protected InputSource resolve(String parentLocation, String importLocation) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resolving '" + importLocation + "' relative to '" + parentLocation + "'");
        }
        try {
            this.resolver.resolve(parentLocation, importLocation);
            if (this.resolver.isResolved()) {
                this.lastImportLocation = this.resolver.getURI().toString();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Resolved location '" + this.lastImportLocation + "'");
                }
                return new InputSource(this.resolver.getInputStream());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public String getLatestImportURI() {
        return this.lastImportLocation;
    }

    public void close() {
    }
}

