/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws.wsdl;

import java.io.IOException;
import java.net.URI;
import java.util.jar.JarFile;
import org.apache.geronimo.jaxws.wsdl.JarWSDLLocator;
import org.apache.xml.resolver.Catalog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class CatalogJarWSDLLocator
extends JarWSDLLocator {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogJarWSDLLocator.class);
    private Catalog catalog;

    public CatalogJarWSDLLocator(JarFile moduleFile, URI wsdlURI, Catalog catalog) {
        super(moduleFile, wsdlURI);
        this.catalog = catalog;
    }

    @Override
    protected InputSource resolve(String parentLocation, String importLocation) {
        String resolvedImportLocation = null;
        if (this.catalog != null) {
            try {
                resolvedImportLocation = this.catalog.resolveSystem(importLocation);
                if (resolvedImportLocation == null) {
                    resolvedImportLocation = this.catalog.resolveURI(importLocation);
                }
                if (resolvedImportLocation == null) {
                    resolvedImportLocation = this.catalog.resolvePublic(importLocation, parentLocation);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Catalog resolution failed", e);
            }
        }
        if (resolvedImportLocation == null) {
            return super.resolve(parentLocation, importLocation);
        }
        return super.resolve("", resolvedImportLocation);
    }
}

