/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws.handler;

import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import javax.jws.HandlerChain;
import javax.jws.WebService;
import javax.xml.ws.WebServiceException;
import org.apache.geronimo.jaxws.handler.HandlerChainsInfoBuilder;
import org.apache.geronimo.jaxws.info.HandlerChainsInfo;
import org.apache.geronimo.kernel.util.IOUtils;
import org.apache.openejb.jee.HandlerChains;
import org.apache.openejb.jee.JaxbJavaee;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationHandlerChainFinder {
    private static final Logger log = LoggerFactory.getLogger(AnnotationHandlerChainFinder.class);
    private HandlerChainsInfoBuilder handlerChainsInfoBuilder = new HandlerChainsInfoBuilder();

    public HandlerChainsInfo buildHandlerChainFromClass(Class<?> clz, HandlerChainsInfo existingHandlerChainsInfo) {
        HandlerChainsInfo handlerChainsInfo;
        block13: {
            HandlerChainAnnotation hcAnn;
            block12: {
                if (log.isDebugEnabled()) {
                    log.debug("building handler chain on class " + clz.getName());
                }
                handlerChainsInfo = null;
                hcAnn = this.findHandlerChainAnnotation(clz, true);
                if (hcAnn != null) break block12;
                if (log.isDebugEnabled()) {
                    log.debug("no HandlerChain annotation on " + clz);
                }
                handlerChainsInfo = new HandlerChainsInfo();
                break block13;
            }
            hcAnn.validate();
            try {
                HandlerChains handlerChainsType;
                URL handlerFileURL = clz.getResource(hcAnn.getFileName());
                InputStream in = null;
                try {
                    if (handlerFileURL == null) {
                        handlerFileURL = new URL(hcAnn.getFileName());
                    }
                    in = handlerFileURL.openStream();
                    handlerChainsType = (HandlerChains)JaxbJavaee.unmarshalHandlerChains(HandlerChains.class, (InputStream)in);
                }
                catch (Exception e) {
                    try {
                        throw new WebServiceException("Could not read the chain info from " + hcAnn.getFileName(), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.close(in);
                        throw throwable;
                    }
                }
                IOUtils.close((Closeable)in);
                if (null == handlerChainsType || handlerChainsType.getHandlerChain().isEmpty()) {
                    throw new WebServiceException("Chain not specified for class " + clz.getName());
                }
                handlerChainsInfo = this.handlerChainsInfoBuilder.build(handlerChainsType);
            }
            catch (WebServiceException e) {
                throw e;
            }
            catch (Exception e) {
                throw new WebServiceException("Chain not specified", (Throwable)e);
            }
        }
        if (existingHandlerChainsInfo != null) {
            handlerChainsInfo.handleChains.addAll(existingHandlerChainsInfo.handleChains);
        }
        return handlerChainsInfo;
    }

    public HandlerChainsInfo buildHandlerChainFromClass(Class<?> clz) {
        return this.buildHandlerChainFromClass(clz, null);
    }

    private HandlerChainAnnotation findHandlerChainAnnotation(Class<?> clz, boolean searchSEI) {
        if (log.isDebugEnabled()) {
            log.debug("Checking for HandlerChain annotation on " + clz.getName());
        }
        HandlerChainAnnotation hcAnn = null;
        HandlerChain ann = clz.getAnnotation(HandlerChain.class);
        if (ann == null) {
            WebService ws;
            if (searchSEI && (ws = clz.getAnnotation(WebService.class)) != null && ws.endpointInterface() != null && ws.endpointInterface().trim().length() > 0) {
                String seiClassName = ws.endpointInterface().trim();
                Class<?> seiClass = null;
                try {
                    seiClass = clz.getClassLoader().loadClass(seiClassName);
                }
                catch (ClassNotFoundException e) {
                    throw new WebServiceException("Failed to load SEI class: " + seiClassName, (Throwable)e);
                }
                hcAnn = this.findHandlerChainAnnotation(seiClass, false);
            }
            if (hcAnn == null) {
                for (Class<?> iface : clz.getInterfaces()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Checking for HandlerChain annotation on " + iface.getName());
                    }
                    if ((ann = iface.getAnnotation(HandlerChain.class)) == null) continue;
                    hcAnn = new HandlerChainAnnotation(ann, iface);
                    break;
                }
            }
        } else {
            hcAnn = new HandlerChainAnnotation(ann, clz);
        }
        return hcAnn;
    }

    private static class HandlerChainAnnotation {
        private final Class<?> declaringClass;
        private final HandlerChain ann;

        HandlerChainAnnotation(HandlerChain hc, Class<?> clz) {
            this.ann = hc;
            this.declaringClass = clz;
        }

        public Class<?> getDeclaringClass() {
            return this.declaringClass;
        }

        public String getFileName() {
            return this.ann.file();
        }

        public void validate() {
            if (null == this.ann.file() || this.ann.file().isEmpty()) {
                throw new WebServiceException("@HandlerChain annotation does not contain a file name or url.");
            }
        }

        public String toString() {
            return "[" + this.declaringClass + "," + this.ann + "]";
        }
    }
}

