/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.geronimo.jaxws.annotations.AnnotationHandler;
import org.apache.geronimo.jaxws.annotations.InjectionException;

public abstract class InjectingAnnotationHandler
implements AnnotationHandler {
    public abstract Object getAnnotationValue(Annotation var1, String var2, Class<?> var3) throws InjectionException;

    @Override
    public void processClassAnnotation(Object instance, Class clazz, Annotation annotation) {
    }

    public String getJNDIName(Object instance, String name, Field field) {
        if (name != null && name.length() > 0) {
            return name;
        }
        return instance.getClass().getName() + "/" + field.getName();
    }

    public String getJNDIName(Object instance, String name, Method method) {
        if (name != null && name.length() > 0) {
            return name;
        }
        String propName = method.getName();
        propName = propName.substring(3);
        propName = Character.toLowerCase(propName.charAt(0)) + propName.substring(1);
        return instance.getClass().getName() + "/" + propName;
    }

    public Class<?> getType(Class<?> type, Field field) {
        return type == null || Object.class == type ? field.getType() : type;
    }

    public Class<?> getType(Class<?> type, Method method) {
        return type == null || Object.class == type ? method.getParameterTypes()[0] : type;
    }

    protected void injectField(Object instance, Field field, Annotation annotation, String name, Class<?> type) throws InjectionException {
        String jndiName = this.getJNDIName(instance, name, field);
        Object lookedupResource = this.getAnnotationValue(annotation, jndiName, this.getType(type, field));
        boolean accessibility = field.isAccessible();
        try {
            field.setAccessible(true);
            field.set(instance, lookedupResource);
        }
        catch (IllegalArgumentException e) {
            throw new InjectionException("Field injection failed", e);
        }
        catch (IllegalAccessException e) {
            throw new InjectionException("Field injection failed", e);
        }
        finally {
            field.setAccessible(accessibility);
        }
    }

    protected void injectMethod(Object instance, Method method, Annotation annotation, String name, Class<?> type) throws InjectionException {
        if (!method.getName().startsWith("set") || method.getParameterTypes().length != 1 || !method.getReturnType().equals(Void.class)) {
            throw new IllegalArgumentException("Invalid method resource injection annotation");
        }
        String jndiName = this.getJNDIName(instance, name, method);
        Object lookedupResource = this.getAnnotationValue(annotation, jndiName, this.getType(type, method));
        boolean accessibility = method.isAccessible();
        try {
            method.setAccessible(true);
            method.invoke(instance, lookedupResource);
        }
        catch (IllegalArgumentException e) {
            throw new InjectionException("Method injection failed", e);
        }
        catch (IllegalAccessException e) {
            throw new InjectionException("Method injection failed", e);
        }
        catch (InvocationTargetException e) {
            throw new InjectionException("Method injection failed", e);
        }
        finally {
            method.setAccessible(accessibility);
        }
    }
}

