/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.geronimo.jaxws.annotations.AnnotationException;
import org.apache.geronimo.jaxws.annotations.AnnotationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotationProcessor.class);
    private Map<Class<? extends Annotation>, AnnotationHandler> handlers = new HashMap<Class<? extends Annotation>, AnnotationHandler>();

    public void registerHandler(AnnotationHandler handler) {
        this.handlers.put(handler.getAnnotationType(), handler);
    }

    public void processAnnotations(Object instance) throws AnnotationException {
        Class<?> clazz = instance.getClass();
        for (Map.Entry<Class<? extends Annotation>, AnnotationHandler> entry : this.handlers.entrySet()) {
            Class<? extends Annotation> annotationType = entry.getKey();
            AnnotationHandler handler = entry.getValue();
            if (!clazz.isAnnotationPresent(annotationType)) continue;
            Annotation annotation = clazz.getAnnotation(annotationType);
            handler.processClassAnnotation(instance, clazz, annotation);
        }
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            for (Map.Entry<Class<? extends Annotation>, AnnotationHandler> entry : this.handlers.entrySet()) {
                Class<? extends Annotation> annotationType = entry.getKey();
                AnnotationHandler handler = entry.getValue();
                if (!fields[i].isAnnotationPresent(annotationType)) continue;
                Annotation annotation = fields[i].getAnnotation(annotationType);
                handler.processFieldAnnotation(instance, fields[i], annotation);
            }
        }
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            for (Map.Entry<Class<? extends Annotation>, AnnotationHandler> entry : this.handlers.entrySet()) {
                Class<? extends Annotation> annotationType = entry.getKey();
                AnnotationHandler handler = entry.getValue();
                if (!methods[i].isAnnotationPresent(annotationType)) continue;
                Annotation annotation = methods[i].getAnnotation(annotationType);
                handler.processMethodAnnotation(instance, methods[i], annotation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokePostConstruct(Object instance) {
        for (Method method : this.getMethods(instance.getClass(), PostConstruct.class)) {
            PostConstruct pc = method.getAnnotation(PostConstruct.class);
            if (pc == null) continue;
            boolean accessible = method.isAccessible();
            try {
                method.setAccessible(true);
                method.invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException e) {
                LOG.warn("@PostConstruct method is not visible: " + method);
            }
            catch (InvocationTargetException e) {
                LOG.warn("@PostConstruct method threw exception", (Throwable)e);
            }
            finally {
                method.setAccessible(accessible);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokePreDestroy(Object instance) {
        for (Method method : this.getMethods(instance.getClass(), PreDestroy.class)) {
            PreDestroy pc = method.getAnnotation(PreDestroy.class);
            if (pc == null) continue;
            boolean accessible = method.isAccessible();
            try {
                method.setAccessible(true);
                method.invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException e) {
                LOG.warn("@PreDestroy method is not visible: " + method);
            }
            catch (InvocationTargetException e) {
                LOG.warn("@PreDestroy method threw exception", (Throwable)e);
            }
            finally {
                method.setAccessible(accessible);
            }
        }
    }

    private Collection<Method> getMethods(Class target, Class<? extends Annotation> annotationType) {
        HashSet<Method> methods = new HashSet<Method>();
        this.addMethods(target.getMethods(), annotationType, methods);
        this.addMethods(target.getDeclaredMethods(), annotationType, methods);
        return methods;
    }

    private void addMethods(Method[] methods, Class<? extends Annotation> annotationType, Collection<Method> methodsCol) {
        for (Method method : methods) {
            if (!method.isAnnotationPresent(annotationType)) continue;
            methodsCol.add(method);
        }
    }
}

