/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.jaxws.JAXWSApplicationContext;
import org.apache.geronimo.jaxws.PortInfo;
import org.osgi.framework.Bundle;

@GBean(name="JAXWSWebApplicationContext", j2eeType="JAXWSWebApplicationContext")
public class JAXWSWebApplicationContext
implements JAXWSApplicationContext,
GBeanLifecycle {
    private static Map<String, JAXWSWebApplicationContext> webModuleNameJAXWSWebApplicationContextMap = new ConcurrentHashMap<String, JAXWSWebApplicationContext>();
    private Bundle bundle;
    private Map<String, PortInfo> servletNamePortInfoMap;
    private String webModuleName;

    public JAXWSWebApplicationContext(@ParamAttribute(name="servletNamePortInfoMap") Map<String, PortInfo> servletNamePortInfoMap, @ParamSpecial(type=SpecialAttributeType.bundle) Bundle bundle, @ParamSpecial(type=SpecialAttributeType.abstractName) AbstractName abName) {
        this.servletNamePortInfoMap = servletNamePortInfoMap;
        this.webModuleName = abName.getNameProperty("WebModule");
    }

    @Override
    public Collection<PortInfo> getPortInfos() {
        return Collections.unmodifiableCollection(this.servletNamePortInfoMap.values());
    }

    @Override
    public Set<String> getIds() {
        return Collections.unmodifiableSet(this.servletNamePortInfoMap.keySet());
    }

    @Override
    public PortInfo getPortInfo(String servletName) {
        return this.servletNamePortInfoMap.get(servletName);
    }

    public void doFail() {
        try {
            this.doStop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doStart() throws Exception {
        webModuleNameJAXWSWebApplicationContextMap.put(this.webModuleName, this);
    }

    public void doStop() throws Exception {
        webModuleNameJAXWSWebApplicationContextMap.remove(this.webModuleName);
    }

    public static JAXWSWebApplicationContext get(String webModuleName) {
        return webModuleNameJAXWSWebApplicationContextMap.get(webModuleName);
    }
}

