/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSDLUtils {
    private static final Logger LOG = LoggerFactory.getLogger(WSDLUtils.class);

    public static void trimDefinition(Definition def, String serviceName, String portName) {
        Map services = def.getServices();
        if (services != null) {
            ArrayList<QName> servicesToRemove = new ArrayList<QName>(services.size());
            for (Map.Entry serviceEntry : services.entrySet()) {
                QName currServiceName = (QName)serviceEntry.getKey();
                if (currServiceName.getLocalPart().equals(serviceName)) {
                    Service service = (Service)serviceEntry.getValue();
                    WSDLUtils.trimService(service, portName);
                    continue;
                }
                servicesToRemove.add(currServiceName);
            }
            for (QName serviceToRemove : servicesToRemove) {
                def.removeService(serviceToRemove);
            }
        }
    }

    public static void trimService(Service service, String portName) {
        Map ports = service.getPorts();
        if (ports != null) {
            ArrayList<String> portsToRemove = new ArrayList<String>(ports.size());
            for (Map.Entry portEntry : ports.entrySet()) {
                String currPortName = (String)portEntry.getKey();
                if (currPortName.equals(portName)) continue;
                portsToRemove.add(currPortName);
            }
            for (String portToRemove : portsToRemove) {
                service.removePort(portToRemove);
            }
        }
    }

    public static void updateLocations(Definition def, String location) {
        Map services = def.getServices();
        if (services != null) {
            for (Map.Entry serviceEntry : services.entrySet()) {
                Service service = (Service)serviceEntry.getValue();
                WSDLUtils.updateLocations(service, location);
            }
        }
    }

    public static void updateLocations(Service service, String location) {
        boolean updated = false;
        Map ports = service.getPorts();
        if (ports != null) {
            for (Map.Entry portEntry : ports.entrySet()) {
                Port port = (Port)portEntry.getValue();
                WSDLUtils.updateLocations(port, location);
            }
        }
    }

    public static void updateLocations(Port port, String location) {
        List exts = port.getExtensibilityElements();
        if (exts != null) {
            for (Object extension : exts) {
                if (extension instanceof SOAP12Address) {
                    ((SOAP12Address)extension).setLocationURI(location);
                    continue;
                }
                if (extension instanceof SOAPAddress) {
                    ((SOAPAddress)extension).setLocationURI(location);
                    continue;
                }
                if (!(extension instanceof HTTPAddress)) continue;
                ((HTTPAddress)extension).setLocationURI(location);
            }
        }
    }
}

