/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws;

import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.geronimo.xbeans.javaee.HandlerChainsDocument;
import org.apache.geronimo.xbeans.javaee.HandlerChainsType;
import org.apache.xmlbeans.XmlException;

public class HandlerChainsUtils {
    public static final QName HANDLER_CHAINS_QNAME = new QName("http://java.sun.com/xml/ns/javaee", "handler-chains");

    private HandlerChainsUtils() {
    }

    public static <T> T toHandlerChains(String xml, Class<T> type) throws JAXBException {
        Object handlerChains = null;
        if (xml != null) {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{type});
            Unmarshaller unmarshaller = ctx.createUnmarshaller();
            StringReader reader = new StringReader(xml);
            StreamSource in = new StreamSource(reader);
            JAXBElement handlerElement = unmarshaller.unmarshal((Source)in, type);
            handlerChains = handlerElement.getValue();
        }
        return (T)handlerChains;
    }

    public static HandlerChainsType getHandlerChains(String xml) throws XmlException {
        HandlerChainsType types = null;
        if (xml != null) {
            try {
                types = HandlerChainsDocument.Factory.parse((String)xml).getHandlerChains();
            }
            catch (XmlException e) {
                types = HandlerChainsType.Factory.parse((String)xml);
            }
        }
        return types;
    }
}

