/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws.wsdl;

import java.io.IOException;
import org.apache.geronimo.jaxws.wsdl.SimpleWSDLLocator;
import org.apache.xml.resolver.Catalog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class CatalogWSDLLocator
extends SimpleWSDLLocator {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogWSDLLocator.class);
    private Catalog catalog;

    public CatalogWSDLLocator(String baseURI, Catalog catalog) {
        super(baseURI);
        this.catalog = catalog;
    }

    protected InputSource resolve(String parentLocation, String importLocation) {
        String resolvedImportLocation = null;
        if (this.catalog != null) {
            try {
                resolvedImportLocation = this.catalog.resolveSystem(importLocation);
                if (resolvedImportLocation == null) {
                    resolvedImportLocation = this.catalog.resolveURI(importLocation);
                }
                if (resolvedImportLocation == null) {
                    resolvedImportLocation = this.catalog.resolvePublic(importLocation, parentLocation);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Catalog resolution failed", e);
            }
        }
        if (resolvedImportLocation == null) {
            return super.resolve(parentLocation, importLocation);
        }
        return super.resolve("", resolvedImportLocation);
    }
}

