/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws.client;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.soap.SOAPBinding;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.geronimo.jaxws.JAXWSUtils;
import org.apache.geronimo.jaxws.client.EndpointInfo;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.jaas.NamedUsernamePasswordCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortMethodInterceptor
implements MethodInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(PortMethodInterceptor.class);
    private Map<Object, EndpointInfo> seiInfoMap;

    public PortMethodInterceptor(Map<Object, EndpointInfo> seiInfoMap) {
        this.seiInfoMap = seiInfoMap;
    }

    public Object intercept(Object target, Method method, Object[] arguments, MethodProxy methodProxy) throws Throwable {
        Class<?> paramType;
        Object proxy = methodProxy.invokeSuper(target, arguments);
        if (method.getName().equals("getPort")) {
            Class<?> paramType2 = method.getParameterTypes()[0];
            if (paramType2.equals(Class.class)) {
                this.setProperties((BindingProvider)proxy, JAXWSUtils.getPortType((Class)arguments[0]));
            } else if (paramType2.equals(QName.class)) {
                if (arguments[0] == null) {
                    this.setProperties((BindingProvider)proxy, JAXWSUtils.getPortType((Class)arguments[1]));
                } else {
                    this.setProperties((BindingProvider)proxy, ((QName)arguments[0]).getLocalPart());
                }
            }
        } else if (method.getName().startsWith("get")) {
            WebEndpoint endpoint = method.getAnnotation(WebEndpoint.class);
            this.setProperties((BindingProvider)proxy, endpoint.name());
        } else if (method.getName().equals("createDispatch") && (paramType = method.getParameterTypes()[0]).equals(QName.class)) {
            this.setProperties((BindingProvider)proxy, ((QName)arguments[0]).getLocalPart());
        }
        return proxy;
    }

    private void setProperties(BindingProvider proxy, QName portType) {
        if (portType == null) {
            return;
        }
        EndpointInfo info = this.seiInfoMap.get(portType);
        this.setProperties(proxy, info);
    }

    private void setProperties(BindingProvider proxy, String portName) {
        if (portName == null) {
            return;
        }
        EndpointInfo info = this.seiInfoMap.get(portName);
        this.setProperties(proxy, info);
    }

    protected void setProperties(BindingProvider proxy, EndpointInfo info) {
        if (info == null) {
            return;
        }
        this.setProperties(proxy, info, info.getProperties());
    }

    protected void setProperties(BindingProvider proxy, EndpointInfo info, Map<String, Object> properties) {
        String credentialsName;
        URL location;
        if (info == null) {
            return;
        }
        boolean enableMTOM = info.isMTOMEnabled();
        if (enableMTOM && proxy.getBinding() instanceof SOAPBinding) {
            ((SOAPBinding)proxy.getBinding()).setMTOMEnabled(enableMTOM);
            LOG.debug("Set mtom property: " + enableMTOM);
        }
        if ((location = info.getLocation()) != null) {
            proxy.getRequestContext().put("javax.xml.ws.service.endpoint.address", location.toString());
            LOG.debug("Set address property: " + location);
        }
        if ((credentialsName = info.getCredentialsName()) != null) {
            NamedUsernamePasswordCredential namedUsernamePasswordCredential = this.findCredential(credentialsName);
            proxy.getRequestContext().put("javax.xml.ws.security.auth.username", namedUsernamePasswordCredential.getUsername());
            proxy.getRequestContext().put("javax.xml.ws.security.auth.password", new String(namedUsernamePasswordCredential.getPassword()));
            LOG.debug("Set username/password property: " + credentialsName);
        }
        if (properties != null) {
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                proxy.getRequestContext().put(entry.getKey(), entry.getValue());
            }
        }
    }

    protected NamedUsernamePasswordCredential findCredential(String credentialsName) {
        Subject subject = ContextManager.getNextCaller();
        if (subject == null) {
            throw new IllegalStateException("Subject missing but authentication turned on");
        }
        Set<NamedUsernamePasswordCredential> creds = subject.getPrivateCredentials(NamedUsernamePasswordCredential.class);
        for (NamedUsernamePasswordCredential namedUsernamePasswordCredential : creds) {
            if (!credentialsName.equals(namedUsernamePasswordCredential.getName())) continue;
            return namedUsernamePasswordCredential;
        }
        throw new IllegalStateException("No NamedUsernamePasswordCredential found for name " + credentialsName);
    }
}

