/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws.client;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.soap.SOAPBinding;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.jaxws.JAXWSUtils;
import org.apache.geronimo.jaxws.client.EndpointInfo;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.jaas.NamedUsernamePasswordCredential;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortMethodInterceptor
implements MethodInterceptor {
    private static final Log LOG = LogFactory.getLog(PortMethodInterceptor.class);
    private Map<Object, EndpointInfo> seiInfoMap;

    public PortMethodInterceptor(Map<Object, EndpointInfo> seiInfoMap) {
        this.seiInfoMap = seiInfoMap;
    }

    public Object intercept(Object target, Method method, Object[] arguments, MethodProxy methodProxy) throws Throwable {
        Object proxy = methodProxy.invokeSuper(target, arguments);
        if (method.getName().equals("getPort")) {
            if (arguments.length == 1) {
                this.setProperties((BindingProvider)proxy, JAXWSUtils.getPortType((Class)arguments[0]));
            } else if (arguments.length == 2) {
                if (arguments[0] == null) {
                    this.setProperties((BindingProvider)proxy, JAXWSUtils.getPortType((Class)arguments[1]));
                } else {
                    this.setProperties((BindingProvider)proxy, ((QName)arguments[0]).getLocalPart());
                }
            }
        } else if (method.getName().startsWith("get")) {
            WebEndpoint endpoint = method.getAnnotation(WebEndpoint.class);
            this.setProperties((BindingProvider)proxy, endpoint.name());
        } else if (method.getName().equals("createDispatch")) {
            this.setProperties((BindingProvider)proxy, ((QName)arguments[0]).getLocalPart());
        }
        return proxy;
    }

    private void setProperties(BindingProvider proxy, QName portType) {
        if (portType == null) {
            return;
        }
        EndpointInfo info = this.seiInfoMap.get(portType);
        this.setProperties(proxy, info);
    }

    private void setProperties(BindingProvider proxy, String portName) {
        if (portName == null) {
            return;
        }
        EndpointInfo info = this.seiInfoMap.get(portName);
        this.setProperties(proxy, info);
    }

    private void setProperties(BindingProvider proxy, EndpointInfo info) {
        String credentialsName;
        URL location;
        if (info == null) {
            return;
        }
        boolean enableMTOM = info.isMTOMEnabled();
        if (enableMTOM && proxy.getBinding() instanceof SOAPBinding) {
            ((SOAPBinding)proxy.getBinding()).setMTOMEnabled(enableMTOM);
            LOG.debug((Object)("Set mtom property: " + enableMTOM));
        }
        if ((location = info.getLocation()) != null) {
            proxy.getRequestContext().put("javax.xml.ws.service.endpoint.address", location.toString());
            LOG.debug((Object)("Set address property: " + location));
        }
        if ((credentialsName = info.getCredentialsName()) != null) {
            Subject subject = ContextManager.getNextCaller();
            if (subject == null) {
                throw new IllegalStateException("Subject missing but authentication turned on");
            }
            Set<NamedUsernamePasswordCredential> creds = subject.getPrivateCredentials(NamedUsernamePasswordCredential.class);
            boolean found = false;
            for (NamedUsernamePasswordCredential namedUsernamePasswordCredential : creds) {
                if (!credentialsName.equals(namedUsernamePasswordCredential.getName())) continue;
                proxy.getRequestContext().put("javax.xml.ws.security.auth.username", namedUsernamePasswordCredential.getUsername());
                proxy.getRequestContext().put("javax.xml.ws.security.auth.password", new String(namedUsernamePasswordCredential.getPassword()));
                LOG.debug((Object)("Set username/password property: " + credentialsName));
                found = true;
                break;
            }
            if (!found) {
                throw new IllegalStateException("no NamedUsernamePasswordCredential found for name " + credentialsName);
            }
        }
    }
}

