/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.WebModule;
import org.apache.geronimo.jaxws.JAXWSUtils;
import org.apache.geronimo.jaxws.PortInfo;
import org.apache.geronimo.jaxws.builder.AbstractWARWebServiceFinder;
import org.apache.openejb.jee.Servlet;
import org.apache.openejb.jee.ServletMapping;
import org.apache.openejb.jee.WebApp;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvancedWARWebServiceFinder
extends AbstractWARWebServiceFinder {
    private static final Logger LOG = LoggerFactory.getLogger(AdvancedWARWebServiceFinder.class);

    @Override
    public Map<String, PortInfo> discoverWebServices(WebModule module, Map<String, String> correctedPortLocations) throws DeploymentException {
        HashMap<String, PortInfo> servletNamePortInfoMap = new HashMap<String, PortInfo>();
        this.discoverPOJOWebServices(module, correctedPortLocations, servletNamePortInfoMap);
        return servletNamePortInfoMap;
    }

    private void discoverPOJOWebServices(WebModule module, Map<String, String> portLocations, Map<String, PortInfo> servletNamePortInfoMap) throws DeploymentException {
        Bundle bundle = module.getEarContext().getDeploymentBundle();
        WebApp webApp = (WebApp)module.getSpecDD();
        Set<String> ignoredEJBWebServiceClassNames = this.getEJBWebServiceClassNames((Module)module);
        if (webApp.isMetadataComplete().booleanValue()) {
            List servletTypes = webApp.getServlet();
            for (Servlet servletType : servletTypes) {
                String servletName = servletType.getServletName().trim();
                PortInfo portInfo = this.getPortInfo(servletType, bundle, portLocations);
                if (portInfo == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found POJO Web Service: {}", (Object)servletName);
                }
                servletNamePortInfoMap.put(servletName, portInfo);
            }
        } else {
            Map<String, List<String>> classServletMap = this.createClassServetMap(webApp);
            List<Class<?>> services = this.discoverWebServices(module);
            String contextRoot = module.getContextRoot();
            for (Class<?> service : services) {
                PortInfo portInfo;
                List<String> mappedServlets;
                if (!JAXWSUtils.isWebService(service)) continue;
                if (ignoredEJBWebServiceClassNames.contains(service.getName())) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Web service " + service.getClass().getName() + "  is ignored as it is also an EJB, it will exposed as an EJB Web Service ");
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Discovered POJO Web Service class: {}", (Object)service.getName());
                }
                if ((mappedServlets = classServletMap.get(service.getName())) == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("POJO Web Service class {} is not mapped to any servlet", (Object)service.getName());
                    }
                    Servlet servlet = new Servlet();
                    servlet.setServletName(service.getName());
                    servlet.setServletClass(service.getName());
                    webApp.getServlet().add(servlet);
                    String location = portLocations.get(service.getName());
                    if (location == null) {
                        location = "/" + JAXWSUtils.getServiceName(service);
                        ServletMapping servletMapping = new ServletMapping();
                        servletMapping.setServletName(service.getName());
                        servletMapping.getUrlPattern().add(location);
                        webApp.getServletMapping().add(servletMapping);
                    } else {
                        LOG.warn("Found <servlet-mapping> {} but corresponding <servlet> {}  was not defined", (Object)location, (Object)service.getName());
                    }
                    portInfo = new PortInfo();
                    portInfo.setLocation(contextRoot + location);
                    portInfo.setHandlerChainsInfo(this.annotationHandlerChainFinder.buildHandlerChainFromClass(service));
                    portInfo.setWsdlService(JAXWSUtils.getServiceQName(service));
                    portInfo.setWsdlPort(JAXWSUtils.getPortQName(service));
                    servletNamePortInfoMap.put(service.getName(), portInfo);
                    continue;
                }
                for (String servlet : mappedServlets) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("POJO Web Service class {} is mapped to {} servlet", (Object)service.getName(), (Object)servlet);
                    }
                    portInfo = this.createPortInfo(servlet, portLocations);
                    portInfo.setWsdlService(JAXWSUtils.getServiceQName(service));
                    portInfo.setWsdlPort(JAXWSUtils.getPortQName(service));
                    servletNamePortInfoMap.put(servlet, portInfo);
                }
            }
            List servletTypes = webApp.getServlet();
            for (Servlet servletType : servletTypes) {
                PortInfo portInfo;
                String servletName = servletType.getServletName().trim();
                if (servletNamePortInfoMap.get(servletName) != null || (portInfo = this.getPortInfo(servletType, bundle, portLocations)) == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found POJO Web Service: {}", (Object)servletName);
                }
                servletNamePortInfoMap.put(servletName, portInfo);
            }
        }
    }

    private PortInfo getPortInfo(Servlet servletType, Bundle bundle, Map<String, String> portLocations) throws DeploymentException {
        PortInfo portInfo = null;
        if (servletType.getServletClass() != null) {
            String servletClassName = servletType.getServletClass().trim();
            try {
                Class servletClass = bundle.loadClass(servletClassName);
                if (JAXWSUtils.isWebService((Class)servletClass)) {
                    String servletName = servletType.getServletName().trim();
                    portInfo = this.createPortInfo(servletName, portLocations);
                    portInfo.setHandlerChainsInfo(this.annotationHandlerChainFinder.buildHandlerChainFromClass(servletClass));
                    portInfo.setWsdlService(JAXWSUtils.getServiceQName((Class)servletClass));
                    portInfo.setWsdlPort(JAXWSUtils.getPortQName((Class)servletClass));
                }
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("Failed to load servlet class " + servletClassName, (Throwable)e);
            }
        }
        return portInfo;
    }

    private PortInfo createPortInfo(String servlet, Map<String, String> portLocations) {
        PortInfo portInfo = new PortInfo();
        String location = portLocations.get(servlet);
        if (location != null) {
            portInfo.setLocation(location);
        }
        return portInfo;
    }

    private Map<String, List<String>> createClassServetMap(WebApp webApp) {
        HashMap<String, List<String>> classServletNameMap = new HashMap<String, List<String>>();
        List servletTypes = webApp.getServlet();
        if (servletTypes != null) {
            for (Servlet servletType : servletTypes) {
                String servletName = servletType.getServletName().trim();
                if (servletType.getServletClass() == null) continue;
                String servletClassName = servletType.getServletClass().trim();
                ArrayList<String> servlets = (ArrayList<String>)classServletNameMap.get(servletClassName);
                if (servlets == null) {
                    servlets = new ArrayList<String>();
                    classServletNameMap.put(servletClassName, servlets);
                }
                servlets.add(servletName);
            }
        }
        return classServletNameMap;
    }
}

