/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws.builder;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.handler.Handler;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.jaxws.HandlerChainsUtils;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.naming.deployment.AbstractNamingBuilder;
import org.apache.geronimo.naming.deployment.ServiceRefBuilder;
import org.apache.geronimo.schema.NamespaceElementConverter;
import org.apache.geronimo.xbeans.geronimo.naming.GerServiceRefDocument;
import org.apache.geronimo.xbeans.geronimo.naming.GerServiceRefType;
import org.apache.geronimo.xbeans.javaee6.HandlerChainType;
import org.apache.geronimo.xbeans.javaee6.HandlerChainsType;
import org.apache.geronimo.xbeans.javaee6.HandlerType;
import org.apache.geronimo.xbeans.javaee6.PortComponentRefType;
import org.apache.geronimo.xbeans.javaee6.ServiceRefType;
import org.apache.geronimo.xbeans.javaee6.String;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JAXWSServiceRefBuilder
extends AbstractNamingBuilder
implements ServiceRefBuilder {
    private static final Logger log = LoggerFactory.getLogger(JAXWSServiceRefBuilder.class);
    private static final QName GER_SERVICE_REF_QNAME = GerServiceRefDocument.type.getDocumentElementName();
    private static final QNameSet GER_SERVICE_REF_QNAME_SET = QNameSet.singleton((QName)GER_SERVICE_REF_QNAME);
    private final QNameSet serviceRefQNameSet;

    public JAXWSServiceRefBuilder(Environment defaultEnvironment, java.lang.String[] eeNamespaces) {
        super(defaultEnvironment);
        this.serviceRefQNameSet = JAXWSServiceRefBuilder.buildQNameSet((java.lang.String[])eeNamespaces, (java.lang.String)"service-ref");
    }

    protected boolean willMergeEnvironment(XmlObject specDD, XmlObject plan) {
        return specDD.selectChildren(this.serviceRefQNameSet).length > 0;
    }

    public void buildNaming(XmlObject specDD, XmlObject plan, Module module, Map<EARContext.Key, Object> componentContext) throws DeploymentException {
        List serviceRefsUntyped = JAXWSServiceRefBuilder.convert((XmlObject[])specDD.selectChildren(this.serviceRefQNameSet), (NamespaceElementConverter)JEE_CONVERTER, ServiceRefType.class, (SchemaType)ServiceRefType.type);
        XmlObject[] gerServiceRefsUntyped = plan == null ? NO_REFS : plan.selectChildren(GER_SERVICE_REF_QNAME_SET);
        Map<java.lang.String, GerServiceRefType> serviceRefMap = JAXWSServiceRefBuilder.mapServiceRefs(gerServiceRefsUntyped);
        for (ServiceRefType serviceRef : serviceRefsUntyped) {
            java.lang.String name = JAXWSServiceRefBuilder.getStringValue((String)serviceRef.getServiceRefName());
            this.addInjections(name, serviceRef.getInjectionTargetArray(), componentContext);
            GerServiceRefType serviceRefType = serviceRefMap.remove(name);
            this.buildNaming(serviceRef, serviceRefType, module, componentContext);
        }
        if (serviceRefMap.size() > 0) {
            log.warn("Failed to build reference to service reference " + serviceRefMap.keySet() + " defined in plan file, reason - corresponding entry in deployment descriptor missing.");
        }
    }

    private Class loadClass(java.lang.String className, Bundle bundle, java.lang.String classDescription) throws DeploymentException {
        try {
            return bundle.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("Could not load " + classDescription + " class " + className, (Throwable)e);
        }
    }

    public void buildNaming(XmlObject serviceRef, GerServiceRefType gerServiceRefType, Module module, Map componentContext) throws DeploymentException {
        ServiceRefType serviceRefType = (ServiceRefType)JAXWSServiceRefBuilder.convert((XmlObject)serviceRef, (NamespaceElementConverter)JEE_CONVERTER, (SchemaType)ServiceRefType.type);
        this.buildNaming(serviceRefType, gerServiceRefType, module, (Map<EARContext.Key, Object>)componentContext);
    }

    public void buildNaming(ServiceRefType serviceRef, GerServiceRefType gerServiceRef, Module module, Map<EARContext.Key, Object> componentContext) throws DeploymentException {
        Bundle bundle = module.getEarContext().getDeploymentBundle();
        java.lang.String name = JAXWSServiceRefBuilder.getStringValue((String)serviceRef.getServiceRefName());
        java.lang.String serviceInterfaceName = JAXWSServiceRefBuilder.getStringValue((String)serviceRef.getServiceInterface());
        Class serviceInterfaceClass = this.loadClass(serviceInterfaceName, bundle, "service");
        if (!Service.class.isAssignableFrom(serviceInterfaceClass)) {
            throw new DeploymentException(serviceInterfaceName + " service class does not extend " + Service.class.getName());
        }
        QName serviceQName = null;
        if (serviceRef.isSetServiceQname()) {
            serviceQName = serviceRef.getServiceQname().getQNameValue();
        }
        URI wsdlURI = null;
        if (serviceRef.isSetWsdlFile()) {
            java.lang.String wsdlLocation = serviceRef.getWsdlFile().getStringValue().trim();
            try {
                wsdlURI = new URI(wsdlLocation);
            }
            catch (URISyntaxException e) {
                throw new DeploymentException("Could not construct WSDL URI from " + wsdlLocation, (Throwable)e);
            }
        }
        Class serviceReferenceType = null;
        if (serviceRef.isSetServiceRefType()) {
            java.lang.String referenceClassName = JAXWSServiceRefBuilder.getStringValue((String)serviceRef.getServiceRefType());
            serviceReferenceType = this.loadClass(referenceClassName, bundle, "service reference");
        }
        if (serviceRef.isSetHandlerChains()) {
            HandlerChainsType handlerChains = serviceRef.getHandlerChains();
            for (HandlerChainType handlerChain : handlerChains.getHandlerChainArray()) {
                for (HandlerType handler : handlerChain.getHandlerArray()) {
                    java.lang.String handlerClassName = JAXWSServiceRefBuilder.getStringValue((String)handler.getHandlerClass());
                    Class handlerClass = this.loadClass(handlerClassName, bundle, "handler");
                    if (Handler.class.isAssignableFrom(handlerClass)) continue;
                    throw new DeploymentException(handlerClassName + " handler class does not extend " + Handler.class.getName());
                }
            }
        }
        HashMap<Class, PortComponentRefType> portComponentRefMap = new HashMap<Class, PortComponentRefType>();
        PortComponentRefType[] portComponentRefs = serviceRef.getPortComponentRefArray();
        if (portComponentRefs != null) {
            for (int j = 0; j < portComponentRefs.length; ++j) {
                PortComponentRefType portComponentRef = portComponentRefs[j];
                java.lang.String serviceEndpointInterfaceType = JAXWSServiceRefBuilder.getStringValue((String)portComponentRef.getServiceEndpointInterface());
                Class serviceEndpointClass = this.loadClass(serviceEndpointInterfaceType, bundle, "service endpoint");
                portComponentRefMap.put(serviceEndpointClass, portComponentRef);
            }
        }
        Object ref = this.createService(serviceRef, gerServiceRef, module, bundle, serviceInterfaceClass, serviceQName, wsdlURI, serviceReferenceType, portComponentRefMap);
        this.put(name, ref, this.getJndiContextMap(componentContext));
    }

    public abstract Object createService(ServiceRefType var1, GerServiceRefType var2, Module var3, Bundle var4, Class var5, QName var6, URI var7, Class var8, Map<Class, PortComponentRefType> var9) throws DeploymentException;

    private static Map<java.lang.String, GerServiceRefType> mapServiceRefs(XmlObject[] refs) {
        HashMap<java.lang.String, GerServiceRefType> refMap = new HashMap<java.lang.String, GerServiceRefType>();
        if (refs != null) {
            for (int i = 0; i < refs.length; ++i) {
                GerServiceRefType ref = (GerServiceRefType)refs[i].copy().changeType(GerServiceRefType.type);
                java.lang.String serviceRefName = ref.getServiceRefName().trim();
                refMap.put(serviceRefName, ref);
            }
        }
        return refMap;
    }

    public QNameSet getSpecQNameSet() {
        return this.serviceRefQNameSet;
    }

    public QNameSet getPlanQNameSet() {
        return GER_SERVICE_REF_QNAME_SET;
    }

    public static java.lang.String getHandlerChainAsString(HandlerChainsType handlerChains) throws IOException {
        java.lang.String xml = null;
        if (handlerChains != null) {
            StringWriter w = new StringWriter();
            XmlOptions options = new XmlOptions();
            options.setSaveSyntheticDocumentElement(HandlerChainsUtils.HANDLER_CHAINS_QNAME);
            handlerChains.save((Writer)w, options);
            xml = w.toString();
        }
        return xml;
    }
}

