/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws.builder;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class GShellCommandRegistration {
    private static final String INDENT = "    ";

    private static boolean updateClassworlds(File classworldsFile, String classworlsTest, String classworlds) throws Exception {
        boolean updated = GShellCommandRegistration.checkClassworlds(classworldsFile, classworlsTest);
        if (updated) {
            return false;
        }
        File tmpFile = new File(classworldsFile.getAbsolutePath() + ".tmp");
        PrintWriter writer = new PrintWriter(new FileWriter(tmpFile));
        BufferedReader reader = new BufferedReader(new FileReader(classworldsFile));
        boolean inGShellSection = false;
        String line = null;
        while ((line = reader.readLine()) != null) {
            writer.println(line);
            if (line.startsWith("[gshell]")) {
                inGShellSection = true;
                continue;
            }
            if (line.startsWith("[")) {
                inGShellSection = false;
                continue;
            }
            if (!inGShellSection || line.startsWith(INDENT)) continue;
        }
        if (inGShellSection) {
            writer.println(INDENT + classworlds);
        }
        while ((line = reader.readLine()) != null) {
            writer.println(line);
        }
        reader.close();
        writer.close();
        GShellCommandRegistration.switchFile(tmpFile, classworldsFile);
        return true;
    }

    private static boolean checkClassworlds(File classworldsFile, String classworlsTest) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(classworldsFile));
        String line = null;
        boolean matches = false;
        while ((line = reader.readLine()) != null) {
            if (!line.matches(classworlsTest)) continue;
            matches = true;
            break;
        }
        reader.close();
        return matches;
    }

    private static void switchFile(File tmpFile, File realFile) {
        realFile.delete();
        if (!tmpFile.renameTo(realFile)) {
            throw new RuntimeException("Failed to rename " + tmpFile + " to " + realFile);
        }
    }

    public static void main(String[] args) throws Exception {
        File classworldsFile;
        if (args.length != 2) {
            throw new Exception("Syntax: GShellCommandRegistration <geronimo_home> <properties file>");
        }
        String baseDir = args[0];
        String propsFile = args[1];
        ClassLoader loader = GShellCommandRegistration.class.getClassLoader();
        InputStream in = loader.getResourceAsStream(propsFile);
        if (in == null) {
            in = new FileInputStream(propsFile);
        }
        Properties p = new Properties();
        p.load(in);
        String layoutCommands = p.getProperty("layout");
        if (layoutCommands != null) {
            String[] commands;
            File layoutFile = new File(baseDir, "etc/layout.xml");
            Layout layout = new Layout(layoutFile);
            boolean modified = false;
            for (String command : commands = layoutCommands.split(",")) {
                if ((command = command.trim()).length() == 0) continue;
                String[] cmd = command.split(" ");
                String operation = cmd[0];
                if ("addCommand".equals(operation)) {
                    String groupName;
                    String string = groupName = cmd.length > 3 ? cmd[3] : null;
                    if (!layout.addCommand(cmd[1], cmd[2], groupName)) continue;
                    modified = true;
                    continue;
                }
                throw new Exception("Unsupported layout command: " + operation);
            }
            if (modified) {
                System.out.println("Updated layout.xml");
                layout.save();
            }
        }
        String classworldsRegExTest = p.getProperty("classworldsRegExTest");
        String classworldsEntry = p.getProperty("classworldsEntry");
        if (classworldsRegExTest != null && classworldsEntry != null && GShellCommandRegistration.updateClassworlds(classworldsFile = new File(baseDir, "etc/gsh-classworlds.conf"), classworldsRegExTest, classworldsEntry)) {
            System.out.println("Updated gsh-classworlds.conf");
        }
    }

    private static class Layout {
        private File layoutFile;
        private Document layoutDocument;

        public Layout(File layoutFile) throws Exception {
            this.layoutFile = layoutFile;
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            this.layoutDocument = domFactory.newDocumentBuilder().parse(layoutFile);
        }

        public boolean addGroup(String groupName) throws Exception {
            Element group = this.getGroup(groupName);
            if (group == null) {
                Element nodes = this.getNodes(this.layoutDocument.getDocumentElement());
                nodes.appendChild(this.createGroup(groupName));
                return true;
            }
            return false;
        }

        public Element getGroup(String groupName) throws Exception {
            return this.getElement(this.layoutDocument, "//layout/nodes/group/name[contains(.,'" + groupName + "')]/..");
        }

        public boolean addCommand(String commandName, String commandId, String groupName) throws Exception {
            Element nodes;
            if (groupName == null) {
                Element nodes2 = this.getNodes(this.layoutDocument.getDocumentElement());
                return this.addCommand(nodes2, commandName, commandId);
            }
            Element group = this.getGroup(groupName);
            if (group == null) {
                nodes = this.getNodes(this.layoutDocument.getDocumentElement());
                group = this.createGroup(groupName);
                nodes.appendChild(group);
            }
            if ((nodes = this.getNodes(group)) == null) {
                nodes = this.layoutDocument.createElement("nodes");
                group.appendChild(nodes);
                nodes.appendChild(this.createCommand(commandName, commandId));
                return true;
            }
            return this.addCommand(nodes, commandName, commandId);
        }

        private boolean addCommand(Element nodes, String commandName, String commandId) throws Exception {
            Element command = this.getCommand(nodes, commandName);
            if (command == null) {
                nodes.appendChild(this.createCommand(commandName, commandId));
                return true;
            }
            return false;
        }

        private Element createGroup(String groupName) {
            Element group = this.layoutDocument.createElement("group");
            group.appendChild(this.createElement("name", groupName));
            return group;
        }

        private Element createCommand(String commandName, String commandId) {
            Element command = this.layoutDocument.createElement("command");
            command.appendChild(this.createElement("name", commandName));
            command.appendChild(this.createElement("id", commandId));
            return command;
        }

        private Element createElement(String name, String value) {
            Element node = this.layoutDocument.createElement(name);
            Text text = this.layoutDocument.createTextNode(value);
            node.appendChild(text);
            return node;
        }

        private Element getNodes(Node root) throws Exception {
            return this.getElement(root, "./nodes");
        }

        public Element getCommand(Node root, String name) throws Exception {
            return this.getElement(root, "./command/name[contains(.,'" + name + "')]/..");
        }

        private Element getElement(Node root, String query) throws XPathExpressionException {
            XPathFactory xpathFactory = XPathFactory.newInstance();
            XPath xPath = xpathFactory.newXPath();
            Node node = (Node)xPath.evaluate(query, root, XPathConstants.NODE);
            return (Element)node;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void save() throws Exception {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(this.layoutDocument);
            File tmpFile = new File(this.layoutFile.getAbsolutePath() + ".tmp");
            FileOutputStream out = new FileOutputStream(tmpFile);
            StreamResult result = new StreamResult(out);
            try {
                transformer.transform(source, result);
            }
            finally {
                out.close();
            }
            GShellCommandRegistration.switchFile(tmpFile, this.layoutFile);
        }
    }
}

