/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws.builder;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceClient;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.jaxws.JAXWSUtils;
import org.apache.geronimo.jaxws.client.EndpointInfo;
import org.apache.geronimo.jaxws.wsdl.CatalogJarWSDLLocator;
import org.apache.geronimo.jaxws.wsdl.CatalogWSDLLocator;
import org.apache.geronimo.xbeans.geronimo.naming.GerPortPropertyType;
import org.apache.geronimo.xbeans.geronimo.naming.GerPortType;
import org.apache.geronimo.xbeans.geronimo.naming.GerServiceRefType;
import org.apache.geronimo.xbeans.javaee.PortComponentRefType;
import org.apache.xml.resolver.Catalog;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointInfoBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(EndpointInfoBuilder.class);
    private Module module;
    private ClassLoader classLoader;
    private URI wsdlURI;
    private QName serviceQName;
    private Class serviceClass;
    private GerServiceRefType serviceRefType;
    private Map<Object, EndpointInfo> portInfoMap = new HashMap<Object, EndpointInfo>();
    private Map<Class, PortComponentRefType> portComponentRefMap;

    public EndpointInfoBuilder(Class serviceClass, GerServiceRefType serviceRefType, Map<Class, PortComponentRefType> portComponentRefMap, Module module, ClassLoader classLoader, URI wsdlURI, QName serviceQName) {
        this.serviceClass = serviceClass;
        this.serviceRefType = serviceRefType;
        this.portComponentRefMap = portComponentRefMap;
        this.module = module;
        this.classLoader = classLoader;
        this.wsdlURI = wsdlURI;
        this.serviceQName = serviceQName;
    }

    public URI getWsdlURI() {
        return this.wsdlURI;
    }

    public QName getServiceQName() {
        return this.serviceQName;
    }

    public Map<Object, EndpointInfo> getEndpointInfo() {
        return this.portInfoMap;
    }

    public void build() throws DeploymentException {
        Definition definition;
        WSDLFactory wsdlFactory;
        if (this.wsdlURI == null) {
            if (Service.class.equals((Object)this.serviceClass)) {
                this.serviceQName = new QName("http://noservice", "noservice");
                if (this.serviceRefType != null) {
                    for (GerPortType gerPort : this.serviceRefType.getPortArray()) {
                        String portName = gerPort.getPortName().trim();
                        URL location = this.getLocation(gerPort);
                        String credentialsName = this.getCredentialsName(gerPort);
                        boolean mtomEnabled = this.isMTOMEnabled(portName);
                        Map<String, Object> props = this.getProperties(gerPort);
                        EndpointInfo info = new EndpointInfo(location, credentialsName, mtomEnabled, props);
                        this.portInfoMap.put(portName, info);
                    }
                }
                return;
            }
            WebServiceClient webServiceClient = this.serviceClass.getAnnotation(WebServiceClient.class);
            if (webServiceClient != null) {
                this.wsdlURI = this.getWSDLLocation(webServiceClient);
                this.serviceQName = this.getServiceQName(webServiceClient);
            }
            if (this.wsdlURI == null) {
                return;
            }
        }
        Catalog catalog = this.loadCatalog();
        Object wsdlLocator = null;
        wsdlLocator = this.isURL(this.wsdlURI.toString()) ? new CatalogWSDLLocator(this.wsdlURI.toString(), catalog) : new CatalogJarWSDLLocator(this.module.getModuleFile(), this.wsdlURI, catalog);
        try {
            wsdlFactory = WSDLFactory.newInstance();
        }
        catch (WSDLException e) {
            throw new DeploymentException("Could not create WSDLFactory", (Throwable)e);
        }
        WSDLReader wsdlReader = wsdlFactory.newWSDLReader();
        wsdlReader.setFeature("javax.wsdl.importDocuments", true);
        wsdlReader.setFeature("javax.wsdl.verbose", false);
        try {
            definition = wsdlReader.readWSDL((WSDLLocator)wsdlLocator);
        }
        catch (WSDLException e) {
            throw new DeploymentException("Failed to read wsdl document", (Throwable)e);
        }
        catch (RuntimeException e) {
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
        this.verifyPortComponentList(definition);
        Map services = definition.getServices();
        if (services.size() == 0) {
            if (this.serviceRefType != null && this.serviceRefType.isSetServiceCompletion()) {
                LOG.warn("Service completion is not supported with partial wsdl");
            }
        } else {
            String portName;
            if (this.serviceRefType != null && this.serviceRefType.isSetServiceCompletion()) {
                throw new DeploymentException("Full wsdl, but service completion supplied");
            }
            javax.wsdl.Service service = null;
            if (this.serviceQName != null) {
                service = definition.getService(this.serviceQName);
                if (service == null) {
                    throw new DeploymentException("No service wsdl for supplied service qname " + this.serviceQName);
                }
            } else if (services.size() == 1) {
                service = (javax.wsdl.Service)services.values().iterator().next();
                this.serviceQName = service.getQName();
            } else {
                throw new DeploymentException("No service qname supplied, and there are " + services.size() + " services");
            }
            HashMap<String, GerPortType> portMap = new HashMap<String, GerPortType>();
            if (this.serviceRefType != null) {
                GerPortType[] ports = this.serviceRefType.getPortArray();
                for (int i = 0; i < ports.length; ++i) {
                    GerPortType port = ports[i];
                    portName = port.getPortName().trim();
                    portMap.put(portName, port);
                }
            }
            Map wsdlPortMap = service.getPorts();
            for (Map.Entry entry : wsdlPortMap.entrySet()) {
                portName = (String)entry.getKey();
                Port port = (Port)entry.getValue();
                GerPortType gerPort = (GerPortType)portMap.get(portName);
                URL location = gerPort == null ? this.getAddressLocation(port) : this.getLocation(gerPort);
                if (location == null) continue;
                String credentialsName = gerPort == null ? null : this.getCredentialsName(gerPort);
                Binding binding = port.getBinding();
                if (binding == null) {
                    throw new DeploymentException("No binding for port: " + portName);
                }
                PortType portType = binding.getPortType();
                if (portType == null) {
                    throw new DeploymentException("No portType for binding: " + binding.getQName());
                }
                boolean mtomEnabled = this.isMTOMEnabled(portType.getQName());
                Map<String, Object> props = this.getProperties(gerPort);
                EndpointInfo info = new EndpointInfo(location, credentialsName, mtomEnabled, props);
                this.portInfoMap.put(portName, info);
                if (this.portInfoMap.containsKey(portType.getQName())) continue;
                this.portInfoMap.put(portType.getQName(), info);
            }
        }
    }

    private QName getServiceQName(WebServiceClient webServiceClient) {
        if (webServiceClient.targetNamespace() != null && webServiceClient.name() != null) {
            return new QName(webServiceClient.targetNamespace(), webServiceClient.name());
        }
        return null;
    }

    private URI getWSDLLocation(WebServiceClient webServiceClient) throws DeploymentException {
        String wsdlLocation = webServiceClient.wsdlLocation();
        if (wsdlLocation != null && wsdlLocation.trim().length() > 0) {
            try {
                return new URI(wsdlLocation.trim());
            }
            catch (URISyntaxException e) {
                throw new DeploymentException("Invalid wsdl location in annotation: " + wsdlLocation, (Throwable)e);
            }
        }
        return null;
    }

    private Map<String, Object> getProperties(GerPortType port) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (port != null && port.getPropertyArray() != null) {
            for (GerPortPropertyType propertyType : port.getPropertyArray()) {
                props.put(propertyType.getName(), propertyType.getStringValue().trim());
            }
        }
        return props;
    }

    private String getCredentialsName(GerPortType port) {
        String credentialsName = port.getCredentialsName();
        return credentialsName == null ? null : credentialsName.trim();
    }

    private URL getLocation(GerPortType port) throws DeploymentException {
        String protocol = port.getProtocol().trim();
        String host = port.getHost().trim();
        int portNum = port.getPort();
        String uri = port.getUri().trim();
        String locationURIString = protocol + "://" + host + ":" + portNum + uri;
        URL location = this.getURL(locationURIString);
        return location;
    }

    private URL getAddressLocation(Port port) throws DeploymentException {
        SOAPAddress soapAddress = (SOAPAddress)EndpointInfoBuilder.getExtensibilityElement(SOAPAddress.class, port.getExtensibilityElements());
        URL location = null;
        if (soapAddress != null) {
            String locationURIString = soapAddress.getLocationURI();
            location = this.getURL(locationURIString);
        }
        return location;
    }

    private URL getURL(String locationURIString) throws DeploymentException {
        try {
            return new URL(locationURIString);
        }
        catch (MalformedURLException e) {
            throw new DeploymentException("Could not construct web service location URL from " + locationURIString, (Throwable)e);
        }
    }

    public static ExtensibilityElement getExtensibilityElement(Class clazz, List extensibilityElements) {
        for (ExtensibilityElement extensibilityElement : extensibilityElements) {
            if (!clazz.isAssignableFrom(extensibilityElement.getClass())) continue;
            return extensibilityElement;
        }
        return null;
    }

    private void verifyPortComponentList(Definition wsdl) throws DeploymentException {
        if (this.portComponentRefMap == null) {
            return;
        }
        for (Class sei : this.portComponentRefMap.keySet()) {
            QName portType = JAXWSUtils.getPortType((Class)sei);
            if (portType == null || wsdl.getPortType(portType) != null) continue;
            throw new DeploymentException("No portType found in WSDL for SEI: " + sei.getName());
        }
    }

    private boolean isMTOMEnabled(QName portType) {
        boolean mtomEnabled = false;
        PortComponentRefType portRef = this.getPortComponentRef(portType);
        if (portRef != null && portRef.isSetEnableMtom()) {
            mtomEnabled = portRef.getEnableMtom().getBooleanValue();
        }
        return mtomEnabled;
    }

    private PortComponentRefType getPortComponentRef(QName portType) {
        if (this.portComponentRefMap == null) {
            return null;
        }
        for (Class sei : this.portComponentRefMap.keySet()) {
            QName seiPortType = JAXWSUtils.getPortType((Class)sei);
            if (seiPortType == null || !portType.equals(seiPortType)) continue;
            return this.portComponentRefMap.get(sei);
        }
        return null;
    }

    private boolean isMTOMEnabled(String portName) {
        boolean mtomEnabled = false;
        PortComponentRefType portRef = this.getPortComponentRef(portName);
        if (portRef != null && portRef.isSetEnableMtom()) {
            mtomEnabled = portRef.getEnableMtom().getBooleanValue();
        }
        return mtomEnabled;
    }

    private PortComponentRefType getPortComponentRef(String portName) {
        if (this.portComponentRefMap == null) {
            return null;
        }
        for (Class sei : this.portComponentRefMap.keySet()) {
            QName seiPortType = JAXWSUtils.getPortType((Class)sei);
            if (seiPortType == null || !portName.equals(seiPortType.getLocalPart())) continue;
            return this.portComponentRefMap.get(sei);
        }
        return null;
    }

    private boolean isURL(String name) {
        try {
            new URL(name);
            return true;
        }
        catch (MalformedURLException e1) {
            return false;
        }
    }

    private Catalog loadCatalog() {
        URL catalogURI = null;
        try {
            catalogURI = this.getCatalog("WEB-INF/jax-ws-catalog.xml");
            if (catalogURI == null) {
                catalogURI = this.getCatalog("META-INF/jax-ws-catalog.xml");
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to open OASIS catalog", (Throwable)e);
        }
        CatalogManager catalogManager = new CatalogManager();
        catalogManager.setUseStaticCatalog(false);
        catalogManager.setIgnoreMissingProperties(true);
        CatalogResolver catalogResolver = new CatalogResolver(catalogManager);
        Catalog catalog = catalogResolver.getCatalog();
        if (catalogURI != null) {
            LOG.debug("Found OASIS catalog {} ", (Object)catalogURI);
            try {
                catalog.parseCatalog(catalogURI);
            }
            catch (Exception e) {
                LOG.warn("Failed to read OASIS catalog", (Throwable)e);
            }
        }
        return catalog;
    }

    private URL getCatalog(String name) throws IOException {
        File f;
        URL catalogURL = this.classLoader.getResource(name);
        if (catalogURL == null && (f = this.module.getEarContext().getTargetFile(URI.create(name))).exists()) {
            catalogURL = f.toURL();
        }
        return catalogURL;
    }
}

