/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws.builder;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import javax.jws.WebService;
import javax.xml.ws.WebServiceProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.deployment.util.NestedJarFile;
import org.apache.geronimo.deployment.util.UnpackedJarFile;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.jaxws.PortInfo;
import org.apache.geronimo.jaxws.builder.AdvancedWARWebServiceFinder;
import org.apache.geronimo.jaxws.builder.SimpleWARWebServiceFinder;
import org.apache.geronimo.jaxws.builder.WebServiceFinder;
import org.apache.geronimo.kernel.classloader.JarFileClassLoader;
import org.apache.xbean.finder.ClassFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WARWebServiceFinder
implements WebServiceFinder {
    private static final Log LOG = LogFactory.getLog(WARWebServiceFinder.class);
    private static final WebServiceFinder webServiceFinder = WARWebServiceFinder.getWebServiceFinder();

    private static WebServiceFinder getWebServiceFinder() {
        boolean useSimpleFinder = Boolean.getBoolean("org.apache.geronimo.jaxws.builder.useSimpleFinder");
        WebServiceFinder webServiceFinder = null;
        webServiceFinder = useSimpleFinder ? new SimpleWARWebServiceFinder() : new AdvancedWARWebServiceFinder();
        return webServiceFinder;
    }

    @Override
    public Map<String, PortInfo> discoverWebServices(Module module, boolean isEJB, Map correctedPortLocations) throws DeploymentException {
        return webServiceFinder.discoverWebServices(module, isEJB, correctedPortLocations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<Class> discoverWebServices(JarFile moduleFile, boolean isEJB, ClassLoader parentClassLoader) throws DeploymentException {
        LOG.debug((Object)"Discovering web service classes");
        File tmpDir = null;
        ArrayList<URL> urlList = new ArrayList<URL>();
        if (isEJB) {
            File jarFile = new File(moduleFile.getName());
            try {
                urlList.add(jarFile.toURL());
            }
            catch (MalformedURLException e) {
                throw new DeploymentException((Throwable)e);
            }
        }
        File baseDir = null;
        if (moduleFile instanceof UnpackedJarFile) {
            baseDir = ((UnpackedJarFile)moduleFile).getBaseDir();
        } else if (moduleFile instanceof NestedJarFile && ((NestedJarFile)moduleFile).isUnpacked()) {
            baseDir = new File(moduleFile.getName());
        } else {
            try {
                tmpDir = DeploymentUtil.createTempDir();
                JarFile module = new JarFile(moduleFile.getName());
                DeploymentUtil.unzipToDirectory((ZipFile)module, (File)tmpDir);
            }
            catch (IOException e) {
                if (tmpDir != null) {
                    DeploymentUtil.recursiveDelete((File)tmpDir);
                }
                throw new DeploymentException("Failed to expand the module archive", (Throwable)e);
            }
            baseDir = tmpDir;
        }
        Enumeration<JarEntry> jarEnum = moduleFile.entries();
        while (jarEnum.hasMoreElements()) {
            JarEntry entry = jarEnum.nextElement();
            String name = entry.getName();
            if (name.equals("WEB-INF/classes/")) {
                File classesDir = new File(baseDir, "WEB-INF/classes/");
                try {
                    urlList.add(0, classesDir.toURL());
                }
                catch (MalformedURLException e) {}
                continue;
            }
            if (!name.startsWith("WEB-INF/lib/") || !name.endsWith(".jar")) continue;
            File jarFile = new File(baseDir, name);
            try {
                urlList.add(jarFile.toURL());
            }
            catch (MalformedURLException e) {}
        }
        URL[] urls = urlList.toArray(new URL[0]);
        JarFileClassLoader tempClassLoader = null;
        try {
            tempClassLoader = new JarFileClassLoader(null, urls, parentClassLoader);
            ArrayList<Class> classes = new ArrayList<Class>();
            for (URL url : urlList) {
                try {
                    ClassFinder classFinder = new ClassFinder((ClassLoader)tempClassLoader, Collections.singletonList(url));
                    classes.addAll(classFinder.findAnnotatedClasses(WebService.class));
                    classes.addAll(classFinder.findAnnotatedClasses(WebServiceProvider.class));
                }
                catch (Exception e) {
                    LOG.warn((Object)("Fail to search Web Service in jar [" + url + "]"), (Throwable)e);
                }
            }
            ArrayList<Class> arrayList = classes;
            return arrayList;
        }
        finally {
            if (tempClassLoader != null) {
                try {
                    tempClassLoader.destroy();
                }
                catch (Exception e) {}
            }
            if (tmpDir != null) {
                DeploymentUtil.recursiveDelete((File)tmpDir);
            }
        }
    }
}

