/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.annotation;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.geronimo.j2ee.annotation.Injection;
import org.apache.geronimo.j2ee.annotation.LifecycleMethod;
import org.apache.geronimo.j2ee.annotation.ReferenceType;
import org.apache.webbeans.inject.OWBInjector;
import org.apache.xbean.recipe.ConstructionException;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Holder
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Holder.class);
    public static final Holder EMPTY = new Holder(){};
    private Map<String, Set<Injection>> injectionMap;
    private Map<String, LifecycleMethod> postConstruct;
    private Map<String, LifecycleMethod> preDestroy;

    public Holder() {
    }

    public Holder(Holder source) {
        if (source.getInjectionMap() != null) {
            this.injectionMap = new HashMap<String, Set<Injection>>();
            this.addInjectionMap(source.getInjectionMap());
        }
        if (source.getPostConstruct() != null) {
            this.postConstruct = new HashMap<String, LifecycleMethod>();
            this.addPostConstructs(source.getPostConstruct());
        }
        if (source.getPreDestroy() != null) {
            this.preDestroy = new HashMap<String, LifecycleMethod>();
            this.addPreDestroys(source.getPreDestroy());
        }
    }

    private Set<Injection> getInjectionList(String className) {
        Set<Injection> injections;
        if (this.injectionMap == null) {
            this.injectionMap = new HashMap<String, Set<Injection>>();
        }
        if ((injections = this.injectionMap.get(className)) == null) {
            injections = new HashSet<Injection>();
            this.injectionMap.put(className, injections);
        }
        return injections;
    }

    public void addInjection(String className, Injection newInjection) {
        Set<Injection> injections = this.getInjectionList(className);
        injections.add(newInjection);
    }

    public void addInjections(String className, Collection<Injection> newInjections) {
        Set<Injection> injections = this.getInjectionList(className);
        for (Injection injection : newInjections) {
            injections.add(injection);
        }
    }

    public void addPostConstructs(Map<String, LifecycleMethod> newPostConstructs) {
        this.postConstruct = this.merge(this.postConstruct, newPostConstructs);
    }

    public void addPreDestroys(Map<String, LifecycleMethod> newPreDestroys) {
        this.preDestroy = this.merge(this.preDestroy, newPreDestroys);
    }

    private Map<String, LifecycleMethod> merge(Map<String, LifecycleMethod> old, Map<String, LifecycleMethod> additional) {
        if (old == null) {
            return additional;
        }
        if (additional == null) {
            return old;
        }
        old.putAll(additional);
        return old;
    }

    public void addInjectionMap(Map<String, Set<Injection>> injectionMap) {
        if (injectionMap == null) {
            return;
        }
        for (Map.Entry<String, Set<Injection>> entry : injectionMap.entrySet()) {
            String className = entry.getKey();
            Set<Injection> injections = entry.getValue();
            this.addInjections(className, injections);
        }
    }

    public List<Injection> getInjections(String className) {
        Set<Injection> injections;
        if (this.injectionMap != null && (injections = this.injectionMap.get(className)) != null) {
            return new ArrayList<Injection>(injections);
        }
        return null;
    }

    public Map<String, Set<Injection>> getInjectionMap() {
        return this.injectionMap;
    }

    public Map<String, LifecycleMethod> getPostConstruct() {
        return this.postConstruct;
    }

    public Map<String, LifecycleMethod> getPreDestroy() {
        return this.preDestroy;
    }

    public boolean isEmpty() {
        return !(this.injectionMap != null && !this.injectionMap.isEmpty() || this.postConstruct != null && !this.postConstruct.isEmpty() || this.preDestroy != null && !this.preDestroy.isEmpty());
    }

    public Object newInstance(String className, ClassLoader classLoader, Context context) throws IllegalAccessException, InstantiationException {
        Object result;
        ObjectRecipe objectRecipe = new ObjectRecipe(className);
        objectRecipe.allow(Option.FIELD_INJECTION);
        objectRecipe.allow(Option.PRIVATE_PROPERTIES);
        try {
        }
        catch (ClassNotFoundException e) {
            throw (InstantiationException)new InstantiationException("Can't load class " + className + " in classloader: " + classLoader).initCause(e);
        }
        ArrayList<NamingException> problems = new ArrayList<NamingException>();
        for (Class<?> clazz = classLoader.loadClass(className); clazz != Object.class; clazz = clazz.getSuperclass()) {
            this.addInjections(clazz.getName(), context, objectRecipe, problems);
        }
        if (!problems.isEmpty()) {
            throw new InstantiationException("Some objects to be injected were not found in jndi: " + problems);
        }
        try {
            result = objectRecipe.create(classLoader);
        }
        catch (ConstructionException e) {
            throw (InstantiationException)new InstantiationException("Could not construct object").initCause(e);
        }
        OWBInjector beanInjector = new OWBInjector();
        try {
            beanInjector.inject(result);
        }
        catch (Exception e) {
            throw (InstantiationException)new InstantiationException("web beans injection problem").initCause(e);
        }
        if (this.getPostConstruct() != null) {
            try {
                Holder.apply(result, null, this.postConstruct);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                throw (InstantiationException)new InstantiationException("Could not call postConstruct method").initCause(cause);
            }
        }
        return result;
    }

    private void addInjections(String className, Context context, ObjectRecipe objectRecipe, List<NamingException> problems) {
        List<Injection> callbackHandlerinjections = this.getInjections(className);
        if (callbackHandlerinjections != null) {
            for (Injection injection : callbackHandlerinjections) {
                try {
                    String jndiName = injection.getJndiName();
                    Object object = context.lookup(jndiName);
                    objectRecipe.setProperty(injection.getTargetName(), object);
                }
                catch (NamingException e) {
                    if (injection.getType() != ReferenceType.ENV_ENTRY) {
                        problems.add(e);
                    }
                    log.info("Could not look up " + injection.getJndiName(), (Throwable)e);
                }
            }
        }
    }

    public void destroyInstance(Object o) throws Exception {
        Class<?> clazz = o.getClass();
        Map<String, LifecycleMethod> preDestroy = this.getPreDestroy();
        if (preDestroy != null) {
            Holder.apply(o, clazz, preDestroy);
        }
    }

    public static void apply(Object o, Class<?> clazz, Map<String, LifecycleMethod> map) throws IllegalAccessException, InvocationTargetException {
        if (clazz == null) {
            clazz = o.getClass();
        }
        ArrayList classes = new ArrayList();
        while (clazz != null && clazz != Object.class) {
            classes.add(clazz);
            clazz = clazz.getSuperclass();
        }
        for (int i = classes.size() - 1; i > -1; --i) {
            Class clazz1 = (Class)classes.get(i);
            LifecycleMethod m = map.get(clazz1.getName());
            if (m == null) continue;
            m.call(o, clazz1);
        }
    }
}

