/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.management.impl;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.management.impl.InvalidObjectNameException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.ObjectNameUtil;
import org.apache.geronimo.logging.SystemLog;
import org.apache.geronimo.management.StatisticsProvider;
import org.apache.geronimo.management.geronimo.JVM;
import org.apache.geronimo.management.stats.BoundedRangeStatisticImpl;
import org.apache.geronimo.management.stats.CountStatisticImpl;
import org.apache.geronimo.management.stats.JVMStatsImpl;

public class JVMImpl
implements JVM,
StatisticsProvider {
    public static final String JAVA_VERSION;
    public static final String JAVA_VENDOR;
    public static final String NODE;
    private static final Runtime runtime;
    private final String objectName;
    private final Kernel kernel;
    private final SystemLog systemLog;
    private JVMStatsImpl stats;
    public static final GBeanInfo GBEAN_INFO;

    public JVMImpl(String objectName, Kernel kernel, SystemLog systemLog) {
        this.objectName = objectName;
        this.kernel = kernel;
        this.systemLog = systemLog;
        ObjectName myObjectName = ObjectNameUtil.getObjectName((String)this.objectName);
        this.verifyObjectName(myObjectName);
    }

    private void verifyObjectName(ObjectName objectName) {
        if (objectName.isPattern()) {
            throw new InvalidObjectNameException("ObjectName can not be a pattern", objectName);
        }
        Hashtable<String, String> keyPropertyList = objectName.getKeyPropertyList();
        if (!"JVM".equals(keyPropertyList.get("j2eeType"))) {
            throw new InvalidObjectNameException("JVM object name j2eeType property must be 'JVM'", objectName);
        }
        if (!keyPropertyList.containsKey("name")) {
            throw new InvalidObjectNameException("JVM object must contain a name property", objectName);
        }
        if (!keyPropertyList.containsKey("J2EEServer")) {
            throw new InvalidObjectNameException("JVM object must contain a J2EEServer property", objectName);
        }
        if (keyPropertyList.size() != 3) {
            throw new InvalidObjectNameException("JVM object name can only have J2EEServer, j2eeType, and name", objectName);
        }
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isStateManageable() {
        return true;
    }

    public boolean isStatisticsProvider() {
        return true;
    }

    public boolean isEventProvider() {
        return true;
    }

    public String getJavaVersion() {
        return JAVA_VERSION;
    }

    public String getJavaVendor() {
        return JAVA_VENDOR;
    }

    public String getNode() {
        return NODE;
    }

    public int getAvailableProcessors() {
        return runtime.availableProcessors();
    }

    public Date getKernelBootTime() {
        return this.kernel.getBootTime();
    }

    public Stats getStats() {
        BoundedRangeStatisticImpl heapSize;
        CountStatisticImpl upTime;
        RuntimeMXBean runmxbean = ManagementFactory.getRuntimeMXBean();
        MemoryMXBean memmxbean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memUsage = memmxbean.getHeapMemoryUsage();
        if (this.stats == null) {
            this.stats = new JVMStatsImpl();
            upTime = this.stats.getUpTimeImpl();
            upTime.setStartTime(runmxbean.getStartTime());
            upTime.setCount(runmxbean.getUptime());
            heapSize = this.stats.getHeapSizeImpl();
            heapSize.setStartTime(runmxbean.getStartTime());
            heapSize.setBounds(0L, memUsage.getMax());
            heapSize.setCurrent(memUsage.getUsed());
            heapSize.setLowWaterMark(memUsage.getUsed());
            heapSize.setHighWaterMark(memUsage.getUsed());
        } else {
            upTime = this.stats.getUpTimeImpl();
            upTime.setCount(runmxbean.getUptime());
            heapSize = this.stats.getHeapSizeImpl();
            heapSize.setBounds(0L, memUsage.getMax());
            heapSize.setCurrent(memUsage.getUsed());
        }
        long now = upTime.getStartTime() + upTime.getCount();
        upTime.setLastSampleTime(now);
        heapSize.setLastSampleTime(now);
        return this.stats;
    }

    public void resetStats() {
    }

    public Properties getSystemProperties() {
        return System.getProperties();
    }

    public SystemLog getSystemLog() {
        return this.systemLog;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        String node;
        JAVA_VERSION = System.getProperty("java.version");
        JAVA_VENDOR = System.getProperty("java.vendor");
        runtime = Runtime.getRuntime();
        try {
            node = InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException e) {
            node = null;
        }
        NODE = node;
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(JVMImpl.class, (String)"JVM");
        infoFactory.addReference("SystemLog", SystemLog.class);
        infoFactory.setConstructor(new String[]{"objectName", "kernel", "SystemLog"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

