/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment.annotation;

import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import javax.jws.HandlerChain;
import javax.xml.ws.WebServiceRef;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.j2ee.deployment.annotation.AnnotationHelper;
import org.apache.openejb.jee.HandlerChains;
import org.apache.openejb.jee.JaxbJavaee;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.openejb.jee.ServiceRef;
import org.apache.xbean.finder.AbstractFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HandlerChainAnnotationHelper
extends AnnotationHelper {
    private static final Logger log = LoggerFactory.getLogger(HandlerChainAnnotationHelper.class);

    private HandlerChainAnnotationHelper() {
    }

    public static void processAnnotations(JndiConsumer annotatedApp, AbstractFinder classFinder) throws DeploymentException {
        if (annotatedApp != null && classFinder.isAnnotationPresent(HandlerChain.class)) {
            HandlerChainAnnotationHelper.processHandlerChain(annotatedApp, classFinder);
        }
    }

    private static void processHandlerChain(JndiConsumer annotatedApp, AbstractFinder classFinder) throws DeploymentException {
        HandlerChain handlerChain;
        if (log.isDebugEnabled()) {
            log.debug("processHandlerChain(): Entry: AnnotatedApp: " + annotatedApp.toString());
        }
        List methodswithHandlerChain = classFinder.findAnnotatedMethods(HandlerChain.class);
        List fieldswithHandlerChain = classFinder.findAnnotatedFields(HandlerChain.class);
        for (Method method : methodswithHandlerChain) {
            handlerChain = method.getAnnotation(HandlerChain.class);
            if (handlerChain == null) continue;
            HandlerChainAnnotationHelper.addHandlerChain(annotatedApp, handlerChain, null, method, null);
        }
        for (Field field : fieldswithHandlerChain) {
            handlerChain = field.getAnnotation(HandlerChain.class);
            if (handlerChain == null) continue;
            HandlerChainAnnotationHelper.addHandlerChain(annotatedApp, handlerChain, null, null, field);
        }
        if (log.isDebugEnabled()) {
            log.debug("processHandlerChain(): Exit: AnnotatedApp: " + annotatedApp.toString());
        }
    }

    private static void addHandlerChain(JndiConsumer annotatedApp, HandlerChain annotation, Class cls, Method method, Field field) {
        block25: {
            if (log.isDebugEnabled()) {
                log.debug("addHandlerChain( [annotatedApp] " + annotatedApp.toString() + "," + '\n' + "[annotation] " + annotation.toString() + "," + '\n' + "[cls] " + (cls != null ? cls.getName() : null) + "," + '\n' + "[method] " + (method != null ? method.getName() : null) + "," + '\n' + "[field] " + (field != null ? field.getName() : null) + " ): Entry");
            }
            String handlerChainFile = annotation.file();
            if (log.isDebugEnabled()) {
                log.debug("addHandlerChain(): handlerChainFile: " + handlerChainFile);
            }
            WebServiceRef webServiceRef = null;
            if (method != null) {
                webServiceRef = method.getAnnotation(WebServiceRef.class);
            } else if (field != null) {
                webServiceRef = field.getAnnotation(WebServiceRef.class);
            }
            String serviceRefName = webServiceRef != null ? webServiceRef.name() : annotation.name();
            if (serviceRefName.equals("")) {
                serviceRefName = HandlerChainAnnotationHelper.getInjectionJavaType(method, field);
            }
            if (log.isDebugEnabled()) {
                log.debug("addHandlerChain().serviceRefName : " + serviceRefName);
            }
            if (!serviceRefName.equals("") && !handlerChainFile.equals("")) {
                try {
                    URL url;
                    block24: {
                        url = null;
                        try {
                            url = new URL(handlerChainFile);
                        }
                        catch (MalformedURLException mfe) {
                            if (log.isDebugEnabled()) {
                                log.debug("addHandlerChain().MalformedURLException", (Throwable)mfe);
                            }
                            if (cls != null) {
                                url = HandlerChainAnnotationHelper.getURL(cls.getClass(), handlerChainFile);
                            }
                            if (method != null) {
                                url = HandlerChainAnnotationHelper.getURL(method.getDeclaringClass(), handlerChainFile);
                            }
                            if (field == null) break block24;
                            url = HandlerChainAnnotationHelper.getURL(field.getDeclaringClass(), handlerChainFile);
                        }
                    }
                    if (url != null) {
                        Collection serviceRefs = annotatedApp.getServiceRef();
                        boolean exists = false;
                        for (ServiceRef serviceRef : serviceRefs) {
                            if (!serviceRef.getServiceRefName().trim().equals(serviceRefName) || serviceRef.getHandlerChains() != null) continue;
                            HandlerChainAnnotationHelper.insertHandlers(serviceRef, url);
                            exists = true;
                            break;
                        }
                        if (exists) {
                            if (log.isDebugEnabled()) {
                                log.debug("HandlerChainAnnotationHelper: <service-ref> entry found: " + serviceRefName);
                            }
                        } else if (log.isDebugEnabled()) {
                            log.debug("HandlerChainAnnotationHelper: <service-ref> entry NOT found: " + serviceRefName);
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug("HandlerChainAnnotationHelper: Handler chain file NOT found: " + handlerChainFile);
                    }
                }
                catch (Exception anyException) {
                    if (!log.isDebugEnabled()) break block25;
                    log.debug("HandlerChainAnnotationHelper: Exception caught while processing <handler-chain>", (Throwable)anyException);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("addHandlerChain(): Exit");
        }
    }

    private static URL getURL(Class clazz, String file) {
        URL url;
        if (log.isDebugEnabled()) {
            log.debug("getURL( " + clazz.getName() + ", " + file + " ): Entry");
        }
        if ((url = clazz.getResource(file)) == null) {
            url = Thread.currentThread().getContextClassLoader().getResource(file);
        }
        if (url == null) {
            String loc = clazz.getPackage().getName().replace('.', '/') + "/" + file;
            url = Thread.currentThread().getContextClassLoader().getResource(loc);
        }
        if (log.isDebugEnabled()) {
            log.debug("getURL(): Exit: url: " + (url != null ? url.toString() : null));
        }
        return url;
    }

    public static void insertHandlers(ServiceRef serviceRef, HandlerChain annotation, Class clazz) {
        block7: {
            String handlerChainFile = annotation.file();
            if (log.isDebugEnabled()) {
                log.debug("handlerChainFile: " + handlerChainFile);
            }
            if (handlerChainFile == null || handlerChainFile.trim().length() == 0) {
                return;
            }
            URL url = null;
            try {
                url = new URL(handlerChainFile);
            }
            catch (MalformedURLException mfe) {
                url = HandlerChainAnnotationHelper.getURL(clazz, handlerChainFile);
            }
            if (url != null) {
                try {
                    HandlerChainAnnotationHelper.insertHandlers(serviceRef, url);
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block7;
                    log.debug("Error while processing <handler-chain>", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertHandlers(ServiceRef serviceRef, URL url) throws Exception {
        HandlerChains handlerChains;
        InputStream in = url.openStream();
        try {
            handlerChains = (HandlerChains)JaxbJavaee.unmarshalHandlerChains(HandlerChains.class, (InputStream)in);
        }
        finally {
            in.close();
        }
        serviceRef.setHandlerChains(handlerChains);
    }
}

