/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.ConfigurationBuilder;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.ModuleIDBuilder;
import org.apache.geronimo.deployment.NamespaceDrivenBuilder;
import org.apache.geronimo.deployment.NamespaceDrivenBuilderCollection;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.deployment.xbeans.ArtifactType;
import org.apache.geronimo.deployment.xbeans.EnvironmentType;
import org.apache.geronimo.deployment.xbeans.PatternType;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.ReferencePatterns;
import org.apache.geronimo.gbean.SingleElementCollection;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.j2ee.deployment.ActivationSpecInfoLocator;
import org.apache.geronimo.j2ee.deployment.AppClientModule;
import org.apache.geronimo.j2ee.deployment.ApplicationInfo;
import org.apache.geronimo.j2ee.deployment.ConnectorModule;
import org.apache.geronimo.j2ee.deployment.CorbaGBeanNameSource;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.EJBModule;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.ModuleBuilder;
import org.apache.geronimo.j2ee.deployment.ModuleBuilderExtension;
import org.apache.geronimo.j2ee.deployment.NamingBuilder;
import org.apache.geronimo.j2ee.deployment.WebModule;
import org.apache.geronimo.j2ee.jndi.ApplicationJndi;
import org.apache.geronimo.j2ee.jndi.JndiKey;
import org.apache.geronimo.j2ee.jndi.JndiScope;
import org.apache.geronimo.j2ee.management.impl.J2EEApplicationImpl;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.ConfigurationAlreadyExistsException;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.config.SimpleConfigurationManager;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactResolver;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.repository.MissingDependencyException;
import org.apache.geronimo.kernel.repository.Repository;
import org.apache.geronimo.kernel.util.FileUtils;
import org.apache.geronimo.kernel.util.IOUtils;
import org.apache.geronimo.kernel.util.JarUtils;
import org.apache.geronimo.kernel.util.NestedJarFile;
import org.apache.geronimo.management.J2EEResource;
import org.apache.geronimo.management.J2EEServer;
import org.apache.geronimo.management.geronimo.ResourceAdapterModule;
import org.apache.geronimo.schema.SchemaConversionUtils;
import org.apache.geronimo.xbeans.geronimo.j2ee.GerApplicationDocument;
import org.apache.geronimo.xbeans.geronimo.j2ee.GerApplicationType;
import org.apache.geronimo.xbeans.geronimo.j2ee.GerExtModuleType;
import org.apache.geronimo.xbeans.geronimo.j2ee.GerModuleType;
import org.apache.openejb.jee.Application;
import org.apache.openejb.jee.JaxbJavaee;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.openejb.jee.Web;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@GBean(j2eeType="ConfigBuilder")
public class EARConfigBuilder
implements ConfigurationBuilder,
CorbaGBeanNameSource,
GBeanLifecycle {
    private static final Logger log = LoggerFactory.getLogger(EARConfigBuilder.class);
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final QName APPLICATION_QNAME = GerApplicationDocument.type.getDocumentElementName();
    private static final Map<String, String> NAMESPACE_UPDATES = new HashMap<String, String>();
    private final ConfigurationManager configurationManager;
    private final Collection<? extends Repository> repositories;
    private final SingleElementCollection ejbConfigBuilder;
    private final SingleElementCollection webConfigBuilder;
    private final SingleElementCollection connectorConfigBuilder;
    private final SingleElementCollection appClientConfigBuilder;
    private final SingleElementCollection resourceReferenceBuilder;
    private final NamespaceDrivenBuilderCollection serviceBuilders;
    private final Collection<ModuleBuilderExtension> BValModuleBuilders;
    private final Collection<ModuleBuilderExtension> persistenceUnitBuilders;
    private final NamingBuilder namingBuilders;
    private final Environment defaultEnvironment;
    private final AbstractNameQuery serverName;
    private final AbstractNameQuery transactionManagerObjectName;
    private final AbstractNameQuery connectionTrackerObjectName;
    private final AbstractNameQuery corbaGBeanObjectName;
    private final Naming naming;
    private final Collection<? extends ArtifactResolver> artifactResolvers;
    private final BundleContext bundleContext;
    private final AbstractNameQuery globalContextAbstractName;
    public static ThreadLocal<Boolean> createPlanMode;
    public static ThreadLocal<ApplicationInfo> appInfo;

    public EARConfigBuilder(@ParamAttribute(name="defaultEnvironment") Environment defaultEnvironment, @ParamAttribute(name="transactionManagerAbstractName") AbstractNameQuery transactionManagerAbstractName, @ParamAttribute(name="connectionTrackerAbstractName") AbstractNameQuery connectionTrackerAbstractName, @ParamAttribute(name="corbaGBeanAbstractName") AbstractNameQuery corbaGBeanAbstractName, @ParamAttribute(name="globalContextAbstractName") AbstractNameQuery globalContextAbstractName, @ParamAttribute(name="serverName") AbstractNameQuery serverName, @ParamReference(name="Repositories", namingType="Repository") Collection<? extends Repository> repositories, @ParamReference(name="EJBConfigBuilder", namingType="ModuleBuilder") Collection<ModuleBuilder> ejbConfigBuilder, @ParamReference(name="WebConfigBuilder", namingType="ModuleBuilder") Collection<ModuleBuilder> webConfigBuilder, @ParamReference(name="ConnectorConfigBuilder", namingType="ModuleBuilder") Collection<ModuleBuilder> connectorConfigBuilder, @ParamReference(name="ActivationSpecInfoLocator", namingType="ModuleBuilder") Collection<ModuleBuilder> resourceReferenceBuilder, @ParamReference(name="AppClientConfigBuilder", namingType="ModuleBuilder") Collection<ModuleBuilder> appClientConfigBuilder, @ParamReference(name="ServiceBuilders", namingType="ModuleBuilder") Collection<NamespaceDrivenBuilder> serviceBuilders, @ParamReference(name="BValModuleBuilders", namingType="ModuleBuilder") Collection<ModuleBuilderExtension> BValModuleBuilders, @ParamReference(name="PersistenceUnitBuilders", namingType="ModuleBuilder") Collection<ModuleBuilderExtension> persistenceUnitBuilders, @ParamReference(name="NamingBuilders", namingType="ModuleBuilder") NamingBuilder namingBuilders, @ParamReference(name="ArtifactResolvers", namingType="ArtifactResolver") Collection<? extends ArtifactResolver> artifactResolvers, @ParamSpecial(type=SpecialAttributeType.kernel) Kernel kernel, @ParamSpecial(type=SpecialAttributeType.bundleContext) BundleContext bundleContext) throws GBeanNotFoundException {
        this(defaultEnvironment, transactionManagerAbstractName, connectionTrackerAbstractName, corbaGBeanAbstractName, globalContextAbstractName, serverName, ConfigurationUtil.getConfigurationManager((Kernel)kernel), repositories, new SingleElementCollection(ejbConfigBuilder), new SingleElementCollection(webConfigBuilder), new SingleElementCollection(connectorConfigBuilder), new SingleElementCollection(resourceReferenceBuilder), new SingleElementCollection(appClientConfigBuilder), serviceBuilders, BValModuleBuilders, persistenceUnitBuilders, namingBuilders, kernel.getNaming(), artifactResolvers, bundleContext);
    }

    public EARConfigBuilder(Environment defaultEnvironment, AbstractNameQuery transactionManagerAbstractName, AbstractNameQuery connectionTrackerAbstractName, AbstractNameQuery corbaGBeanAbstractName, AbstractNameQuery serverName, AbstractNameQuery globalContextAbstractName, Collection<? extends Repository> repositories, ModuleBuilder ejbConfigBuilder, ModuleBuilder webConfigBuilder, ModuleBuilder connectorConfigBuilder, ActivationSpecInfoLocator activationSpecInfoLocator, ModuleBuilder appClientConfigBuilder, NamespaceDrivenBuilder serviceBuilder, ModuleBuilderExtension BValModuleBuilder, ModuleBuilderExtension persistenceUnitBuilder, NamingBuilder namingBuilders, Naming naming, Collection<? extends ArtifactResolver> artifactResolvers, BundleContext bundleContext) {
        this(defaultEnvironment, transactionManagerAbstractName, connectionTrackerAbstractName, corbaGBeanAbstractName, globalContextAbstractName, serverName, null, repositories, new SingleElementCollection((Object)ejbConfigBuilder), new SingleElementCollection((Object)webConfigBuilder), new SingleElementCollection((Object)connectorConfigBuilder), new SingleElementCollection((Object)activationSpecInfoLocator), new SingleElementCollection((Object)appClientConfigBuilder), serviceBuilder == null ? Collections.emptySet() : Collections.singleton(serviceBuilder), BValModuleBuilder == null ? Collections.emptySet() : Collections.singleton(BValModuleBuilder), persistenceUnitBuilder == null ? Collections.emptySet() : Collections.singleton(persistenceUnitBuilder), namingBuilders, naming, artifactResolvers, bundleContext);
    }

    private EARConfigBuilder(Environment defaultEnvironment, AbstractNameQuery transactionManagerAbstractName, AbstractNameQuery connectionTrackerAbstractName, AbstractNameQuery corbaGBeanAbstractName, AbstractNameQuery globalContextAbstractName, AbstractNameQuery serverName, ConfigurationManager configurationManager, Collection<? extends Repository> repositories, SingleElementCollection ejbConfigBuilder, SingleElementCollection webConfigBuilder, SingleElementCollection connectorConfigBuilder, SingleElementCollection resourceReferenceBuilder, SingleElementCollection appClientConfigBuilder, Collection<NamespaceDrivenBuilder> serviceBuilders, Collection<ModuleBuilderExtension> BValModuleBuilders, Collection<ModuleBuilderExtension> persistenceUnitBuilders, NamingBuilder namingBuilders, Naming naming, Collection<? extends ArtifactResolver> artifactResolvers, BundleContext bundleContext) {
        this.configurationManager = configurationManager;
        this.repositories = repositories;
        this.defaultEnvironment = defaultEnvironment;
        this.ejbConfigBuilder = ejbConfigBuilder;
        this.resourceReferenceBuilder = resourceReferenceBuilder;
        this.webConfigBuilder = webConfigBuilder;
        this.connectorConfigBuilder = connectorConfigBuilder;
        this.appClientConfigBuilder = appClientConfigBuilder;
        this.serviceBuilders = new NamespaceDrivenBuilderCollection(serviceBuilders);
        this.BValModuleBuilders = BValModuleBuilders;
        this.persistenceUnitBuilders = persistenceUnitBuilders;
        this.namingBuilders = namingBuilders;
        this.transactionManagerObjectName = transactionManagerAbstractName;
        this.connectionTrackerObjectName = connectionTrackerAbstractName;
        this.corbaGBeanObjectName = corbaGBeanAbstractName;
        this.globalContextAbstractName = globalContextAbstractName;
        this.serverName = serverName;
        this.naming = naming;
        this.artifactResolvers = artifactResolvers;
        this.bundleContext = bundleContext;
    }

    public void doStart() throws Exception {
        XmlBeansUtil.registerNamespaceUpdates(NAMESPACE_UPDATES);
    }

    public void doStop() {
        XmlBeansUtil.unregisterNamespaceUpdates(NAMESPACE_UPDATES);
    }

    public void doFail() {
        this.doStop();
    }

    @Override
    public AbstractNameQuery getCorbaGBeanName() {
        return this.corbaGBeanObjectName;
    }

    private ModuleBuilder getEjbConfigBuilder() {
        return (ModuleBuilder)this.ejbConfigBuilder.getElement();
    }

    private ModuleBuilder getWebConfigBuilder() {
        return (ModuleBuilder)this.webConfigBuilder.getElement();
    }

    private ModuleBuilder getConnectorConfigBuilder() {
        return (ModuleBuilder)this.connectorConfigBuilder.getElement();
    }

    private ModuleBuilder getAppClientConfigBuilder() {
        return (ModuleBuilder)this.appClientConfigBuilder.getElement();
    }

    public Object getDeploymentPlan(File planFile, JarFile jarFile, ModuleIDBuilder idBuilder) throws DeploymentException {
        if (planFile == null && jarFile == null) {
            return null;
        }
        ApplicationInfo plan = this.getEarPlan(planFile, jarFile, idBuilder);
        if (plan != null) {
            return plan;
        }
        if (jarFile == null) {
            return null;
        }
        Module module = null;
        if (this.getWebConfigBuilder() != null) {
            module = this.getWebConfigBuilder().createModule(planFile, jarFile, this.naming, idBuilder);
        }
        if (module == null && this.getEjbConfigBuilder() != null) {
            module = this.getEjbConfigBuilder().createModule(planFile, jarFile, this.naming, idBuilder);
        }
        if (module == null && this.getConnectorConfigBuilder() != null) {
            module = this.getConnectorConfigBuilder().createModule(planFile, jarFile, this.naming, idBuilder);
        }
        if (module == null && this.getAppClientConfigBuilder() != null) {
            module = this.getAppClientConfigBuilder().createModule(planFile, jarFile, this.naming, idBuilder);
        }
        if (module == null) {
            return null;
        }
        if (module instanceof ApplicationInfo) {
            return module;
        }
        Map<JndiKey, Map<String, Object>> jndiContext = Module.share(Module.APP, module.getJndiContext());
        ApplicationInfo applicationInfo = new ApplicationInfo(module.getType(), module.getEnvironment(), module.getModuleName(), module.getName(), jarFile, null, null, null, jndiContext);
        applicationInfo.getModules().add(module);
        return applicationInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApplicationInfo getEarPlan(File planFile, JarFile earFile, ModuleIDBuilder idBuilder) throws DeploymentException {
        Application application = null;
        if (earFile != null) {
            URL applicationXmlUrl = null;
            try {
                applicationXmlUrl = JarUtils.createJarURL((JarFile)earFile, (String)"META-INF/application.xml");
                String specDD = JarUtils.readAll((URL)applicationXmlUrl);
                InputStream in = applicationXmlUrl.openStream();
                try {
                    application = (Application)JaxbJavaee.unmarshalJavaee(Application.class, (InputStream)in);
                }
                finally {
                    IOUtils.close((Closeable)in);
                }
            }
            catch (ParserConfigurationException e) {
                throw new DeploymentException("Could not parse application.xml", (Throwable)e);
            }
            catch (SAXException e) {
                throw new DeploymentException("Could not parse application.xml", (Throwable)e);
            }
            catch (JAXBException e) {
                throw new DeploymentException("Could not parse application.xml", (Throwable)e);
            }
            catch (Exception e) {
                if (!earFile.getName().endsWith(".ear")) {
                    return null;
                }
                application = new Application();
            }
        }
        GerApplicationType gerApplication = null;
        try {
            try {
                XmlObject rawPlan;
                if (planFile != null) {
                    rawPlan = XmlBeansUtil.parse((URL)planFile.toURI().toURL(), (ClassLoader)this.getClass().getClassLoader());
                    gerApplication = (GerApplicationType)SchemaConversionUtils.fixGeronimoSchema((XmlObject)rawPlan, (QName)APPLICATION_QNAME, (SchemaType)GerApplicationType.type);
                    if (gerApplication == null) {
                        return null;
                    }
                } else {
                    URL path = JarUtils.createJarURL((JarFile)earFile, (String)"META-INF/geronimo-application.xml");
                    rawPlan = XmlBeansUtil.parse((URL)path, (ClassLoader)this.getClass().getClassLoader());
                    gerApplication = (GerApplicationType)SchemaConversionUtils.fixGeronimoSchema((XmlObject)rawPlan, (QName)APPLICATION_QNAME, (SchemaType)GerApplicationType.type);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            if (gerApplication == null) {
                gerApplication = this.createDefaultPlan(application, earFile);
            }
        }
        catch (XmlException e) {
            throw new DeploymentException((Throwable)e);
        }
        EnvironmentType environmentType = gerApplication.getEnvironment();
        Environment environment = EnvironmentBuilder.buildEnvironment((EnvironmentType)environmentType, (Environment)this.defaultEnvironment);
        idBuilder.resolve(environment, earFile == null ? planFile.getName() : new File(earFile.getName()).getName(), "ear");
        idBuilder.setDefaultGroup(environment.getConfigId().getGroupId());
        idBuilder.setDefaultVersion(environment.getConfigId().getVersion());
        Artifact artifact = environment.getConfigId();
        AbstractName earName = this.naming.createRootName(artifact, artifact.toString(), "J2EEApplication");
        this.namingBuilders.buildEnvironment((JndiConsumer)application, gerApplication, environment);
        String applicationName = null;
        applicationName = application != null && application.getApplicationName() != null ? application.getApplicationName().trim() : (earFile != null ? FileUtils.removeExtension((String)new File(earFile.getName()).getName(), (String)".ear") : artifact.toString());
        ApplicationInfo applicationInfo = new ApplicationInfo(ConfigurationModuleType.EAR, environment, earName, applicationName, earFile, application, gerApplication, application == null ? null : application.toString());
        try {
            this.addModules(earFile, application, gerApplication, environment, applicationInfo, idBuilder);
            if (applicationInfo.getModules().isEmpty()) {
                return null;
            }
            if (application != null) {
                this.addModulesToDefaultPlan(application, applicationInfo.getModules());
            }
        }
        catch (Throwable e) {
            for (Module module : applicationInfo.getModules()) {
                module.close();
            }
            if (e instanceof DeploymentException) {
                throw (DeploymentException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new DeploymentException(e);
        }
        return applicationInfo;
    }

    private void addModulesToDefaultPlan(Application application, Set<Module<?, ?>> modules) {
        for (Module<?, ?> module : modules) {
            ConfigurationModuleType configurationModuleType = module.getType();
            org.apache.openejb.jee.Module newModule = new org.apache.openejb.jee.Module();
            if (configurationModuleType.equals(ConfigurationModuleType.WAR)) {
                WebModule webModule = (WebModule)module;
                Web web = new Web();
                web.setContextRoot(webModule.getContextRoot());
                web.setWebUri(webModule.getTargetPath());
                newModule.setWeb(web);
            } else if (configurationModuleType.equals(ConfigurationModuleType.EJB)) {
                newModule.setEjb(module.getTargetPath());
            } else if (configurationModuleType.equals(ConfigurationModuleType.RAR)) {
                newModule.setConnector(module.getTargetPath());
            } else if (configurationModuleType.equals(ConfigurationModuleType.CAR)) {
                newModule.setJava(module.getTargetPath());
            }
            application.getModule().add(newModule);
        }
    }

    private GerApplicationType createDefaultPlan(Application application, JarFile module) {
        String id;
        GerApplicationType gerApplication = GerApplicationType.Factory.newInstance();
        EnvironmentType environmentType = gerApplication.addNewEnvironment();
        ArtifactType artifactType = environmentType.addNewModuleId();
        artifactType.setGroupId("default");
        String string = id = application != null ? application.getId() : null;
        if (id == null) {
            File fileName = new File(module.getName());
            id = fileName.getName();
            if (id.endsWith(".ear")) {
                id = id.substring(0, id.length() - 4);
            }
            if (id.endsWith("/")) {
                id = id.substring(0, id.length() - 1);
            }
        }
        artifactType.setArtifactId(id);
        artifactType.setVersion("" + System.currentTimeMillis());
        artifactType.setType("car");
        return gerApplication;
    }

    public Artifact getConfigurationID(Object plan, JarFile module, ModuleIDBuilder idBuilder) throws IOException, DeploymentException {
        ApplicationInfo applicationInfo = (ApplicationInfo)plan;
        Artifact test = applicationInfo.getEnvironment().getConfigId();
        if (!test.isResolved()) {
            throw new IllegalStateException("Module ID should be fully resolved by now (not " + test + ")");
        }
        return test;
    }

    /*
     * WARNING - void declaration
     */
    public DeploymentContext buildConfiguration(boolean inPlaceDeployment, Artifact configId, Object plan, JarFile earFile, Collection configurationStores, ArtifactResolver artifactResolver, ConfigurationStore targetConfigurationStore) throws IOException, DeploymentException {
        Manifest mf;
        assert (plan != null);
        if (earFile != null && (mf = earFile.getManifest()) != null && mf.getMainAttributes().getValue("Bundle-SymbolicName") != null) {
            log.warn("Application module contains OSGi manifest. The OSGi manifest will be ignored and the application will be deployed as a regular Java EE application.");
        }
        ApplicationInfo applicationInfo = (ApplicationInfo)plan;
        EARContext earContext = null;
        ConfigurationModuleType applicationType = applicationInfo.getType();
        applicationInfo.getEnvironment().setConfigId(configId);
        try {
            try {
                targetConfigurationStore.createNewConfigurationDir(configId);
            }
            catch (ConfigurationAlreadyExistsException e) {
                throw new DeploymentException((Throwable)e);
            }
            ConfigurationManager configurationManager = this.configurationManager;
            if (configurationManager == null) {
                configurationManager = new SimpleConfigurationManager(configurationStores, artifactResolver, this.repositories, this.bundleContext);
            }
            File tempDirectory = FileUtils.createTempDir();
            earContext = new EARContext(tempDirectory, inPlaceDeployment ? JarUtils.toFile((JarFile)earFile) : null, applicationInfo.getEnvironment(), applicationType, this.naming, configurationManager, this.bundleContext, this.serverName, applicationInfo.getModuleName(), this.transactionManagerObjectName, this.connectionTrackerObjectName, this.corbaGBeanObjectName, new HashMap());
            applicationInfo.setEarContext(earContext);
            applicationInfo.setRootEarContext(earContext);
            earContext.getGeneralData().put(EARContext.MODULE_LIST_KEY, applicationInfo.getModuleLocations());
            LinkedHashSet<String> moduleLocations = applicationInfo.getModuleLocations();
            boolean initModulesInDDOrder = false;
            if (ConfigurationModuleType.EAR == applicationType && earFile != null) {
                String entryName;
                Application specDD = (Application)applicationInfo.getSpecDD();
                if (specDD != null && specDD.getInitializeInOrder() != null) {
                    initModulesInDDOrder = specDD.getInitializeInOrder();
                }
                String libDir = this.getLibraryDirectory(specDD);
                LinkedHashSet<String> libClasspath = applicationInfo.getClassPath();
                Enumeration<JarEntry> enumeration = earFile.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = enumeration.nextElement();
                    entryName = zipEntry.getName();
                    boolean bl = true;
                    for (String moduleLocation : moduleLocations) {
                        if (!entryName.startsWith(moduleLocation)) continue;
                        bl = false;
                        break;
                    }
                    if (!bl) continue;
                    earContext.addFile(URI.create(zipEntry.getName()), earFile, zipEntry);
                }
                Enumeration<JarEntry> enumeration2 = earFile.entries();
                while (enumeration2.hasMoreElements()) {
                    ZipEntry zipEntry = enumeration2.nextElement();
                    entryName = zipEntry.getName();
                    if (libDir == null || !zipEntry.getName().startsWith(libDir) || !zipEntry.getName().endsWith(".jar") || zipEntry.getName().substring(libDir.length() + 1).indexOf("/") != -1) continue;
                    NestedJarFile nestedJarFile = new NestedJarFile(earFile, zipEntry.getName());
                    earContext.addIncludeAsPackedJar(URI.create(zipEntry.getName()), (JarFile)nestedJarFile);
                    libClasspath.add(zipEntry.getName());
                    earContext.addManifestClassPath((JarFile)nestedJarFile, URI.create(libDir + "/"), libClasspath);
                }
            }
            for (String classpath : applicationInfo.getClassPath()) {
                earContext.addToClassPath(classpath);
            }
            GerApplicationType geronimoApplication = (GerApplicationType)applicationInfo.getVendorDD();
            ArrayList modules = new ArrayList();
            modules.addAll(applicationInfo.getModules());
            if (initModulesInDDOrder) {
                Collections.sort(modules, new Module.AppClientModuleLastComparator());
            } else {
                Collections.sort(modules, new Module.ModulePriorityComparator());
            }
            for (Module module : modules) {
                this.getBuilder(module).installModule(earFile, earContext, module, configurationStores, targetConfigurationStore, this.repositories);
            }
            applicationInfo.accumulateClassPath();
            earContext.flush();
            earContext.initializeConfiguration();
            for (Module module : modules) {
                if (earContext == module.getEarContext()) continue;
                module.getEarContext().initializeConfiguration();
            }
            applicationInfo.getJndiContext().get(JndiScope.app).put("app/AppName", applicationInfo.getName());
            Bundle bundle = earContext.getDeploymentBundle();
            if (ConfigurationModuleType.EAR == applicationType) {
                this.namingBuilders.initContext((JndiConsumer)applicationInfo.getSpecDD(), (XmlObject)applicationInfo.getVendorDD(), applicationInfo);
            }
            for (Module module : modules) {
                if (createPlanMode.get().booleanValue()) {
                    try {
                        this.getBuilder(module).initContext(earContext, module, bundle);
                    }
                    catch (Exception e) {
                        log.warn("Exception during initContext() phase");
                    }
                    continue;
                }
                this.getBuilder(module).initContext(earContext, module, bundle);
            }
            AbstractName abstractName = this.naming.createChildName(earContext.getModuleName(), "ApplicationJndi", "ApplicationJndi");
            earContext.getGeneralData().put(EARContext.APPLICATION_JNDI_NAME_KEY, abstractName);
            GBeanData gBeanData = new GBeanData(abstractName, ApplicationJndi.class);
            gBeanData.setAttribute("globalContextSegment", applicationInfo.getJndiContext().get(JndiScope.global));
            gBeanData.setAttribute("applicationContextMap", applicationInfo.getJndiContext().get(JndiScope.app));
            gBeanData.setReferencePattern("GlobalContext", this.globalContextAbstractName);
            if (!initModulesInDDOrder) {
                earContext.addGBean(gBeanData);
            }
            if (geronimoApplication != null) {
                this.serviceBuilders.build((XmlObject)geronimoApplication, (DeploymentContext)earContext, (DeploymentContext)earContext);
            }
            if (ConfigurationModuleType.EAR == applicationType) {
                for (ModuleBuilderExtension moduleBuilderExtension : this.BValModuleBuilders) {
                    moduleBuilderExtension.initContext(earContext, applicationInfo, earContext.getDeploymentBundle());
                }
                for (ModuleBuilderExtension moduleBuilderExtension : this.persistenceUnitBuilders) {
                    moduleBuilderExtension.initContext(earContext, applicationInfo, earContext.getDeploymentBundle());
                }
                for (ModuleBuilderExtension moduleBuilderExtension : this.persistenceUnitBuilders) {
                    moduleBuilderExtension.addGBeans(earContext, applicationInfo, earContext.getDeploymentBundle(), this.repositories);
                }
                GBeanData gbeanData = new GBeanData(earContext.getModuleName(), J2EEApplicationImpl.class);
                try {
                    void var21_48;
                    String string = applicationInfo.getOriginalSpecDD();
                    if (string == null) {
                        String string2 = "Synthetic EAR";
                    }
                    gbeanData.setAttribute("deploymentDescriptor", (Object)var21_48);
                }
                catch (Exception exception) {
                    throw new DeploymentException("Error initializing J2EEApplication managed object", (Throwable)exception);
                }
                gbeanData.setReferencePatterns("Server", new ReferencePatterns(new AbstractNameQuery(J2EEServer.class.getName())));
                Map<String, String> map = Collections.singletonMap("J2EEApplication", earContext.getModuleName().getNameProperty("name"));
                LinkedHashSet<AbstractNameQuery> resourcePatterns = new LinkedHashSet<AbstractNameQuery>();
                resourcePatterns.add(new AbstractNameQuery(null, EARConfigBuilder.filter(map, "j2eeType", "JavaMailResource"), J2EEResource.class.getName()));
                resourcePatterns.add(new AbstractNameQuery(null, EARConfigBuilder.filter(map, "j2eeType", "JCAConnectionFactory"), J2EEResource.class.getName()));
                resourcePatterns.add(new AbstractNameQuery(null, EARConfigBuilder.filter(map, "j2eeType", "JDBCResource"), J2EEResource.class.getName()));
                resourcePatterns.add(new AbstractNameQuery(null, EARConfigBuilder.filter(map, "j2eeType", "JDBCDriver"), J2EEResource.class.getName()));
                resourcePatterns.add(new AbstractNameQuery(null, EARConfigBuilder.filter(map, "j2eeType", "JMSResource"), J2EEResource.class.getName()));
                resourcePatterns.add(new AbstractNameQuery(null, EARConfigBuilder.filter(map, "j2eeType", "JNDIResource"), J2EEResource.class.getName()));
                resourcePatterns.add(new AbstractNameQuery(null, EARConfigBuilder.filter(map, "j2eeType", "JTAResource"), J2EEResource.class.getName()));
                resourcePatterns.add(new AbstractNameQuery(null, EARConfigBuilder.filter(map, "j2eeType", "RMI_IIOPResource"), J2EEResource.class.getName()));
                resourcePatterns.add(new AbstractNameQuery(null, EARConfigBuilder.filter(map, "j2eeType", "URLResource"), J2EEResource.class.getName()));
                gbeanData.setReferencePatterns("Resources", resourcePatterns);
                gbeanData.setReferencePatterns("AppClientModules", new ReferencePatterns(new AbstractNameQuery(null, map, org.apache.geronimo.management.AppClientModule.class.getName())));
                gbeanData.setReferencePatterns("EJBModules", new ReferencePatterns(new AbstractNameQuery(null, map, org.apache.geronimo.management.EJBModule.class.getName())));
                gbeanData.setReferencePatterns("ResourceAdapterModules", new ReferencePatterns(new AbstractNameQuery(null, map, ResourceAdapterModule.class.getName())));
                gbeanData.setReferencePatterns("WebModules", new ReferencePatterns(new AbstractNameQuery(null, map, org.apache.geronimo.management.geronimo.WebModule.class.getName())));
                earContext.addGBean(gbeanData);
                this.namingBuilders.buildNaming((JndiConsumer)applicationInfo.getSpecDD(), (XmlObject)applicationInfo.getVendorDD(), applicationInfo, earContext.getGeneralData());
            }
            for (Module module : modules) {
                if (createPlanMode.get().booleanValue()) {
                    try {
                        this.getBuilder(module).addGBeans(earContext, module, bundle, this.repositories);
                    }
                    catch (DeploymentException e) {
                        log.warn("Exception during addGBeans() phase", (Throwable)e);
                    }
                    continue;
                }
                this.getBuilder(module).addGBeans(earContext, module, bundle, this.repositories);
            }
            for (Module module : modules) {
                module.flushGBeansToContext();
            }
            if (initModulesInDDOrder) {
                earContext.addGBean(gBeanData);
            }
            if (createPlanMode.get().booleanValue()) {
                appInfo.set(applicationInfo);
                throw new DeploymentException();
            }
            EARContext eARContext = earContext;
            return eARContext;
        }
        catch (GBeanAlreadyExistsException e) {
            this.cleanupContext(earContext);
            throw new DeploymentException((Throwable)e);
        }
        catch (IOException e) {
            this.cleanupContext(earContext);
            throw e;
        }
        catch (DeploymentException e) {
            this.cleanupContext(earContext);
            throw e;
        }
        catch (RuntimeException e) {
            this.cleanupContext(earContext);
            throw e;
        }
        catch (Error e) {
            this.cleanupContext(earContext);
            throw e;
        }
        finally {
            for (Module module : applicationInfo.getModules()) {
                module.close();
            }
        }
    }

    private void cleanupContext(EARContext earContext) {
        if (earContext != null) {
            try {
                earContext.close();
            }
            catch (IOException ioe) {
            }
            catch (DeploymentException deploymentException) {
                // empty catch block
            }
        }
    }

    private String getLibraryDirectory(Application specDD) {
        if (specDD == null || specDD.getLibraryDirectory() == null) {
            return "lib";
        }
        String value = specDD.getLibraryDirectory();
        return value.trim().length() > 0 ? value : null;
    }

    private void cleanupContext(EARContext earContext, File configurationDir) {
        ArrayList configurations = new ArrayList();
        if (earContext != null) {
            configurations.addAll(earContext.getAdditionalDeployment());
            try {
                earContext.close();
            }
            catch (IOException ioe) {
            }
            catch (DeploymentException de) {
                // empty catch block
            }
        }
        if (configurationDir != null) {
            this.cleanupConfigurationDir(configurationDir);
        }
        for (ConfigurationData configurationData : configurations) {
            this.cleanupConfigurationDir(configurationData.getConfigurationDir());
        }
    }

    private boolean cleanupConfigurationDir(File configurationDir) {
        LinkedList cannotBeDeletedList = new LinkedList();
        if (!FileUtils.recursiveDelete((File)configurationDir, cannotBeDeletedList)) {
            log.warn("Unable to delete " + cannotBeDeletedList.size() + " files while recursively deleting directory " + configurationDir.getAbsolutePath() + LINE_SEP + "The first file that could not be deleted was:" + LINE_SEP + "  " + (!cannotBeDeletedList.isEmpty() ? (String)cannotBeDeletedList.getFirst() : ""));
            return false;
        }
        return true;
    }

    private static Map<String, String> filter(Map<String, String> original, String key, String value) {
        LinkedHashMap<String, String> filter = new LinkedHashMap<String, String>(original);
        filter.put(key, value);
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addModules(JarFile earFile, Application application, GerApplicationType gerApplication, Environment environment, Module applicationInfo, ModuleIDBuilder idBuilder) throws DeploymentException {
        HashMap<String, Object> altVendorDDs = new HashMap<String, Object>();
        try {
            this.mapVendorPlans(gerApplication, altVendorDDs, earFile);
            if (earFile != null) {
                if (application.getModule().size() != 0) {
                    List Modules = application.getModule();
                    for (org.apache.openejb.jee.Module moduleXml : Modules) {
                        NestedJarFile moduleFile;
                        String moduleTypeName;
                        ModuleBuilder builder;
                        String modulePath;
                        String moduleContextInfo = null;
                        if (moduleXml.getEjb() != null) {
                            modulePath = moduleXml.getEjb();
                            builder = this.getEjbConfigBuilder();
                            if (builder == null) {
                                throw new DeploymentException("Cannot deploy ejb application; No ejb deployer defined: " + modulePath);
                            }
                            moduleTypeName = "an EJB";
                        } else if (moduleXml.getWeb() != null) {
                            modulePath = moduleXml.getWeb().getWebUri();
                            if (this.getWebConfigBuilder() == null) {
                                throw new DeploymentException("Cannot deploy web application; No war deployer defined: " + modulePath);
                            }
                            builder = this.getWebConfigBuilder();
                            moduleTypeName = "a war";
                            moduleContextInfo = moduleXml.getWeb().getContextRoot().trim();
                        } else if (moduleXml.getConnector() != null) {
                            modulePath = moduleXml.getConnector();
                            if (this.getConnectorConfigBuilder() == null) {
                                throw new DeploymentException("Cannot deploy resource adapter; No rar deployer defined: " + modulePath);
                            }
                            builder = this.getConnectorConfigBuilder();
                            moduleTypeName = "a connector";
                        } else if (moduleXml.getJava() != null) {
                            modulePath = moduleXml.getJava();
                            if (this.getAppClientConfigBuilder() == null) {
                                throw new DeploymentException("Cannot deploy app client; No app client deployer defined: " + modulePath);
                            }
                            builder = this.getAppClientConfigBuilder();
                            moduleTypeName = "an application client";
                        } else {
                            throw new DeploymentException("Could not find a module builder for module: " + moduleXml);
                        }
                        applicationInfo.getModuleLocations().add(modulePath);
                        try {
                            moduleFile = new NestedJarFile(earFile, modulePath);
                        }
                        catch (IOException e) {
                            throw new DeploymentException("Invalid moduleFile: " + modulePath, (Throwable)e);
                        }
                        Module module = builder.createModule(altVendorDDs.get(modulePath), (JarFile)moduleFile, modulePath, this.getAltSpecDDURL(earFile, moduleXml), environment, moduleContextInfo, applicationInfo, this.naming, idBuilder);
                        if (module == null) {
                            throw new DeploymentException("Module was not " + moduleTypeName + ": " + modulePath);
                        }
                        applicationInfo.getModules().add(module);
                    }
                } else {
                    Enumeration<JarEntry> entries = earFile.entries();
                    while (entries.hasMoreElements()) {
                        NestedJarFile moduleFile;
                        String moduleTypeName;
                        ModuleBuilder builder;
                        ZipEntry entry;
                        String moduleContextInfo;
                        block62: {
                            moduleContextInfo = null;
                            entry = entries.nextElement();
                            if (entry.getName().endsWith(".war")) {
                                if (this.getWebConfigBuilder() == null) {
                                    throw new DeploymentException("Cannot deploy web application; No war deployer defined: " + entry.getName());
                                }
                                builder = this.getWebConfigBuilder();
                                moduleTypeName = "a war";
                                moduleContextInfo = entry.getName().split(".war")[0];
                            } else if (entry.getName().endsWith(".rar")) {
                                if (this.getConnectorConfigBuilder() == null) {
                                    throw new DeploymentException("Cannot deploy resource adapter; No rar deployer defined: " + entry.getName());
                                }
                                builder = this.getConnectorConfigBuilder();
                                moduleTypeName = "a connector";
                            } else {
                                if (!entry.getName().endsWith(".jar") || this.isLibraryEntry(application, entry)) continue;
                                try {
                                    Module module;
                                    moduleFile = new NestedJarFile(earFile, entry.getName());
                                    Manifest mf = moduleFile.getManifest();
                                    if (mf.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS) != null) {
                                        if (this.getAppClientConfigBuilder() == null) {
                                            throw new DeploymentException("Cannot deploy app client; No app client deployer defined: " + entry.getName());
                                        }
                                        builder = this.getAppClientConfigBuilder();
                                        moduleTypeName = "an application client";
                                        break block62;
                                    }
                                    builder = this.getEjbConfigBuilder();
                                    if (builder == null || (module = builder.createModule(altVendorDDs.get(entry.getName()), (JarFile)moduleFile, entry.getName(), null, environment, moduleContextInfo, applicationInfo, this.naming, idBuilder)) == null) continue;
                                    applicationInfo.getModuleLocations().add(entry.getName());
                                    applicationInfo.getModules().add(module);
                                    continue;
                                }
                                catch (IOException e) {
                                    throw new DeploymentException("Invalid moduleFile: " + entry.getName(), (Throwable)e);
                                }
                            }
                        }
                        applicationInfo.getModuleLocations().add(entry.getName());
                        try {
                            moduleFile = new NestedJarFile(earFile, entry.getName());
                        }
                        catch (IOException e) {
                            throw new DeploymentException("Invalid moduleFile: " + entry.getName(), (Throwable)e);
                        }
                        Module module = builder.createModule(altVendorDDs.get(entry.getName()), (JarFile)moduleFile, entry.getName(), null, environment, moduleContextInfo, applicationInfo, this.naming, idBuilder);
                        if (module == null) {
                            throw new DeploymentException("Module was not " + moduleTypeName + ": " + entry.getName());
                        }
                        applicationInfo.getModules().add(module);
                    }
                }
                this.discoverWebBeans(earFile, application, environment, applicationInfo, idBuilder, altVendorDDs);
            }
            if (!applicationInfo.getModuleLocations().containsAll(altVendorDDs.keySet())) {
                HashSet missingModules = new HashSet(altVendorDDs.keySet());
                missingModules.removeAll(applicationInfo.getModuleLocations());
                throw new DeploymentException("Geronimo ear plan contains modules that are not in the ear: " + missingModules);
            }
            for (GerExtModuleType gerExtModule : gerApplication.getExtModuleArray()) {
                Object moduleFile;
                String moduleTypeName;
                ModuleBuilder builder;
                String moduleName;
                Object moduleContextInfo = null;
                if (gerExtModule.isSetEjb()) {
                    moduleName = gerExtModule.getEjb().getStringValue();
                    builder = this.getEjbConfigBuilder();
                    if (builder == null) {
                        throw new DeploymentException("Cannot deploy ejb application; No ejb deployer defined: " + moduleName);
                    }
                    moduleTypeName = "an EJB";
                } else if (gerExtModule.isSetWeb()) {
                    moduleName = gerExtModule.getWeb().getStringValue();
                    if (this.getWebConfigBuilder() == null) {
                        throw new DeploymentException("Cannot deploy web application; No war deployer defined: " + moduleName);
                    }
                    builder = this.getWebConfigBuilder();
                    moduleTypeName = "a war";
                } else if (gerExtModule.isSetConnector()) {
                    moduleName = gerExtModule.getConnector().getStringValue();
                    if (this.getConnectorConfigBuilder() == null) {
                        throw new DeploymentException("Cannot deploy resource adapter; No rar deployer defined: " + moduleName);
                    }
                    builder = this.getConnectorConfigBuilder();
                    moduleTypeName = "a connector";
                } else if (gerExtModule.isSetJava()) {
                    moduleName = gerExtModule.getJava().getStringValue();
                    if (this.getAppClientConfigBuilder() == null) {
                        throw new DeploymentException("Cannot deploy app client; No app client deployer defined: " + moduleName);
                    }
                    builder = this.getAppClientConfigBuilder();
                    moduleTypeName = "an application client";
                } else {
                    throw new DeploymentException("Could not find a module builder for module: " + gerExtModule);
                }
                XmlObject[] anys = gerExtModule.selectChildren(GerExtModuleType.type.qnameSetForWildcardElements());
                if (anys.length != 1) {
                    throw new DeploymentException("Unexpected count of xs:any elements in embedded vendor plan " + anys.length + " qnameset: " + GerExtModuleType.type.qnameSetForWildcardElements());
                }
                XmlObject vendorDD = anys[0];
                if (gerExtModule.isSetInternalPath()) {
                    String modulePath = gerExtModule.getInternalPath().trim();
                    applicationInfo.getModuleLocations().add(modulePath);
                    try {
                        moduleFile = new NestedJarFile(earFile, modulePath);
                    }
                    catch (IOException e) {
                        throw new DeploymentException("Invalid moduleFile: " + modulePath, (Throwable)e);
                    }
                }
                PatternType patternType = gerExtModule.getExternalPath();
                String groupId = this.trim(patternType.getGroupId());
                String artifactId = this.trim(patternType.getArtifactId());
                String version = this.trim(patternType.getVersion());
                String type = this.trim(patternType.getType());
                Artifact artifact = new Artifact(groupId, artifactId, version, type);
                try {
                    artifact = this.getArtifactResolver().resolveInClassLoader(artifact);
                }
                catch (MissingDependencyException e) {
                    throw new DeploymentException("Could not resolve external rar location in repository: " + artifact, (Throwable)e);
                }
                File location = null;
                for (Repository repository : this.repositories) {
                    if (!repository.contains(artifact)) continue;
                    location = repository.getLocation(artifact);
                    break;
                }
                if (location == null) {
                    throw new DeploymentException(moduleTypeName + " is missing in repositories: " + artifact);
                }
                try {
                    moduleFile = new JarFile(location);
                }
                catch (IOException e) {
                    throw new DeploymentException("Could not access contents of " + moduleTypeName, (Throwable)e);
                }
                Module module = builder.createModule(vendorDD, (JarFile)moduleFile, moduleName, null, environment, moduleContextInfo, applicationInfo, this.naming, idBuilder);
                if (module == null) {
                    throw new DeploymentException("Module was not " + moduleTypeName + ": " + moduleName);
                }
                applicationInfo.getModules().add(module);
            }
        }
        finally {
            for (Object altVendorDD : altVendorDDs.values()) {
                if (!(altVendorDD instanceof File)) continue;
                ((File)altVendorDD).delete();
            }
        }
    }

    private void discoverWebBeans(JarFile earFile, Application application, Environment environment, Module applicationInfo, ModuleIDBuilder idBuilder, Map<String, Object> altVendorDDs) throws DeploymentException {
        Enumeration<JarEntry> entries = earFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!entry.getName().endsWith(".jar") || !this.isLibraryEntry(application, entry)) continue;
            try {
                Module module;
                ModuleBuilder builder;
                NestedJarFile moduleFile = new NestedJarFile(earFile, entry.getName());
                if (moduleFile.getEntry("META-INF/beans.xml") == null || (builder = this.getEjbConfigBuilder()) == null || (module = builder.createModule(altVendorDDs.get(entry.getName()), (JarFile)moduleFile, entry.getName(), null, environment, null, applicationInfo, this.naming, idBuilder)) == null) continue;
                applicationInfo.getModuleLocations().add(entry.getName());
                applicationInfo.getModules().add(module);
            }
            catch (IOException e) {
                throw new DeploymentException("Invalid moduleFile: " + entry.getName(), (Throwable)e);
            }
        }
    }

    private ArtifactResolver getArtifactResolver() throws DeploymentException {
        if (this.artifactResolvers == null || this.artifactResolvers.isEmpty()) {
            throw new DeploymentException("No artifact resolver supplied to resolve external module");
        }
        return this.artifactResolvers.iterator().next();
    }

    private String trim(String s) {
        if (s == null) {
            return null;
        }
        return s.trim();
    }

    private boolean isLibraryEntry(Application application, ZipEntry entry) {
        String libDir = this.getLibraryDirectory(application);
        return libDir != null && entry.getName().startsWith(libDir);
    }

    private void mapVendorPlans(GerApplicationType gerApplication, Map<String, Object> altVendorDDs, JarFile earFile) throws DeploymentException {
        for (GerModuleType gerModule : gerApplication.getModuleArray()) {
            String path = null;
            if (gerModule.isSetEjb()) {
                path = gerModule.getEjb().getStringValue();
            } else if (gerModule.isSetWeb()) {
                path = gerModule.getWeb().getStringValue();
            } else if (gerModule.isSetConnector()) {
                path = gerModule.getConnector().getStringValue();
            } else if (gerModule.isSetJava()) {
                path = gerModule.getJava().getStringValue();
            }
            if (gerModule.isSetAltDd()) {
                try {
                    altVendorDDs.put(path, JarUtils.toTempFile((JarFile)earFile, (String)gerModule.getAltDd().getStringValue()));
                    continue;
                }
                catch (IOException e) {
                    throw new DeploymentException("Invalid alt vendor dd url: " + gerModule.getAltDd().getStringValue(), (Throwable)e);
                }
            }
            XmlObject[] anys = gerModule.selectChildren(GerModuleType.type.qnameSetForWildcardElements());
            if (anys.length != 1) {
                throw new DeploymentException("Unexpected count of xs:any elements in embedded vendor plan " + anys.length + " qnameset: " + GerModuleType.type.qnameSetForWildcardElements());
            }
            altVendorDDs.put(path, anys[0]);
        }
    }

    private URL getAltSpecDDURL(JarFile earFile, org.apache.openejb.jee.Module moduleXml) throws DeploymentException {
        if (moduleXml != null && moduleXml.getAltDd() != null) {
            try {
                return JarUtils.createJarURL((JarFile)earFile, (String)moduleXml.getAltDd());
            }
            catch (MalformedURLException e) {
                throw new DeploymentException("Invalid alt sped dd url: " + moduleXml.getAltDd(), (Throwable)e);
            }
        }
        return null;
    }

    private ModuleBuilder getBuilder(Module module) throws DeploymentException {
        if (module instanceof EJBModule) {
            if (this.getEjbConfigBuilder() == null) {
                throw new DeploymentException("Cannot deploy ejb application; No ejb deployer defined: " + module.getModuleURI());
            }
            return this.getEjbConfigBuilder();
        }
        if (module instanceof WebModule) {
            if (this.getWebConfigBuilder() == null) {
                throw new DeploymentException("Cannot deploy web application; No war deployer defined: " + module.getModuleURI());
            }
            return this.getWebConfigBuilder();
        }
        if (module instanceof ConnectorModule) {
            if (this.getConnectorConfigBuilder() == null) {
                throw new DeploymentException("Cannot deploy resource adapter; No rar deployer defined: " + module.getModuleURI());
            }
            return this.getConnectorConfigBuilder();
        }
        if (module instanceof AppClientModule) {
            if (this.getAppClientConfigBuilder() == null) {
                throw new DeploymentException("Cannot deploy app client; No app client deployer defined: " + module.getModuleURI());
            }
            return this.getAppClientConfigBuilder();
        }
        throw new IllegalArgumentException("Unknown module type: " + module.getClass().getName());
    }

    static {
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/application", "http://geronimo.apache.org/xml/ns/j2ee/application-2.0");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/application-1.1", "http://geronimo.apache.org/xml/ns/j2ee/application-2.0");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/application-1.2", "http://geronimo.apache.org/xml/ns/j2ee/application-2.0");
        createPlanMode = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Boolean.FALSE;
            }
        };
        appInfo = new ThreadLocal<ApplicationInfo>(){

            @Override
            protected ApplicationInfo initialValue() {
                return null;
            }
        };
    }
}

