/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBs;
import javax.ejb.Local;
import javax.ejb.Remote;
import org.apache.geronimo.j2ee.deployment.annotation.AnnotatedApp;
import org.apache.geronimo.j2ee.deployment.annotation.AnnotationHelper;
import org.apache.geronimo.xbeans.javaee6.DescriptionType;
import org.apache.geronimo.xbeans.javaee6.EjbLinkType;
import org.apache.geronimo.xbeans.javaee6.EjbLocalRefType;
import org.apache.geronimo.xbeans.javaee6.EjbRefNameType;
import org.apache.geronimo.xbeans.javaee6.EjbRefType;
import org.apache.geronimo.xbeans.javaee6.InjectionTargetType;
import org.apache.geronimo.xbeans.javaee6.LocalType;
import org.apache.geronimo.xbeans.javaee6.RemoteType;
import org.apache.geronimo.xbeans.javaee6.XsdStringType;
import org.apache.xbean.finder.ClassFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EJBAnnotationHelper
extends AnnotationHelper {
    private static final Logger log = LoggerFactory.getLogger(EJBAnnotationHelper.class);

    private EJBAnnotationHelper() {
    }

    public static boolean annotationsPresent(ClassFinder classFinder) {
        if (classFinder.isAnnotationPresent(EJB.class)) {
            return true;
        }
        return classFinder.isAnnotationPresent(EJBs.class);
    }

    public static void processAnnotations(AnnotatedApp annotatedApp, ClassFinder classFinder) throws Exception {
        if (annotatedApp != null) {
            EJBAnnotationHelper.processEJBs(annotatedApp, classFinder);
            EJBAnnotationHelper.processEJB(annotatedApp, classFinder);
        }
    }

    private static void processEJB(AnnotatedApp annotatedApp, ClassFinder classFinder) throws Exception {
        EJB ejb;
        log.debug("processEJB(): Entry: AnnotatedApp: " + ((Object)annotatedApp).toString());
        List classesWithEJB = classFinder.findAnnotatedClasses(EJB.class);
        List methodsWithEJB = classFinder.findAnnotatedMethods(EJB.class);
        List fieldsWithEJB = classFinder.findAnnotatedFields(EJB.class);
        for (Class cls : classesWithEJB) {
            ejb = cls.getAnnotation(EJB.class);
            if (ejb == null) continue;
            EJBAnnotationHelper.addEJB(annotatedApp, ejb, cls, null, null);
        }
        for (Method method : methodsWithEJB) {
            ejb = method.getAnnotation(EJB.class);
            if (ejb == null) continue;
            EJBAnnotationHelper.addEJB(annotatedApp, ejb, null, method, null);
        }
        for (Field field : fieldsWithEJB) {
            ejb = field.getAnnotation(EJB.class);
            if (ejb == null) continue;
            EJBAnnotationHelper.addEJB(annotatedApp, ejb, null, null, field);
        }
        EJBAnnotationHelper.validateDD(annotatedApp);
        log.debug("processEJB(): Exit: AnnotatedApp: " + ((Object)annotatedApp).toString());
    }

    private static void processEJBs(AnnotatedApp annotatedApp, ClassFinder classFinder) throws Exception {
        log.debug("processEJBs(): Entry");
        List classesWithEJBs = classFinder.findAnnotatedClasses(EJBs.class);
        ArrayList<EJB> ejbList = new ArrayList<EJB>();
        for (Class cls : classesWithEJBs) {
            EJBs ejbs = cls.getAnnotation(EJBs.class);
            if (ejbs != null) {
                ejbList.addAll(Arrays.asList(ejbs.value()));
            }
            for (EJB ejb : ejbList) {
                EJBAnnotationHelper.addEJB(annotatedApp, ejb, cls, null, null);
            }
            ejbList.clear();
        }
        log.debug("processEJBs(): Exit");
    }

    private static void addEJB(AnnotatedApp annotatedApp, EJB annotation, Class cls, Method method, Field field) {
        String remoteRefName;
        InjectionTargetType[] targets;
        EjbRefNameType ejbRefName;
        log.debug("addEJB( [annotatedApp] " + ((Object)annotatedApp).toString() + "," + '\n' + "[annotation] " + annotation.toString() + "," + '\n' + "[cls] " + (cls != null ? cls.getName() : null) + "," + '\n' + "[method] " + (method != null ? method.getName() : null) + "," + '\n' + "[field] " + (field != null ? field.getName() : null) + " ): Entry");
        boolean localFlag = false;
        boolean remoteFlag = false;
        Class<Object> interfce = annotation.beanInterface();
        if (interfce.equals(Object.class)) {
            interfce = method != null ? method.getParameterTypes()[0] : (field != null ? field.getType() : null);
        }
        log.debug("addEJB(): interfce: " + interfce);
        if (interfce != null && !interfce.equals(Object.class)) {
            if (EJBHome.class.isAssignableFrom(interfce)) {
                for (Method m : interfce.getMethods()) {
                    if (!m.getName().startsWith("create")) continue;
                    interfce = m.getReturnType();
                    break;
                }
                remoteFlag = true;
            } else if (EJBLocalHome.class.isAssignableFrom(interfce)) {
                for (Method m : interfce.getMethods()) {
                    if (!m.getName().startsWith("create")) continue;
                    interfce = m.getReturnType();
                    break;
                }
                localFlag = true;
            } else if (interfce.getAnnotation(Local.class) != null) {
                localFlag = true;
            } else if (interfce.getAnnotation(Remote.class) != null) {
                remoteFlag = true;
            }
        }
        log.debug("addEJB(): localFlag: " + localFlag);
        log.debug("addEJB(): remoteFlag: " + remoteFlag);
        if (localFlag) {
            EjbLocalRefType[] ejbLocalRefEntries;
            log.debug("addEJB(): <ejb-local-ref> found");
            String localRefName = EJBAnnotationHelper.getName(annotation.name(), method, field);
            EjbLocalRefType ejbLocalRef = null;
            for (EjbLocalRefType ejbLocalRefType : ejbLocalRefEntries = annotatedApp.getEjbLocalRefArray()) {
                if (!ejbLocalRefType.getEjbRefName().getStringValue().trim().equals(localRefName)) continue;
                ejbLocalRef = ejbLocalRefType;
                break;
            }
            if (ejbLocalRef == null) {
                try {
                    String string;
                    String mappdedNameAnnotation;
                    String beanName;
                    String localAnnotation;
                    log.debug("addEJB(): Does not exist in DD: " + localRefName);
                    ejbLocalRef = annotatedApp.addNewEjbLocalRef();
                    ejbRefName = ejbLocalRef.addNewEjbRefName();
                    ejbRefName.setStringValue(localRefName);
                    ejbLocalRef.setEjbRefName(ejbRefName);
                    if (interfce != null && !(localAnnotation = interfce.getName()).equals("")) {
                        LocalType local = ejbLocalRef.addNewLocal();
                        local.setStringValue(localAnnotation);
                        ejbLocalRef.setLocal(local);
                    }
                    if (!(beanName = annotation.beanName()).equals("")) {
                        EjbLinkType ejbLink = ejbLocalRef.addNewEjbLink();
                        ejbLink.setStringValue(beanName);
                        ejbLocalRef.setEjbLink(ejbLink);
                    }
                    if (!(mappdedNameAnnotation = annotation.mappedName()).equals("")) {
                        XsdStringType xsdStringType = ejbLocalRef.addNewMappedName();
                        xsdStringType.setStringValue(mappdedNameAnnotation);
                        ejbLocalRef.setMappedName(xsdStringType);
                    }
                    if (!(string = annotation.description()).equals("")) {
                        DescriptionType description = ejbLocalRef.addNewDescription();
                        description.setStringValue(string);
                    }
                }
                catch (Exception e) {
                    log.debug("EJBAnnotationHelper: Exception caught while processing <ejb-local-ref>", (Throwable)e);
                }
            }
            if (!(method == null && field == null || EJBAnnotationHelper.hasTarget(method, field, targets = ejbLocalRef.getInjectionTargetArray()))) {
                EJBAnnotationHelper.configureInjectionTarget(ejbLocalRef.addNewInjectionTarget(), method, field);
            }
        } else if (remoteFlag) {
            log.debug("addEJB(): <ejb-ref> found");
            remoteRefName = EJBAnnotationHelper.getName(annotation.name(), method, field);
            EjbLocalRefType ejbRef = null;
            EjbRefType[] ejbRefEntries = annotatedApp.getEjbRefArray();
            for (EjbLocalRefType ejbLocalRefType : ejbRefEntries) {
                if (!ejbLocalRefType.getEjbRefName().getStringValue().trim().equals(remoteRefName)) continue;
                ejbRef = ejbLocalRefType;
                break;
            }
            if (ejbRef == null) {
                try {
                    String string;
                    String mappdedNameAnnotation;
                    String beanName;
                    String remoteAnnotation;
                    log.debug("addEJB(): Does not exist in DD: " + remoteRefName);
                    ejbRef = annotatedApp.addNewEjbRef();
                    ejbRefName = ejbRef.addNewEjbRefName();
                    ejbRefName.setStringValue(remoteRefName);
                    ejbRef.setEjbRefName(ejbRefName);
                    if (interfce != null && !(remoteAnnotation = interfce.getName()).equals("")) {
                        RemoteType remote = ejbRef.addNewRemote();
                        remote.setStringValue(remoteAnnotation);
                        ejbRef.setRemote(remote);
                    }
                    if (!(beanName = annotation.beanName()).equals("")) {
                        EjbLinkType ejbLink = ejbRef.addNewEjbLink();
                        ejbLink.setStringValue(beanName);
                        ejbRef.setEjbLink(ejbLink);
                    }
                    if (!(mappdedNameAnnotation = annotation.mappedName()).equals("")) {
                        XsdStringType xsdStringType = ejbRef.addNewMappedName();
                        xsdStringType.setStringValue(mappdedNameAnnotation);
                        ejbRef.setMappedName(xsdStringType);
                    }
                    if (!(string = annotation.description()).equals("")) {
                        DescriptionType description = ejbRef.addNewDescription();
                        description.setStringValue(string);
                    }
                }
                catch (Exception e) {
                    log.debug("EJBAnnotationHelper: Exception caught while processing <ejb-ref>", (Throwable)e);
                }
            }
            if (!(method == null && field == null || EJBAnnotationHelper.hasTarget(method, field, targets = ejbRef.getInjectionTargetArray()))) {
                EJBAnnotationHelper.configureInjectionTarget(ejbRef.addNewInjectionTarget(), method, field);
            }
        } else {
            log.debug("addEJB(): <UNKNOWN> found");
            remoteRefName = EJBAnnotationHelper.getName(annotation.name(), method, field);
            EjbLocalRefType ejbRef = null;
            EjbRefType[] ejbRefEntries = annotatedApp.getEjbRefArray();
            for (EjbLocalRefType ejbLocalRefType : ejbRefEntries) {
                if (!ejbLocalRefType.getEjbRefName().getStringValue().trim().equals(remoteRefName)) continue;
                ejbRef = ejbLocalRefType;
                break;
            }
            if (ejbRef == null) {
                try {
                    String string;
                    String mappdedNameAnnotation;
                    String beanName;
                    String remoteAnnotation;
                    log.debug("addEJB(): Does not exist in DD: " + remoteRefName);
                    ejbRef = EjbRefType.Factory.newInstance();
                    annotatedApp.getAmbiguousEjbRefs().add((EjbRefType)ejbRef);
                    ejbRefName = ejbRef.addNewEjbRefName();
                    ejbRefName.setStringValue(remoteRefName);
                    ejbRef.setEjbRefName(ejbRefName);
                    if (interfce != null && !(remoteAnnotation = interfce.getName()).equals("")) {
                        RemoteType remote = ejbRef.addNewRemote();
                        remote.setStringValue(remoteAnnotation);
                        ejbRef.setRemote(remote);
                    }
                    if (!(beanName = annotation.beanName()).equals("")) {
                        EjbLinkType ejbLink = ejbRef.addNewEjbLink();
                        ejbLink.setStringValue(beanName);
                        ejbRef.setEjbLink(ejbLink);
                    }
                    if (!(mappdedNameAnnotation = annotation.mappedName()).equals("")) {
                        XsdStringType xsdStringType = ejbRef.addNewMappedName();
                        xsdStringType.setStringValue(mappdedNameAnnotation);
                        ejbRef.setMappedName(xsdStringType);
                    }
                    if (!(string = annotation.description()).equals("")) {
                        DescriptionType description = ejbRef.addNewDescription();
                        description.setStringValue(string);
                    }
                }
                catch (Exception e) {
                    log.debug("EJBAnnotationHelper: Exception caught while processing <UNKNOWN>", (Throwable)e);
                }
            }
            if (!(method == null && field == null || EJBAnnotationHelper.hasTarget(method, field, targets = ejbRef.getInjectionTargetArray()))) {
                EJBAnnotationHelper.configureInjectionTarget(ejbRef.addNewInjectionTarget(), method, field);
            }
        }
        log.debug("addEJB(): Exit");
    }
}

