/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.Deployable;
import org.apache.geronimo.deployment.DeployableJarFile;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.annotation.AnnotatedApp;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.xbean.finder.ClassFinder;

public abstract class Module<T, U> {
    private final boolean standAlone;
    private final AbstractName moduleName;
    private final String name;
    private final Environment environment;
    private final URI moduleURI;
    private final Deployable deployable;
    private final String targetPath;
    private final URI targetPathURI;
    private final U vendorDD;
    private final String namespace;
    private EARContext earContext;
    private EARContext rootEarContext;
    private T specDD;
    private String originalSpecDD;
    private AnnotatedApp annotatedApp;
    private ClassFinder classFinder;
    protected final Map sharedContext = new HashMap();

    protected Module(boolean standAlone, AbstractName moduleName, String name, Environment environment, JarFile moduleFile, String targetPath, T specDD, U vendorDD, String originalSpecDD, String namespace, AnnotatedApp annotatedApp) {
        this(standAlone, moduleName, name, environment, (Deployable)new DeployableJarFile(moduleFile), targetPath, specDD, vendorDD, originalSpecDD, namespace, annotatedApp);
    }

    protected Module(boolean standAlone, AbstractName moduleName, String name, Environment environment, Deployable deployable, String targetPath, T specDD, U vendorDD, String originalSpecDD, String namespace, AnnotatedApp annotatedApp) {
        assert (targetPath != null) : "targetPath is null";
        assert (moduleName != null) : "moduleName is null";
        this.standAlone = standAlone;
        this.moduleName = moduleName;
        this.environment = environment;
        this.deployable = deployable;
        this.targetPath = targetPath;
        this.specDD = specDD;
        this.vendorDD = vendorDD;
        this.originalSpecDD = originalSpecDD;
        this.namespace = namespace;
        if (standAlone) {
            this.name = name == null ? environment.getConfigId().toString() : name;
            this.moduleURI = URI.create("");
        } else {
            this.name = name == null ? targetPath : name;
            this.moduleURI = URI.create(targetPath);
        }
        this.targetPathURI = URI.create(targetPath + "/");
        this.annotatedApp = annotatedApp;
    }

    public abstract ConfigurationModuleType getType();

    public String getName() {
        return this.name;
    }

    public boolean isStandAlone() {
        return this.standAlone;
    }

    public AbstractName getModuleName() {
        return this.moduleName;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public URI getModuleURI() {
        return this.moduleURI;
    }

    public JarFile getModuleFile() {
        if (this.deployable instanceof DeployableJarFile) {
            return ((DeployableJarFile)this.deployable).getJarFile();
        }
        throw new RuntimeException("getModuleFile() is not supported on Bundle-based deployment");
    }

    public Deployable getDeployable() {
        return this.deployable;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public URI getTargetPathURI() {
        return this.targetPathURI;
    }

    public URI resolve(String path) {
        return this.targetPathURI.resolve(path);
    }

    public URI resolve(URI path) {
        return this.targetPathURI.resolve(path);
    }

    public T getSpecDD() {
        return this.specDD;
    }

    public U getVendorDD() {
        return this.vendorDD;
    }

    public String getOriginalSpecDD() {
        return this.originalSpecDD;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Module) {
            Module module = (Module)obj;
            return this.name.equals(module.name);
        }
        return false;
    }

    public void close() {
        this.deployable.close();
    }

    public EARContext getEarContext() {
        return this.earContext;
    }

    public void setEarContext(EARContext earContext) {
        this.earContext = earContext;
    }

    public EARContext getRootEarContext() {
        return this.rootEarContext;
    }

    public void setRootEarContext(EARContext rootEarContext) {
        this.rootEarContext = rootEarContext;
    }

    public Map getSharedContext() {
        return this.sharedContext;
    }

    public void setSpecDD(T specDD) {
        this.specDD = specDD;
    }

    public void setOriginalSpecDD(String originalSpecDD) {
        this.originalSpecDD = originalSpecDD;
    }

    public AnnotatedApp getAnnotatedApp() {
        return this.annotatedApp;
    }

    public void setAnnotatedApp(AnnotatedApp annotatedApp) {
        this.annotatedApp = annotatedApp;
    }

    public ClassFinder getClassFinder() {
        return this.classFinder;
    }

    public void setClassFinder(ClassFinder classFinder) {
        this.classFinder = classFinder;
    }

    public Artifact[] getConfigId() {
        if (this.earContext == null) {
            throw new NullPointerException("No ear context set");
        }
        if (this.rootEarContext == null || this.rootEarContext == this.earContext || this.rootEarContext.getConfigID().equals((Object)this.earContext.getConfigID())) {
            return new Artifact[]{this.earContext.getConfigID()};
        }
        return new Artifact[]{this.rootEarContext.getConfigID(), this.earContext.getConfigID()};
    }

    public String getRelativePath(String path) {
        return path;
    }

    public void addAsChildConfiguration() throws DeploymentException {
        if (this.rootEarContext != null && this.rootEarContext != this.earContext) {
            ConfigurationData moduleConfigurationData = this.earContext.getConfigurationData();
            this.rootEarContext.addChildConfiguration(this.getTargetPath(), moduleConfigurationData);
        }
    }
}

