/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.ClassPathList;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.ModuleList;
import org.apache.geronimo.deployment.ResourceContext;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.repository.Environment;
import org.osgi.framework.BundleContext;

public class EARContext
extends DeploymentContext {
    private final AbstractNameQuery serverName;
    private final AbstractNameQuery transactionManagerObjectName;
    private final AbstractNameQuery connectionTrackerObjectName;
    private final AbstractNameQuery corbaGBeanObjectName;
    private final Map<String, Object> contextIDToPermissionsMap = new HashMap<String, Object>();
    private Object securityConfiguration;
    private boolean hasSecurity;
    private final Map messageDestinations;
    private final Map<Key, Object> generalData = new HashMap<Key, Object>();
    public static final Key<ClassPathList> CLASS_PATH_LIST_KEY = new Key<ClassPathList>(){

        @Override
        public ClassPathList get(Map<Key, Object> context) {
            return (ClassPathList)context.get(this);
        }
    };
    public static final Key<ModuleList> MODULE_LIST_KEY = new Key<ModuleList>(){

        @Override
        public ModuleList get(Map<Key, Object> context) {
            return (ModuleList)context.get(this);
        }
    };
    public static final Key<AbstractName> APPLICATION_JNDI_NAME_KEY = new Key<AbstractName>(){

        @Override
        public AbstractName get(Map<Key, Object> context) {
            return (AbstractName)context.get(this);
        }
    };
    public static final Key<AbstractName> JACC_MANAGER_NAME_KEY = new Key<AbstractName>(){

        @Override
        public AbstractName get(Map<Key, Object> context) {
            return (AbstractName)context.get(this);
        }
    };

    public EARContext(File baseDir, File inPlaceConfigurationDir, Environment environment, ConfigurationModuleType moduleType, Naming naming, ConfigurationManager configurationManager, BundleContext bundleContext, AbstractNameQuery serverName, AbstractName baseName, AbstractNameQuery transactionManagerObjectName, AbstractNameQuery connectionTrackerObjectName, AbstractNameQuery corbaGBeanObjectName) throws DeploymentException {
        this(baseDir, inPlaceConfigurationDir, environment, moduleType, naming, configurationManager, bundleContext, serverName, baseName, transactionManagerObjectName, connectionTrackerObjectName, corbaGBeanObjectName, new HashMap());
    }

    public EARContext(File baseDir, File inPlaceConfigurationDir, Environment environment, ConfigurationModuleType moduleType, Naming naming, ConfigurationManager configurationManager, BundleContext bundleContext, AbstractNameQuery serverName, AbstractName baseName, AbstractNameQuery transactionManagerObjectName, AbstractNameQuery connectionTrackerObjectName, AbstractNameQuery corbaGBeanObjectName, Map messageDestinations) throws DeploymentException {
        super(baseDir, inPlaceConfigurationDir, environment, baseName, moduleType, naming, configurationManager, bundleContext);
        this.serverName = serverName;
        this.transactionManagerObjectName = transactionManagerObjectName;
        this.connectionTrackerObjectName = connectionTrackerObjectName;
        this.corbaGBeanObjectName = corbaGBeanObjectName;
        this.messageDestinations = messageDestinations;
    }

    public EARContext(File baseDir, File inPlaceConfigurationDir, Environment environment, ConfigurationModuleType moduleType, AbstractName baseName, EARContext parent) throws DeploymentException {
        this(baseDir, inPlaceConfigurationDir, environment, moduleType, baseName, parent.getTransactionManagerName(), parent.getConnectionTrackerName(), parent.getCORBAGBeanName(), parent);
    }

    public EARContext(File baseDir, File inPlaceConfigurationDir, Environment environment, ConfigurationModuleType moduleType, AbstractName baseName, AbstractNameQuery transactionManagerName, AbstractNameQuery connectionTrackerName, AbstractNameQuery corbaGBeanName, EARContext parent) throws DeploymentException {
        super(baseDir, inPlaceConfigurationDir, environment, baseName, moduleType, parent.getNaming(), parent.getConfigurationManager(), parent.getBundleContext());
        this.serverName = parent.getServerName();
        this.transactionManagerObjectName = transactionManagerName;
        this.connectionTrackerObjectName = connectionTrackerName;
        this.corbaGBeanObjectName = corbaGBeanName;
        this.messageDestinations = new HashMap();
    }

    protected EARContext(File baseDir, File inPlaceConfigurationDir, Environment environment, ConfigurationModuleType moduleType, Naming naming, ConfigurationManager configurationManager, ResourceContext resourceContext, BundleContext bundleContext, AbstractNameQuery serverName, AbstractName baseName, AbstractNameQuery transactionManagerObjectName, AbstractNameQuery connectionTrackerObjectName, AbstractNameQuery corbaGBeanObjectName, Map messageDestinations) throws DeploymentException {
        super(baseDir, inPlaceConfigurationDir, environment, baseName, moduleType, naming, configurationManager, resourceContext, bundleContext);
        this.serverName = serverName;
        this.transactionManagerObjectName = transactionManagerObjectName;
        this.connectionTrackerObjectName = connectionTrackerObjectName;
        this.corbaGBeanObjectName = corbaGBeanObjectName;
        this.messageDestinations = messageDestinations;
    }

    public AbstractNameQuery getServerName() {
        return this.serverName;
    }

    public AbstractNameQuery getTransactionManagerName() {
        return this.transactionManagerObjectName;
    }

    public AbstractNameQuery getConnectionTrackerName() {
        return this.connectionTrackerObjectName;
    }

    public AbstractNameQuery getCORBAGBeanName() {
        return this.corbaGBeanObjectName;
    }

    public Map getContextIDToPermissionsMap() {
        return this.contextIDToPermissionsMap;
    }

    public void addSecurityContext(String contextID, Object componentPermissions) throws DeploymentException {
        Object old = this.contextIDToPermissionsMap.put(contextID, componentPermissions);
        if (old != null) {
            throw new DeploymentException("Duplicate contextID registered! " + contextID);
        }
    }

    public void setSecurityConfiguration(Object securityConfiguration) throws DeploymentException {
        if (this.securityConfiguration != null) {
            throw new DeploymentException("Only one security configuration allowed per application");
        }
        this.securityConfiguration = securityConfiguration;
    }

    public Object getSecurityConfiguration() {
        return this.securityConfiguration;
    }

    public void registerMessageDestionations(String moduleName, Map nameMap) throws DeploymentException {
        this.messageDestinations.put(moduleName, nameMap);
    }

    public Map getMessageDestinations() {
        return this.messageDestinations;
    }

    public Map<Key, Object> getGeneralData() {
        return this.generalData;
    }

    public boolean isHasSecurity() {
        return this.hasSecurity;
    }

    public void setHasSecurity(boolean hasSecurity) {
        this.hasSecurity = hasSecurity;
    }

    public static interface Key<T> {
        public T get(Map<Key, Object> var1);
    }
}

