/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.ModuleIDBuilder;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.ReferenceCollection;
import org.apache.geronimo.gbean.ReferenceCollectionEvent;
import org.apache.geronimo.gbean.ReferenceCollectionListener;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.ModuleBuilder;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public class SwitchingModuleBuilder
implements ModuleBuilder {
    private final Map namespaceToBuilderMap = new HashMap();
    private String defaultNamespace;
    public static final GBeanInfo GBEAN_INFO;

    public SwitchingModuleBuilder(Collection builders) {
        ReferenceCollection buildersCollection = (ReferenceCollection)builders;
        buildersCollection.addReferenceCollectionListener(new ReferenceCollectionListener(){

            public void memberAdded(ReferenceCollectionEvent event) {
                ModuleBuilder builder = (ModuleBuilder)event.getMember();
                String namespace = builder.getSchemaNamespace();
                SwitchingModuleBuilder.this.namespaceToBuilderMap.put(namespace, builder);
            }

            public void memberRemoved(ReferenceCollectionEvent event) {
                ModuleBuilder builder = (ModuleBuilder)event.getMember();
                String namespace = builder.getSchemaNamespace();
                SwitchingModuleBuilder.this.namespaceToBuilderMap.remove(namespace);
            }
        });
        for (ModuleBuilder builder : builders) {
            String namespace = builder.getSchemaNamespace();
            this.namespaceToBuilderMap.put(namespace, builder);
        }
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public void setDefaultNamespace(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }

    public Module createModule(File plan, JarFile moduleFile, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        String namespace = plan == null ? this.defaultNamespace : this.getNamespaceFromPlan(plan);
        ModuleBuilder builder = this.getBuilderFromNamespace(namespace);
        if (builder != null) {
            return builder.createModule(plan, moduleFile, naming, idBuilder);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNamespaceFromPlan(Object plan) throws DeploymentException {
        XmlObject xmlObject;
        if (plan instanceof File) {
            try {
                xmlObject = XmlBeansUtil.parse((URL)((File)plan).toURL(), (ClassLoader)this.getClass().getClassLoader());
            }
            catch (IOException e) {
                throw new DeploymentException("Could not read plan file", (Throwable)e);
            }
            catch (XmlException e) {
                throw new DeploymentException("Plan file does not contain well formed xml", (Throwable)e);
            }
        } else if (plan instanceof XmlObject) {
            xmlObject = (XmlObject)plan;
        } else {
            return this.defaultNamespace;
        }
        XmlCursor cursor = xmlObject.newCursor();
        try {
            while (cursor.hasNextToken()) {
                if (cursor.isStart()) {
                    String string = cursor.getName().getNamespaceURI();
                    return string;
                }
                cursor.toNextToken();
            }
        }
        finally {
            cursor.dispose();
        }
        throw new DeploymentException("Cannot find namespace in xmlObject: " + xmlObject.xmlText());
    }

    private ModuleBuilder getBuilderFromNamespace(String namespace) {
        ModuleBuilder builder = (ModuleBuilder)this.namespaceToBuilderMap.get(namespace);
        if (builder == null) {
            builder = (ModuleBuilder)this.namespaceToBuilderMap.get(this.defaultNamespace);
        }
        if (builder == null && this.namespaceToBuilderMap.size() == 1) {
            builder = (ModuleBuilder)this.namespaceToBuilderMap.values().iterator().next();
        }
        return builder;
    }

    public Module createModule(Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, Environment environment, Object moduleContextInfo, AbstractName earName, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        String namespace = this.getNamespaceFromPlan(plan);
        ModuleBuilder builder = this.getBuilderFromNamespace(namespace);
        if (builder != null) {
            return builder.createModule(plan, moduleFile, targetPath, specDDUrl, environment, moduleContextInfo, earName, naming, idBuilder);
        }
        return null;
    }

    public void installModule(JarFile earFile, EARContext earContext, Module module, Collection configurationStores, ConfigurationStore targetConfigurationStore, Collection repositories) throws DeploymentException {
        String namespace = module.getNamespace();
        ModuleBuilder builder = this.getBuilderFromNamespace(namespace);
        builder.installModule(earFile, earContext, module, configurationStores, targetConfigurationStore, repositories);
    }

    public void initContext(EARContext earContext, Module module, ClassLoader cl) throws DeploymentException {
        String namespace = module.getNamespace();
        ModuleBuilder builder = this.getBuilderFromNamespace(namespace);
        builder.initContext(earContext, module, cl);
    }

    public void addGBeans(EARContext earContext, Module module, ClassLoader cl, Collection repositories) throws DeploymentException {
        String namespace = module.getNamespace();
        ModuleBuilder builder = this.getBuilderFromNamespace(namespace);
        builder.addGBeans(earContext, module, cl, repositories);
    }

    public String getSchemaNamespace() {
        return null;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(SwitchingModuleBuilder.class, (String)"ModuleBuilder");
        infoBuilder.addAttribute("defaultNamespace", String.class, true, true);
        infoBuilder.addReference("ModuleBuilders", ModuleBuilder.class, "ModuleBuilder");
        infoBuilder.addInterface(ModuleBuilder.class);
        infoBuilder.setConstructor(new String[]{"ModuleBuilders"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

