/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.PersistenceUnit;
import javax.persistence.PersistenceUnits;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.j2ee.deployment.annotation.AnnotatedApp;
import org.apache.geronimo.j2ee.deployment.annotation.AnnotationHelper;
import org.apache.geronimo.xbeans.javaee.InjectionTargetType;
import org.apache.geronimo.xbeans.javaee.JndiNameType;
import org.apache.geronimo.xbeans.javaee.PersistenceUnitRefType;
import org.apache.geronimo.xbeans.javaee.String;
import org.apache.xbean.finder.ClassFinder;

public final class PersistenceUnitAnnotationHelper
extends AnnotationHelper {
    private static final Log log = LogFactory.getLog(PersistenceUnitAnnotationHelper.class);

    private PersistenceUnitAnnotationHelper() {
    }

    public static void processAnnotations(AnnotatedApp annotatedApp, ClassFinder classFinder) throws DeploymentException {
        if (annotatedApp != null) {
            if (classFinder.isAnnotationPresent(PersistenceUnits.class)) {
                PersistenceUnitAnnotationHelper.processPersistenceUnits(annotatedApp, classFinder);
            }
            if (classFinder.isAnnotationPresent(PersistenceUnit.class)) {
                PersistenceUnitAnnotationHelper.processPersistenceUnit(annotatedApp, classFinder);
            }
        }
    }

    private static void processPersistenceUnit(AnnotatedApp annotatedApp, ClassFinder classFinder) throws DeploymentException {
        PersistenceUnit persistenceUnit;
        log.debug((Object)("processPersistenceUnit(): Entry: AnnotatedApp: " + ((Object)annotatedApp).toString()));
        List classeswithPersistenceUnit = classFinder.findAnnotatedClasses(PersistenceUnit.class);
        List methodswithPersistenceUnit = classFinder.findAnnotatedMethods(PersistenceUnit.class);
        List fieldswithPersistenceUnit = classFinder.findAnnotatedFields(PersistenceUnit.class);
        for (Class cls : classeswithPersistenceUnit) {
            persistenceUnit = cls.getAnnotation(PersistenceUnit.class);
            if (persistenceUnit == null) continue;
            PersistenceUnitAnnotationHelper.addPersistenceUnit(annotatedApp, persistenceUnit, cls, null, null);
        }
        for (Method method : methodswithPersistenceUnit) {
            persistenceUnit = method.getAnnotation(PersistenceUnit.class);
            if (persistenceUnit == null) continue;
            PersistenceUnitAnnotationHelper.addPersistenceUnit(annotatedApp, persistenceUnit, null, method, null);
        }
        for (Field field : fieldswithPersistenceUnit) {
            persistenceUnit = field.getAnnotation(PersistenceUnit.class);
            if (persistenceUnit == null) continue;
            PersistenceUnitAnnotationHelper.addPersistenceUnit(annotatedApp, persistenceUnit, null, null, field);
        }
        PersistenceUnitAnnotationHelper.validateDD(annotatedApp);
        log.debug((Object)("processPersistenceUnit(): Exit: AnnotatedApp: " + ((Object)annotatedApp).toString()));
    }

    private static void processPersistenceUnits(AnnotatedApp annotatedApp, ClassFinder classFinder) throws DeploymentException {
        log.debug((Object)"processPersistenceUnits(): Entry");
        List classeswithPersistenceUnits = classFinder.findAnnotatedClasses(PersistenceUnits.class);
        ArrayList<PersistenceUnit> persistenceUnitList = new ArrayList<PersistenceUnit>();
        for (Class cls : classeswithPersistenceUnits) {
            PersistenceUnits persistenceUnits = cls.getAnnotation(PersistenceUnits.class);
            if (persistenceUnits != null) {
                persistenceUnitList.addAll(Arrays.asList(persistenceUnits.value()));
            }
            for (PersistenceUnit persistenceUnit : persistenceUnitList) {
                PersistenceUnitAnnotationHelper.addPersistenceUnit(annotatedApp, persistenceUnit, cls, null, null);
            }
            persistenceUnitList.clear();
        }
        log.debug((Object)"processPersistenceUnits(): Exit");
    }

    private static void addPersistenceUnit(AnnotatedApp annotatedApp, PersistenceUnit annotation, Class cls, Method method, Field field) {
        PersistenceUnitRefType[] persistenceUnitRefs;
        log.debug((Object)("addPersistenceUnit( [annotatedApp] " + ((Object)annotatedApp).toString() + "," + '\n' + "[annotation] " + annotation.toString() + "," + '\n' + "[cls] " + (cls != null ? cls.getName() : null) + "," + '\n' + "[method] " + (method != null ? method.getName() : null) + "," + '\n' + "[field] " + (field != null ? field.getName() : null) + " ): Entry"));
        java.lang.String persistenceUnitRefName = annotation.name();
        if (persistenceUnitRefName.equals("")) {
            if (method != null) {
                StringBuilder stringBuilder = new StringBuilder(method.getName().substring(3));
                stringBuilder.setCharAt(0, Character.toLowerCase(stringBuilder.charAt(0)));
                persistenceUnitRefName = method.getDeclaringClass().getName() + "/" + stringBuilder.toString();
            } else if (field != null) {
                persistenceUnitRefName = field.getDeclaringClass().getName() + "/" + field.getName();
            }
        }
        log.debug((Object)("addPersistenceUnit(): persistenceUnitRefName: " + persistenceUnitRefName));
        for (PersistenceUnitRefType persistenceUnitRef : persistenceUnitRefs = annotatedApp.getPersistenceUnitRefArray()) {
            InjectionTargetType[] targets;
            if (!persistenceUnitRef.getPersistenceUnitRefName().getStringValue().trim().equals(persistenceUnitRefName)) continue;
            if (!(method == null && field == null || PersistenceUnitAnnotationHelper.hasTarget(method, field, targets = persistenceUnitRef.getInjectionTargetArray()))) {
                PersistenceUnitAnnotationHelper.configureInjectionTarget(persistenceUnitRef.addNewInjectionTarget(), method, field);
            }
            return;
        }
        PersistenceUnitRefType persistenceUnitRef = annotatedApp.addNewPersistenceUnitRef();
        JndiNameType unitRefName = persistenceUnitRef.addNewPersistenceUnitRefName();
        unitRefName.setStringValue(persistenceUnitRefName);
        java.lang.String unitNameAnnotation = annotation.unitName();
        if (!unitNameAnnotation.equals("")) {
            String persistenceUnitName = persistenceUnitRef.addNewPersistenceUnitName();
            persistenceUnitName.setStringValue(unitNameAnnotation);
        }
        if (method != null || field != null) {
            PersistenceUnitAnnotationHelper.configureInjectionTarget(persistenceUnitRef.addNewInjectionTarget(), method, field);
        }
    }
}

