/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.farm.discovery;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.geronimo.farm.discovery.DiscoveryAgent;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.kernel.rmi.RMIRegistryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean
public class JmxDiscoveryPublisher
implements GBeanLifecycle {
    private static final Logger log = LoggerFactory.getLogger(JmxDiscoveryPublisher.class);
    private final URI service;
    private final DiscoveryAgent discoveryAgent;

    public JmxDiscoveryPublisher(@ParamAttribute(name="nodeName") String nodeName, @ParamAttribute(name="clusterName") String clusterName, @ParamAttribute(name="protocol") String protocol, @ParamAttribute(name="urlPath") String urlPath, @ParamAttribute(name="discoveryType") String discoveryType, @ParamReference(name="DiscoveryAgent") DiscoveryAgent discoveryAgent, @ParamReference(name="RMIRegistryService") RMIRegistryService rmiRegistryService) throws URISyntaxException, IOException {
        this.discoveryAgent = discoveryAgent;
        String query = null;
        if (nodeName != null && nodeName.length() > 0) {
            query = "node=" + nodeName;
        }
        if (clusterName != null) {
            query = (query == null ? "" : query + "&") + "cluster=" + clusterName;
        }
        this.service = new URI(discoveryType + ":" + protocol, null, rmiRegistryService.getHost(), rmiRegistryService.getPort(), "/" + urlPath, query, null);
        log.info("Register service:" + this.service + " to discoveryAgent");
        discoveryAgent.registerService(this.service);
    }

    public void doStart() throws Exception {
    }

    public void doStop() throws Exception {
        this.discoveryAgent.unregisterService(this.service);
    }

    public void doFail() {
        try {
            this.doStop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

