/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.farm.deployment;

import org.apache.geronimo.farm.deployment.ConfigurationNameBuilder;
import org.apache.geronimo.kernel.repository.Artifact;

public class BasicConfigurationNameBuilder
implements ConfigurationNameBuilder {
    private static final String ARTIFACT_SUFFIX = "_G_MASTER";

    public Artifact buildMasterConfigurationName(Artifact configId) {
        return this.newArtifact(configId, configId.getArtifactId() + ARTIFACT_SUFFIX);
    }

    public Artifact buildSlaveConfigurationName(Artifact configId) {
        if (!this.isMasterConfigurationName(configId)) {
            throw new IllegalArgumentException("[" + configId + "] is not a master configuration name");
        }
        String artifactId = configId.getArtifactId();
        return this.newArtifact(configId, artifactId.substring(0, artifactId.length() - ARTIFACT_SUFFIX.length()));
    }

    public boolean isMasterConfigurationName(Artifact configId) {
        return configId.getArtifactId().endsWith(ARTIFACT_SUFFIX);
    }

    protected Artifact newArtifact(Artifact configId, String artifactId) {
        return new Artifact(configId.getGroupId(), artifactId, configId.getVersion(), configId.getType());
    }
}

