/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.derby;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.geronimo.derby.DerbySystem;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DerbyNetworkGBean
implements GBeanLifecycle {
    private static final Logger log = LoggerFactory.getLogger(DerbyNetworkGBean.class);
    private NetworkServerControl network;
    private String host = "localhost";
    private int port = 1527;
    private String userName = "dbadmin";
    private String userPassword = "manager";
    public static final GBeanInfo GBEAN_INFO;

    public DerbyNetworkGBean(DerbySystem system) {
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public void setUserPassword(String userPassword) {
        this.userPassword = userPassword;
    }

    public InetSocketAddress getAddress() {
        return new InetSocketAddress(this.getHost(), this.getPort());
    }

    public void doStart() throws Exception {
        InetAddress address = InetAddress.getByName(this.host);
        this.network = "false".equals(System.getProperty("derby.connection.requireAuthentication")) ? new NetworkServerControl(address, this.port) : new NetworkServerControl(address, this.port, this.userName, this.userPassword);
        this.network.start(null);
        log.debug("Started on host " + this.host + ':' + this.port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStop() throws Exception {
        if (this.network != null) {
            try {
                this.network.shutdown();
            }
            finally {
                this.network = null;
            }
        }
        log.debug("Stopped");
    }

    public void doFail() {
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((String)"Derby Connector", DerbyNetworkGBean.class);
        infoFactory.addAttribute("host", String.class, true, true);
        infoFactory.addAttribute("port", Integer.TYPE, true, true);
        infoFactory.addAttribute("userName", String.class, true, true);
        infoFactory.addAttribute("userPassword", String.class, true, true);
        infoFactory.addAttribute("address", InetSocketAddress.class, false);
        infoFactory.addReference("derbySystem", DerbySystem.class, "GBean");
        infoFactory.setConstructor(new String[]{"derbySystem"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

