/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.derby;

import java.sql.SQLException;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.derby.authentication.UserAuthenticator;
import org.apache.geronimo.derby.Credentials;
import org.apache.geronimo.security.realm.providers.GeronimoGroupPrincipal;

public class DerbyUserAuthenticator
implements UserAuthenticator {
    private static final Log log = LogFactory.getLog((String)"DerbyUserAuthenticator");
    private static final String configName = "geronimo-admin";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticateUser(String userName, String userPassword, String databaseName, Properties info) throws SQLException {
        Thread thread = Thread.currentThread();
        ClassLoader oldCL = thread.getContextClassLoader();
        Credentials credentials = new Credentials(userName, userPassword);
        try {
            thread.setContextClassLoader(DerbyUserAuthenticator.class.getClassLoader());
            LoginContext context = new LoginContext(configName, credentials);
            context.login();
            Subject sub = context.getSubject();
            Set<GeronimoGroupPrincipal> pricipalsGroup = sub.getPrincipals(GeronimoGroupPrincipal.class);
            boolean databaseLevelFlag = false;
            for (GeronimoGroupPrincipal principal : pricipalsGroup) {
                if (principal.getName().equalsIgnoreCase("derbyadmin")) {
                    boolean bl = true;
                    return bl;
                }
                if (databaseName == null) continue;
                databaseLevelFlag = principal.getName().equalsIgnoreCase("derby_" + databaseName);
            }
            if (!databaseLevelFlag) {
                this.logAuthenticationFailure(userName, userPassword, databaseName);
            }
            boolean bl = databaseLevelFlag;
            return bl;
        }
        catch (LoginException e) {
            this.logAuthenticationFailure(userName, userPassword, databaseName);
            boolean bl = false;
            return bl;
        }
        finally {
            credentials.clear();
            thread.setContextClassLoader(oldCL);
        }
    }

    private void logAuthenticationFailure(String userName, String userPassword, String databaseName) {
        log.warn((Object)("User authentication failure (userName userPassword databaseName): " + userName + " " + userPassword + " " + databaseName));
    }
}

