/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.ClassPathList;
import org.apache.geronimo.deployment.CopyResourceContext;
import org.apache.geronimo.deployment.DeploymentConfigurationManager;
import org.apache.geronimo.deployment.InPlaceResourceContext;
import org.apache.geronimo.deployment.ModuleList;
import org.apache.geronimo.deployment.ResourceContext;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GReferenceInfo;
import org.apache.geronimo.gbean.ReferencePatterns;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.NoSuchConfigException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Environment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentContext {
    private final File baseDir;
    private final File inPlaceConfigurationDir;
    private final ResourceContext resourceContext;
    private final byte[] buffer = new byte[4096];
    private final Map<String, ConfigurationData> childConfigurationDatas = new LinkedHashMap<String, ConfigurationData>();
    private final ConfigurationManager configurationManager;
    private final Configuration configuration;
    private final Naming naming;
    private final List<ConfigurationData> additionalDeployment = new ArrayList<ConfigurationData>();
    protected final AbstractName moduleName;

    public DeploymentContext(File baseDir, File inPlaceConfigurationDir, Environment environment, AbstractName moduleName, ConfigurationModuleType moduleType, Naming naming, ConfigurationManager configurationManager, Collection repositories) throws DeploymentException {
        this(baseDir, inPlaceConfigurationDir, environment, moduleName, moduleType, naming, DeploymentContext.createConfigurationManager(configurationManager, repositories));
    }

    public DeploymentContext(File baseDir, File inPlaceConfigurationDir, Environment environment, AbstractName moduleName, ConfigurationModuleType moduleType, Naming naming, ConfigurationManager configurationManager) throws DeploymentException {
        if (baseDir == null) {
            throw new NullPointerException("baseDir is null");
        }
        if (environment == null) {
            throw new NullPointerException("environment is null");
        }
        if (moduleType == null) {
            throw new NullPointerException("type is null");
        }
        if (configurationManager == null) {
            throw new NullPointerException("configurationManager is null");
        }
        if (!baseDir.exists()) {
            baseDir.mkdirs();
        }
        this.baseDir = baseDir;
        this.inPlaceConfigurationDir = inPlaceConfigurationDir;
        this.moduleName = moduleName;
        this.naming = naming;
        this.configuration = DeploymentContext.createTempConfiguration(environment, moduleType, baseDir, inPlaceConfigurationDir, configurationManager, naming);
        this.configurationManager = configurationManager;
        this.resourceContext = null == inPlaceConfigurationDir ? new CopyResourceContext(this.configuration, baseDir) : new InPlaceResourceContext(this.configuration, inPlaceConfigurationDir);
    }

    private static ConfigurationManager createConfigurationManager(ConfigurationManager configurationManager, Collection repositories) {
        return new DeploymentConfigurationManager(configurationManager, repositories);
    }

    private static Configuration createTempConfiguration(Environment environment, ConfigurationModuleType moduleType, File baseDir, File inPlaceConfigurationDir, ConfigurationManager configurationManager, Naming naming) throws DeploymentException {
        try {
            configurationManager.loadConfiguration(new ConfigurationData(moduleType, null, null, null, environment, baseDir, inPlaceConfigurationDir, naming));
            return configurationManager.getConfiguration(environment.getConfigId());
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to create configuration for deployment", (Throwable)e);
        }
    }

    public ConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    public Artifact getConfigID() {
        return this.configuration.getId();
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public File getInPlaceConfigurationDir() {
        return this.inPlaceConfigurationDir;
    }

    public Naming getNaming() {
        return this.naming;
    }

    public GBeanData addGBean(String name, GBeanInfo gbeanInfo) throws GBeanAlreadyExistsException {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (gbeanInfo == null) {
            throw new NullPointerException("gbean is null");
        }
        GBeanData gbean = new GBeanData(gbeanInfo);
        this.configuration.addGBean(name, gbean);
        return gbean;
    }

    public void addGBean(GBeanData gbean) throws GBeanAlreadyExistsException {
        if (gbean == null) {
            throw new NullPointerException("gbean is null");
        }
        if (gbean.getAbstractName() == null) {
            throw new NullPointerException("gbean.getAbstractName() is null");
        }
        this.configuration.addGBean(gbean);
    }

    public void removeGBean(AbstractName name) throws GBeanNotFoundException {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        this.configuration.removeGBean(name);
    }

    public Set<AbstractName> getGBeanNames() {
        return new HashSet<AbstractName>(this.configuration.getGBeans().keySet());
    }

    public Set<AbstractName> listGBeans(AbstractNameQuery pattern) {
        return this.findGBeans(pattern);
    }

    public AbstractName findGBean(AbstractNameQuery pattern) throws GBeanNotFoundException {
        return this.configuration.findGBean(pattern);
    }

    public AbstractName findGBean(Set<AbstractNameQuery> patterns) throws GBeanNotFoundException {
        return this.configuration.findGBean(patterns);
    }

    public LinkedHashSet<AbstractName> findGBeans(AbstractNameQuery pattern) {
        return this.configuration.findGBeans(pattern);
    }

    public LinkedHashSet<GBeanData> findGBeanDatas(Configuration configuration, AbstractNameQuery pattern) {
        return configuration.findGBeanDatas(configuration, Collections.singleton(pattern));
    }

    public LinkedHashSet<AbstractName> findGBeans(Set<AbstractNameQuery> patterns) {
        return this.configuration.findGBeans(patterns);
    }

    public GBeanData getGBeanInstance(AbstractName name) throws GBeanNotFoundException {
        Map gbeans = this.configuration.getGBeans();
        GBeanData gbeanData = (GBeanData)gbeans.get(name);
        if (gbeanData == null) {
            throw new GBeanNotFoundException(name);
        }
        return gbeanData;
    }

    public void addIncludeAsPackedJar(URI targetPath, JarFile jarFile) throws IOException {
        this.resourceContext.addIncludeAsPackedJar(targetPath, jarFile);
    }

    public void addInclude(URI targetPath, ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        this.resourceContext.addInclude(targetPath, zipFile, zipEntry);
    }

    public void addInclude(URI targetPath, URL source) throws IOException {
        this.resourceContext.addInclude(targetPath, source);
    }

    public void addInclude(URI targetPath, File source) throws IOException {
        this.resourceContext.addInclude(targetPath, source);
    }

    public void getCompleteManifestClassPath(JarFile moduleFile, URI moduleBaseUri, URI resolutionUri, ClassPathList classpath, ModuleList exclusions) throws DeploymentException {
        ArrayList<DeploymentException> problems = new ArrayList<DeploymentException>();
        this.getCompleteManifestClassPath(moduleFile, moduleBaseUri, resolutionUri, classpath, exclusions, new DefaultJarFileFactory(), problems);
        if (!problems.isEmpty()) {
            if (problems.size() == 1) {
                throw (DeploymentException)((Object)problems.get(0));
            }
            throw new DeploymentException("Determining complete manifest classpath unsuccessful:", problems);
        }
    }

    public void getCompleteManifestClassPath(JarFile moduleFile, URI moduleBaseUri, URI resolutionUri, ClassPathList classpath, ModuleList exclusions, JarFileFactory factory, List<DeploymentException> problems) throws DeploymentException {
        String manifestClassPath;
        try {
            manifestClassPath = factory.getManifestClassPath(moduleFile);
        }
        catch (IOException e) {
            problems.add(new DeploymentException(this.printInfo("Could not read manifest: " + moduleBaseUri, moduleBaseUri, classpath, exclusions), (Throwable)e));
            return;
        }
        if (manifestClassPath == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(manifestClassPath, " ");
        while (tokenizer.hasMoreTokens()) {
            JarFile classPathJarFile;
            URI resolvedUri;
            String classpathEntry;
            URI pathUri;
            String path = tokenizer.nextToken();
            try {
                pathUri = new URI(path);
            }
            catch (URISyntaxException e) {
                problems.add(new DeploymentException(this.printInfo("Invalid manifest classpath entry, path=" + path, moduleBaseUri, classpath, exclusions)));
                return;
            }
            if (!pathUri.getPath().endsWith(".jar")) {
                problems.add(new DeploymentException(this.printInfo("Manifest class path entries must end with the .jar extension (J2EE 1.4 Section 8.2): path=" + path, moduleBaseUri, classpath, exclusions)));
                return;
            }
            if (pathUri.isAbsolute()) {
                problems.add(new DeploymentException(this.printInfo("Manifest class path entries must be relative (J2EE 1.4 Section 8.2): path=" + path, moduleBaseUri, classpath, exclusions)));
                return;
            }
            URI targetUri = moduleBaseUri.resolve(pathUri);
            if (targetUri.getPath().endsWith("/")) {
                problems.add(new DeploymentException(this.printInfo("target path must not end with a '/' character: path=" + path + ", resolved to targetURI=" + targetUri, moduleBaseUri, classpath, exclusions)));
                return;
            }
            String targetEntry = targetUri.toString();
            if (exclusions.contains(targetEntry) || classpath.contains(classpathEntry = (resolvedUri = resolutionUri.resolve(targetUri)).toString())) continue;
            classpath.add(classpathEntry);
            try {
                classPathJarFile = factory.newJarFile(targetUri);
            }
            catch (IOException e) {
                problems.add(new DeploymentException(this.printInfo("Manifest class path entries must be a valid jar file (JAVAEE 5 Section 8.2): path=" + path + ", resolved to targetURI=" + targetUri, moduleBaseUri, classpath, exclusions), (Throwable)e));
                return;
            }
            this.getCompleteManifestClassPath(classPathJarFile, targetUri, resolutionUri, classpath, exclusions, factory, problems);
        }
    }

    private String printInfo(String message, URI moduleBaseUri, ClassPathList classpath, ModuleList exclusions) {
        StringBuffer buf = new StringBuffer(message).append("\n");
        buf.append("    looking at: ").append(moduleBaseUri);
        buf.append("    current classpath: ").append(classpath);
        buf.append("    ignoring modules: ").append(exclusions);
        return buf.toString();
    }

    public void addManifestClassPath(JarFile moduleFile, URI moduleBaseUri) throws DeploymentException {
        Manifest manifest;
        try {
            manifest = moduleFile.getManifest();
        }
        catch (IOException e) {
            throw new DeploymentException("Could not read manifest: " + moduleBaseUri);
        }
        if (manifest == null) {
            return;
        }
        String manifestClassPath = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        if (manifestClassPath == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(manifestClassPath, " ");
        while (tokenizer.hasMoreTokens()) {
            URI pathUri;
            String path = tokenizer.nextToken();
            try {
                pathUri = new URI(path);
            }
            catch (URISyntaxException e) {
                throw new DeploymentException("Invalid manifest classpath entry: module=" + moduleBaseUri + ", path=" + path);
            }
            if (!pathUri.getPath().endsWith(".jar")) {
                throw new DeploymentException("Manifest class path entries must end with the .jar extension (J2EE 1.4 Section 8.2): module=" + moduleBaseUri);
            }
            if (pathUri.isAbsolute()) {
                throw new DeploymentException("Manifest class path entries must be relative (J2EE 1.4 Section 8.2): moduel=" + moduleBaseUri);
            }
            try {
                URI targetUri = moduleBaseUri.resolve(pathUri);
                if (targetUri.getPath().endsWith("/")) {
                    throw new IllegalStateException("target path must not end with a '/' character: " + targetUri);
                }
                this.configuration.addToClassPath(targetUri.toString());
            }
            catch (IOException e) {
                throw new DeploymentException((Throwable)e);
            }
        }
    }

    public void addClass(URI targetPath, String fqcn, byte[] bytes) throws IOException, URISyntaxException {
        if (!targetPath.getPath().endsWith("/")) {
            throw new IllegalStateException("target path must end with a '/' character: " + targetPath);
        }
        String classFileName = fqcn.replace('.', '/') + ".class";
        File targetFile = this.getTargetFile(new URI(targetPath.toString() + classFileName));
        this.addFile(targetFile, new ByteArrayInputStream(bytes));
        this.configuration.addToClassPath(targetPath.toString());
    }

    public void addFile(URI targetPath, ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        this.resourceContext.addFile(targetPath, zipFile, zipEntry);
    }

    public void addFile(URI targetPath, URL source) throws IOException {
        this.resourceContext.addFile(targetPath, source);
    }

    public void addFile(URI targetPath, File source) throws IOException {
        this.resourceContext.addFile(targetPath, source);
    }

    public void addFile(URI targetPath, String source) throws IOException {
        this.resourceContext.addFile(targetPath, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFile(File targetFile, InputStream source) throws IOException {
        targetFile.getParentFile().mkdirs();
        FileOutputStream out = null;
        try {
            int count;
            out = new FileOutputStream(targetFile);
            while ((count = source.read(this.buffer)) > 0) {
                ((OutputStream)out).write(this.buffer, 0, count);
            }
        }
        catch (Throwable throwable) {
            DeploymentUtil.close(out);
            throw throwable;
        }
        DeploymentUtil.close(out);
    }

    public File getTargetFile(URI targetPath) {
        return this.resourceContext.getTargetFile(targetPath);
    }

    public ClassLoader getClassLoader() throws DeploymentException {
        return this.configuration.getConfigurationClassLoader();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void flush() throws IOException {
        this.resourceContext.flush();
    }

    public void close() throws IOException, DeploymentException {
        if (this.configurationManager != null) {
            try {
                this.configurationManager.unloadConfiguration(this.configuration.getId());
            }
            catch (NoSuchConfigException noSuchConfigException) {
                // empty catch block
            }
        }
    }

    public void addChildConfiguration(String moduleName, ConfigurationData configurationData) {
        this.childConfigurationDatas.put(moduleName, configurationData);
    }

    public ConfigurationData getConfigurationData() throws DeploymentException {
        List<String> failures = this.verify(this.configuration);
        if (!failures.isEmpty()) {
            StringBuffer message = new StringBuffer();
            for (String failure : failures) {
                if (message.length() > 0) {
                    message.append("\n");
                }
                message.append(failure);
            }
            throw new DeploymentException(message.toString());
        }
        ArrayList gbeans = new ArrayList(this.configuration.getGBeans().values());
        Collections.sort(gbeans, new GBeanData.PriorityComparator());
        ConfigurationData configurationData = new ConfigurationData(this.configuration.getModuleType(), new LinkedHashSet(this.configuration.getClassPath()), gbeans, this.childConfigurationDatas, this.configuration.getEnvironment(), this.baseDir, this.inPlaceConfigurationDir, this.naming);
        for (ConfigurationData ownedConfiguration : this.additionalDeployment) {
            configurationData.addOwnedConfigurations(ownedConfiguration.getId());
        }
        return configurationData;
    }

    public void addAdditionalDeployment(ConfigurationData configurationData) {
        this.additionalDeployment.add(configurationData);
    }

    public List getAdditionalDeployment() {
        return this.additionalDeployment;
    }

    public AbstractName getModuleName() {
        return this.moduleName;
    }

    public List<String> verify(Configuration configuration) throws DeploymentException {
        ArrayList<String> failures = new ArrayList<String>();
        for (Map.Entry entry : this.configuration.getGBeans().entrySet()) {
            AbstractName name = (AbstractName)entry.getKey();
            GBeanData gbean = (GBeanData)entry.getValue();
            for (Map.Entry referenceEntry : gbean.getReferences().entrySet()) {
                ReferencePatterns referencePatterns;
                String referenceName = (String)referenceEntry.getKey();
                String failure = this.verifyReference(gbean, referenceName, referencePatterns = (ReferencePatterns)referenceEntry.getValue(), configuration);
                if (failure == null) continue;
                failures.add(failure);
            }
            for (ReferencePatterns referencePatterns : gbean.getDependencies()) {
                String failure = this.verifyDependency(name, referencePatterns, configuration);
                if (failure == null) continue;
                failures.add(failure);
            }
        }
        return failures;
    }

    private String verifyReference(GBeanData gbean, String referenceName, ReferencePatterns referencePatterns, Configuration configuration) {
        GReferenceInfo referenceInfo = gbean.getGBeanInfo().getReference(referenceName);
        if (referenceInfo == null) {
            return null;
        }
        if (referenceInfo.getProxyType().equals(Collection.class.getName())) {
            return null;
        }
        String message = this.isVerifyReference(referencePatterns, configuration);
        if (message != null) {
            return "Unable to resolve reference \"" + referenceName + "\"\n" + "    in gbean " + gbean.getAbstractName() + "\n    to a gbean matching the pattern " + referencePatterns.getPatterns() + "\n    due to: " + message;
        }
        return null;
    }

    private String verifyDependency(AbstractName name, ReferencePatterns referencePatterns, Configuration configuration) {
        String message = this.isVerifyReference(referencePatterns, configuration);
        if (message != null) {
            return "Unable to resolve dependency in gbean " + name + "\n    to a gbean matching the pattern " + referencePatterns.getPatterns() + "\n    due to: " + message;
        }
        return null;
    }

    private String isVerifyReference(ReferencePatterns referencePatterns, Configuration configuration) {
        if (referencePatterns.isResolved()) {
            return null;
        }
        Set patterns = referencePatterns.getPatterns();
        for (AbstractNameQuery query : patterns) {
            if (query.getArtifact() == null) continue;
            return null;
        }
        try {
            configuration.findGBean(patterns);
            return null;
        }
        catch (GBeanNotFoundException e) {
            if (e.hasMatches()) {
                return null;
            }
            return e.getMessage();
        }
    }

    private class DefaultJarFileFactory
    implements JarFileFactory {
        private DefaultJarFileFactory() {
        }

        public JarFile newJarFile(URI relativeURI) throws IOException {
            File targetFile = DeploymentContext.this.getTargetFile(relativeURI);
            try {
                return new JarFile(targetFile);
            }
            catch (IOException e) {
                throw (IOException)new IOException("Could not create JarFile for file: " + targetFile).initCause(e);
            }
        }

        public String getManifestClassPath(JarFile jarFile) throws IOException {
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                return null;
            }
            return manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        }
    }

    static interface JarFileFactory {
        public JarFile newJarFile(URI var1) throws IOException;

        public String getManifestClassPath(JarFile var1) throws IOException;
    }
}

