/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.apache.geronimo.cli.deployer.CommandArgs;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.cli.AbstractCommand;
import org.apache.geronimo.deployment.cli.DeployUtils;
import org.apache.geronimo.deployment.cli.ServerConnection;

public class CommandStart
extends AbstractCommand {
    public void execute(PrintWriter out, ServerConnection connection, CommandArgs commandArgs) throws DeploymentException {
        TargetModuleID[] allModules;
        String[] args = commandArgs.getArgs();
        DeploymentManager mgr = connection.getDeploymentManager();
        Target[] allTargets = mgr.getTargets();
        try {
            allModules = mgr.getAvailableModules(null, allTargets);
        }
        catch (TargetException e) {
            throw new DeploymentException("Unable to load module list from server", (Throwable)e);
        }
        ArrayList modules = new ArrayList();
        for (int i = 0; i < args.length; ++i) {
            modules.addAll(DeployUtils.identifyTargetModuleIDs((TargetModuleID[])allModules, (String)args[i], (boolean)false));
        }
        TargetModuleID[] ids = modules.toArray(new TargetModuleID[modules.size()]);
        boolean multiple = CommandStart.isMultipleTargets(ids);
        ProgressObject po = this.runCommand(out, mgr, ids);
        TargetModuleID[] done = po.getResultTargetModuleIDs();
        out.println();
        for (int i = 0; i < done.length; ++i) {
            TargetModuleID id = done[i];
            out.print(DeployUtils.reformat(this.getAction() + " " + id.getModuleID() + (multiple && id.getTarget() != null ? " on " + id.getTarget().getName() : "") + (id.getWebURL() == null || !this.getAction().equals("Started") ? "" : " @ " + id.getWebURL()), 4, 72));
            if (id.getChildTargetModuleID() != null) {
                for (int j = 0; j < id.getChildTargetModuleID().length; ++j) {
                    TargetModuleID child = id.getChildTargetModuleID()[j];
                    out.print(DeployUtils.reformat("  `-> " + child.getModuleID() + (child.getWebURL() == null || this.getAction().toLowerCase().indexOf("started") == -1 ? "" : " @ " + child.getWebURL()), 4, 72));
                }
            } else {
                TargetModuleID childs;
                Iterator iterator = DeployUtils.identifyTargetModuleIDs((TargetModuleID[])allModules, (String)id.getModuleID(), (boolean)false).iterator();
                if (iterator.hasNext() && (childs = (TargetModuleID)iterator.next()).getChildTargetModuleID() != null) {
                    for (int j = 0; j < childs.getChildTargetModuleID().length; ++j) {
                        TargetModuleID child = childs.getChildTargetModuleID()[j];
                        out.print(DeployUtils.reformat("  `-> " + child.getModuleID() + (child.getWebURL() == null || this.getAction().toLowerCase().indexOf("started") == -1 ? "" : " @ " + child.getWebURL()), 4, 72));
                    }
                }
            }
            out.println();
        }
        if (po.getDeploymentStatus().isFailed()) {
            throw new DeploymentException("Operation failed: " + po.getDeploymentStatus().getMessage());
        }
    }

    protected ProgressObject runCommand(PrintWriter out, DeploymentManager mgr, TargetModuleID[] ids) {
        ProgressObject po = mgr.start(ids);
        this.waitForProgress(out, po);
        return po;
    }

    protected String getAction() {
        return "Started";
    }
}

