/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.security.auth.login.FailedLoginException;
import org.apache.geronimo.cli.deployer.BaseCommandArgs;
import org.apache.geronimo.cli.deployer.CommandArgs;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.cli.AbstractCommand;
import org.apache.geronimo.deployment.cli.CommandInstallCAR;
import org.apache.geronimo.deployment.cli.CommandStart;
import org.apache.geronimo.deployment.cli.DeployUtils;
import org.apache.geronimo.deployment.cli.ServerConnection;
import org.apache.geronimo.deployment.plugin.GeronimoDeploymentManager;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.system.plugin.DownloadResults;
import org.apache.geronimo.system.plugin.PluginList;
import org.apache.geronimo.system.plugin.PluginMetadata;

public class CommandListConfigurations
extends AbstractCommand {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(PrintWriter out, ServerConnection connection, CommandArgs commandArgs) throws DeploymentException {
        DeploymentManager dmgr = connection.getDeploymentManager();
        if (!(dmgr instanceof GeronimoDeploymentManager)) throw new DeploymentException("Cannot list repositories when connected to " + connection.getServerURI());
        GeronimoDeploymentManager mgr = (GeronimoDeploymentManager)dmgr;
        try {
            PluginList data;
            String repo = null;
            repo = commandArgs.getArgs().length == 1 ? commandArgs.getArgs()[0] : this.getRepository(out, new BufferedReader(new InputStreamReader(System.in)), mgr);
            try {
                URL repository = new URL(repo);
                data = mgr.listPlugins(repository, null, null);
            }
            catch (IOException e) {
                throw new DeploymentException("Unable to list configurations", (Throwable)e);
            }
            catch (FailedLoginException e) {
                throw new DeploymentException("Invalid login for Maven repository '" + repo + "'", (Throwable)e);
            }
            if (data == null) {
                out.println();
                out.println("No plugins were returned from this site.");
                return;
            }
            HashMap<String, ArrayList<PluginMetadata>> categories = new HashMap<String, ArrayList<PluginMetadata>>();
            ArrayList<PluginMetadata> available = new ArrayList<PluginMetadata>();
            for (int i = 0; i < data.getPlugins().length; ++i) {
                PluginMetadata metadata = data.getPlugins()[i];
                ArrayList<PluginMetadata> list = (ArrayList<PluginMetadata>)categories.get(metadata.getCategory());
                if (list == null) {
                    list = new ArrayList<PluginMetadata>();
                    categories.put(metadata.getCategory(), list);
                }
                list.add(metadata);
            }
            for (Map.Entry entry : categories.entrySet()) {
                String category = (String)entry.getKey();
                List items = (List)entry.getValue();
                out.println();
                out.print(DeployUtils.reformat(category, 4, 72));
                for (int i = 0; i < items.size(); ++i) {
                    PluginMetadata metadata = (PluginMetadata)items.get(i);
                    String prefix = "    ";
                    if (!metadata.isInstalled() && metadata.isEligible()) {
                        available.add(metadata);
                        prefix = Integer.toString(available.size());
                        if (available.size() < 10) {
                            prefix = prefix + " ";
                        }
                        prefix = prefix + ": ";
                    }
                    out.print(DeployUtils.reformat(prefix + metadata.getName() + " (" + metadata.getVersion() + ")", 8, 72));
                    out.flush();
                }
            }
            if (available.size() == 0) {
                out.println();
                out.println("No plugins from this site are eligible for installation.");
                return;
            }
            out.println();
            out.print("Install Service [enter number or 'q' to quit]: ");
            out.flush();
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            String answer = in.readLine();
            if (answer.equalsIgnoreCase("q")) {
                return;
            }
            int selection = Integer.parseInt(answer);
            PluginMetadata target = (PluginMetadata)available.get(selection - 1);
            long start = System.currentTimeMillis();
            Object key = mgr.startInstall(PluginList.createInstallList((PluginList)data, (Artifact)target.getModuleId()), null, null);
            DownloadResults results = CommandInstallCAR.showProgress(mgr, key);
            int time = (int)(System.currentTimeMillis() - start) / 1000;
            out.println();
            if (!results.isFailed()) {
                Artifact uri;
                int i;
                out.print(DeployUtils.reformat("**** Installation Complete!", 4, 72));
                for (i = 0; i < results.getDependenciesPresent().length; ++i) {
                    uri = results.getDependenciesPresent()[i];
                    out.print(DeployUtils.reformat("Used existing: " + uri, 4, 72));
                }
                for (i = 0; i < results.getDependenciesInstalled().length; ++i) {
                    uri = results.getDependenciesInstalled()[i];
                    out.print(DeployUtils.reformat("Installed new: " + uri, 4, 72));
                }
                out.println();
                out.print(DeployUtils.reformat("Downloaded " + results.getTotalDownloadBytes() / 1024L + " kB in " + time + "s (" + results.getTotalDownloadBytes() / (long)(1024 * time) + " kB/s)", 4, 72));
            }
            if (!results.isFinished() || results.isFailed()) return;
            out.print(DeployUtils.reformat("Now starting " + target.getModuleId() + "...", 4, 72));
            out.flush();
            new CommandStart().execute(out, connection, (CommandArgs)new BaseCommandArgs(new String[]{target.getModuleId().toString()}));
            return;
        }
        catch (IOException e) {
            throw new DeploymentException("Unable to install configuration", (Throwable)e);
        }
        catch (NumberFormatException e) {
            throw new DeploymentException("Invalid response");
        }
    }

    private String getRepository(PrintWriter out, BufferedReader in, GeronimoDeploymentManager mgr) throws IOException, DeploymentException {
        URL[] all = mgr.getRepositories();
        if (all.length == 0) {
            throw new DeploymentException("No default repositories available.  Please either specify the repository URL on the command line, or go into the console Plugin page and update the list of available repositories.");
        }
        out.println();
        out.println("Select repository:");
        for (int i = 0; i < all.length; ++i) {
            URL url = all[i];
            out.println("  " + (i + 1) + ". " + url);
        }
        out.println();
        out.print("Enter Repository Number: ");
        out.flush();
        String entry = in.readLine().trim();
        int index = Integer.parseInt(entry);
        return all[index - 1].toString();
    }
}

