/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipOutputStream;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.ModuleIDBuilder;
import org.apache.geronimo.deployment.service.GBeanBuilder;
import org.apache.geronimo.deployment.service.ServiceConfigBuilder;
import org.apache.geronimo.deployment.xbeans.ModuleDocument;
import org.apache.geronimo.deployment.xbeans.ModuleType;
import org.apache.geronimo.kernel.Jsr77Naming;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.ConfigurationAlreadyExistsException;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.config.NullConfigurationStore;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactManager;
import org.apache.geronimo.kernel.repository.ArtifactResolver;
import org.apache.geronimo.kernel.repository.DefaultArtifactManager;
import org.apache.geronimo.kernel.repository.DefaultArtifactResolver;
import org.apache.geronimo.system.configuration.ExecutableConfigurationUtil;
import org.apache.geronimo.system.repository.Maven1Repository;

public class PluginBootstrap {
    private File localRepo;
    private File plan;
    private File buildDir;
    private File carFile;

    public void setLocalRepo(File localRepo) {
        this.localRepo = localRepo;
    }

    public void setPlan(File plan) {
        this.plan = plan;
    }

    public void setBuildDir(File buildDir) {
        this.buildDir = buildDir;
    }

    public void setCarFile(File carFile) {
        this.carFile = carFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bootstrap() throws Exception {
        System.out.println();
        System.out.println("    Packaging configuration " + this.plan);
        System.out.println();
        ModuleType config = ModuleDocument.Factory.parse((File)this.plan).getModule();
        Maven1Repository repository = new Maven1Repository(this.localRepo);
        GBeanBuilder gBeanBuilder = new GBeanBuilder(null, null);
        ServiceConfigBuilder builder = new ServiceConfigBuilder(null, Collections.singleton(repository), Collections.singleton(gBeanBuilder), (Naming)new Jsr77Naming());
        NullConfigurationStore targetConfigurationStore = new NullConfigurationStore(){

            public File createNewConfigurationDir(Artifact configId) throws ConfigurationAlreadyExistsException {
                return PluginBootstrap.this.buildDir;
            }
        };
        DefaultArtifactManager artifactManager = new DefaultArtifactManager();
        DefaultArtifactResolver artifactResolver = new DefaultArtifactResolver((ArtifactManager)artifactManager, Collections.singleton(repository), null);
        DeploymentContext context = builder.buildConfiguration(false, builder.getConfigurationID((Object)config, null, new ModuleIDBuilder()), config, null, Collections.singleton(targetConfigurationStore), (ArtifactResolver)artifactResolver, (ConfigurationStore)targetConfigurationStore);
        ZipOutputStream out = null;
        try {
            ConfigurationData configurationData = context.getConfigurationData();
            out = new JarOutputStream(new FileOutputStream(this.carFile));
            ExecutableConfigurationUtil.writeConfiguration((ConfigurationData)configurationData, (JarOutputStream)out);
            out.flush();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ignored) {}
            }
            if (context != null) {
                context.close();
            }
        }
    }
}

