/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.plugin.remote;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedList;
import org.apache.geronimo.deployment.plugin.local.AbstractDeployCommand;
import org.apache.geronimo.util.encoders.Base64;

public class RemoteDeployUtil {
    public static void uploadFilesToServer(File[] files, AbstractDeployCommand progress) {
        if (files == null) {
            return;
        }
        LinkedList<Integer> valid = new LinkedList<Integer>();
        for (int i = 0; i < files.length; ++i) {
            File file;
            if (files[i] == null || !(file = files[i]).exists() || !file.canRead()) continue;
            valid.add(new Integer(i));
        }
        if (valid.size() > 0) {
            progress.updateStatus("Uploading " + valid.size() + " file(s) to server");
            try {
                URL url = progress.getRemoteDeployUploadURL();
                URLConnection con = RemoteDeployUtil.connectToServer(url, progress.getCommandContext().getUsername(), progress.getCommandContext().getPassword());
                DataOutputStream out = new DataOutputStream(new BufferedOutputStream(con.getOutputStream()));
                out.writeInt(valid.size());
                byte[] buf = new byte[1024];
                for (Integer index : valid) {
                    int size;
                    int threshold;
                    File file = files[index];
                    int length = (int)file.length();
                    out.writeInt(length);
                    int next = threshold = Math.max(length / 100, 10240);
                    BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
                    int total = 0;
                    while ((size = in.read(buf)) > -1) {
                        out.write(buf, 0, size);
                        if ((total += size) <= next) continue;
                        progress.updateStatus("Uploading " + file.getName() + ": " + total / 1024 + " kB");
                        while (total > next) {
                            next += threshold;
                        }
                    }
                    in.close();
                }
                out.flush();
                out.close();
                DataInputStream in = new DataInputStream(new BufferedInputStream(con.getInputStream()));
                String status = in.readUTF();
                if (!status.equals("OK")) {
                    progress.fail("Unable to upload files to server: " + status);
                    return;
                }
                progress.updateStatus("File upload complete (Server: " + status + ")");
                int count = in.readInt();
                if (count != valid.size()) {
                    progress.fail("Server did not receive all " + valid.size() + " files (" + count + ")");
                }
                for (Integer index : valid) {
                    String serverFileName = in.readUTF();
                    files[index.intValue()] = new File(serverFileName);
                }
                in.close();
                progress.updateStatus(count + " file(s) transferred to server.  Resuming deployment operation.");
            }
            catch (Exception e) {
                progress.doFail(e);
            }
        }
    }

    private static URLConnection connectToServer(URL url, String username, String password) throws IOException {
        URLConnection con = url.openConnection();
        String auth = username + ":" + password;
        byte[] data = auth.getBytes();
        String s = new String(Base64.encode((byte[])data));
        while (s.length() % 4 != 0) {
            s = s + "=";
        }
        con.setRequestProperty("Authorization", "Basic " + s);
        con.setDoInput(true);
        con.setDoOutput(true);
        con.connect();
        return con;
    }
}

