/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.plugin.local;

import java.util.List;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.TargetModuleID;
import org.apache.geronimo.deployment.plugin.TargetModuleIDImpl;
import org.apache.geronimo.deployment.plugin.local.CommandSupport;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.repository.Artifact;

public class StartCommand
extends CommandSupport {
    private final Kernel kernel;
    private final TargetModuleID[] modules;

    public StartCommand(Kernel kernel, TargetModuleID[] modules) {
        super(CommandType.START);
        this.kernel = kernel;
        this.modules = modules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            ConfigurationManager configurationManager = ConfigurationUtil.getConfigurationManager((Kernel)this.kernel);
            try {
                for (int i = 0; i < this.modules.length; ++i) {
                    TargetModuleID module = this.modules[i];
                    Artifact moduleID = Artifact.create((String)module.getModuleID());
                    if (configurationManager.isRunning(moduleID)) {
                        this.updateStatus("Module " + moduleID + " is already running");
                        Thread.sleep(100L);
                        continue;
                    }
                    if (!configurationManager.isLoaded(moduleID)) {
                        configurationManager.loadConfiguration(moduleID);
                    }
                    configurationManager.startConfiguration(moduleID);
                    List kids = StartCommand.loadChildren(this.kernel, moduleID.toString());
                    TargetModuleIDImpl id = new TargetModuleIDImpl(this.modules[i].getTarget(), module.getModuleID(), kids.toArray(new String[kids.size()]));
                    if (StartCommand.isWebApp(this.kernel, moduleID.toString())) {
                        id.setType(ModuleType.WAR);
                    }
                    if (id.getChildTargetModuleID() != null) {
                        for (int k = 0; k < id.getChildTargetModuleID().length; ++k) {
                            TargetModuleIDImpl child = (TargetModuleIDImpl)id.getChildTargetModuleID()[k];
                            if (!StartCommand.isWebApp(this.kernel, child.getModuleID())) continue;
                            child.setType(ModuleType.WAR);
                        }
                    }
                    this.addModule(id);
                }
            }
            finally {
                ConfigurationUtil.releaseConfigurationManager((Kernel)this.kernel, (ConfigurationManager)configurationManager);
            }
            this.addWebURLs(this.kernel);
            this.complete("Completed");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.doFail(e);
        }
    }
}

