/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.cxf;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.concurrent.Executor;
import javax.xml.ws.Binding;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.PortInfo;
import javax.xml.ws.soap.SOAPBinding;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerImpl;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.jaxws.handler.PortInfoImpl;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.geronimo.cxf.CXFWebServiceContainer;
import org.apache.geronimo.jaxws.annotations.AnnotationException;
import org.apache.geronimo.jaxws.annotations.AnnotationProcessor;
import org.apache.geronimo.jaxws.handler.GeronimoHandlerResolver;
import org.apache.xbean.osgi.bundle.util.BundleUtils;
import org.osgi.framework.Bundle;

public abstract class CXFEndpoint {
    protected Bus bus;
    protected Object implementor;
    protected Server server;
    protected Service service;
    protected JaxWsImplementorInfo implInfo;
    protected JaxWsServiceFactoryBean serviceFactory;
    protected org.apache.geronimo.jaxws.PortInfo portInfo;
    protected AnnotationProcessor annotationProcessor;
    private String address;
    private Bundle bundle;

    public CXFEndpoint(Bus bus, Object implementor, Bundle bundle) {
        this.bus = bus;
        this.implementor = implementor;
        this.portInfo = (org.apache.geronimo.jaxws.PortInfo)bus.getExtension(org.apache.geronimo.jaxws.PortInfo.class);
        this.bundle = bundle;
        this.bus.setExtension((Object)this, CXFEndpoint.class);
    }

    protected URL getWsdlURL(Bundle bundle, String wsdlFile) {
        URL wsdlURL;
        block3: {
            if (wsdlFile == null || wsdlFile.trim().length() == 0) {
                return null;
            }
            wsdlURL = null;
            wsdlFile = wsdlFile.trim();
            try {
                wsdlURL = new URL(wsdlFile);
            }
            catch (MalformedURLException e) {
                wsdlURL = bundle.getResource("/" + wsdlFile);
                if (wsdlURL != null) break block3;
                wsdlURL = BundleUtils.getEntry((Bundle)bundle, (String)wsdlFile);
            }
        }
        return wsdlURL;
    }

    protected Class getImplementorClass() {
        return this.implementor.getClass();
    }

    protected Endpoint getEndpoint() {
        return this.getServer().getEndpoint();
    }

    public boolean isSOAP11() {
        return "http://schemas.xmlsoap.org/wsdl/soap/http".equals(this.implInfo.getBindingType()) || "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true".equals(this.implInfo.getBindingType());
    }

    public boolean isHTTP() {
        return "http://www.w3.org/2004/08/wsdl/http".equals(this.implInfo.getBindingType());
    }

    public ServerImpl getServer() {
        return (ServerImpl)this.server;
    }

    public Binding getBinding() {
        return ((JaxWsEndpointImpl)this.getEndpoint()).getJaxwsBinding();
    }

    public void setExecutor(Executor executor) {
        this.service.setExecutor(executor);
    }

    public Executor getExecutor() {
        return this.service.getExecutor();
    }

    public Object getImplementor() {
        return this.implementor;
    }

    public boolean isPublished() {
        return this.server != null;
    }

    public void publish(String address) {
        this.doPublish(address);
    }

    protected void doPublish(String baseAddress) {
        String address = baseAddress == null ? "http://localhost:8080" : baseAddress;
        GeronimoJaxWsServerFactoryBean svrFactory = new GeronimoJaxWsServerFactoryBean();
        svrFactory.setBus(this.bus);
        svrFactory.setAddress(address + this.portInfo.getLocation());
        svrFactory.setServiceFactory((ReflectionServiceFactoryBean)this.serviceFactory);
        svrFactory.setStart(false);
        svrFactory.setServiceBean(this.implementor);
        if ("http://www.w3.org/2004/08/wsdl/http".equals(this.implInfo.getBindingType())) {
            svrFactory.setTransportId("http://cxf.apache.org/bindings/xformat");
        }
        this.server = svrFactory.create();
        this.init();
        if (this.getBinding() instanceof SOAPBinding && this.portInfo.getMtomFeatureInfo() != null) {
            ((SOAPBinding)this.getBinding()).setMTOMEnabled(this.portInfo.getMtomFeatureInfo().isEnabled());
        }
        this.server.start();
    }

    protected void init() {
    }

    synchronized void updateAddress(URI request) {
        if (this.address == null) {
            String requestAddress = CXFWebServiceContainer.getBaseUri(request);
            this.getEndpoint().getEndpointInfo().setAddress(requestAddress);
            this.address = requestAddress;
        }
    }

    protected void initHandlers() throws Exception {
        GeronimoHandlerResolver handlerResolver = new GeronimoHandlerResolver(this.bundle, this.getImplementorClass(), this.portInfo.getHandlerChainsInfo(), null);
        PortInfoImpl portInfo = new PortInfoImpl(this.implInfo.getBindingType(), this.serviceFactory.getEndpointName(), this.service.getName());
        List chain = handlerResolver.getHandlerChain((PortInfo)portInfo);
        this.getBinding().setHandlerChain(chain);
    }

    protected void injectResources(Object instance) throws AnnotationException {
        this.annotationProcessor.processAnnotations(instance);
        this.annotationProcessor.invokePostConstruct(instance);
    }

    protected void injectHandlers() {
        List handlers = this.getBinding().getHandlerChain();
        try {
            for (Handler handler : handlers) {
                this.injectResources(handler);
            }
        }
        catch (AnnotationException e) {
            throw new WebServiceException("Handler annotation failed", (Throwable)e);
        }
    }

    protected void destroyHandlers() {
        if (this.annotationProcessor != null) {
            List handlers = this.getBinding().getHandlerChain();
            for (Handler handler : handlers) {
                this.annotationProcessor.invokePreDestroy((Object)handler);
            }
        }
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    private static class GeronimoJaxWsServerFactoryBean
    extends JaxWsServerFactoryBean {
        public GeronimoJaxWsServerFactoryBean() {
            this.doInit = false;
        }
    }
}

