/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.cxf;

import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.PortInfo;
import org.apache.cxf.jaxws.handler.AnnotationHandlerChainBuilder;
import org.apache.cxf.jaxws.javaee.HandlerChainType;
import org.apache.geronimo.jaxws.JAXWSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeronimoHandlerChainBuilder
extends AnnotationHandlerChainBuilder {
    private ClassLoader classLoader = null;
    private PortInfo portInfo;

    public GeronimoHandlerChainBuilder(ClassLoader classloader, PortInfo portInfo) {
        this.classLoader = classloader;
        this.portInfo = portInfo;
        this.setHandlerInitEnabled(false);
    }

    public ClassLoader getHandlerClassLoader() {
        return this.classLoader;
    }

    protected List<Handler> buildHandlerChain(HandlerChainType hc, ClassLoader classLoader) {
        if (this.matchServiceName(this.portInfo, hc.getServiceNamePattern()) && this.matchPortName(this.portInfo, hc.getPortNamePattern()) && this.matchBinding(this.portInfo, hc.getProtocolBindings())) {
            return super.buildHandlerChain(hc, classLoader);
        }
        return Collections.emptyList();
    }

    private boolean matchServiceName(PortInfo info, String namePattern) {
        return this.match(info == null ? null : info.getServiceName(), namePattern);
    }

    private boolean matchPortName(PortInfo info, String namePattern) {
        return this.match(info == null ? null : info.getPortName(), namePattern);
    }

    private boolean matchBinding(PortInfo info, List<String> bindings) {
        return this.match(info == null ? null : info.getBindingID(), bindings);
    }

    private boolean match(String binding, List<String> bindings) {
        if (binding == null) {
            return bindings == null || bindings.isEmpty();
        }
        if (bindings == null || bindings.isEmpty()) {
            return true;
        }
        String actualBindingURI = JAXWSUtils.getBindingURI((String)binding);
        for (String bindingToken : bindings) {
            String bindingURI = JAXWSUtils.getBindingURI((String)bindingToken);
            if (!actualBindingURI.equals(bindingURI)) continue;
            return true;
        }
        return false;
    }

    private boolean match(QName name, String namePattern) {
        if (name == null) {
            return namePattern == null || namePattern.equals("*");
        }
        if (namePattern == null) {
            return true;
        }
        int pos = namePattern.indexOf(58);
        String localNamePattern = pos == -1 ? namePattern : namePattern.substring(pos + 1);
        if ((localNamePattern = localNamePattern.trim()).equals("*")) {
            return true;
        }
        if (localNamePattern.endsWith("*")) {
            localNamePattern = localNamePattern.substring(0, localNamePattern.length() - 1);
            return name.getLocalPart().startsWith(localNamePattern);
        }
        return name.getLocalPart().equals(localNamePattern);
    }
}

