/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.cxf;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.catalog.OASISCatalogManager;
import org.apache.xml.resolver.Catalog;

public class CXFCatalogUtils {
    private static final Log LOG = LogFactory.getLog(CXFCatalogUtils.class);

    private CXFCatalogUtils() {
    }

    public static void loadOASISCatalog(Bus bus, URL baseURL, String catalogName) {
        URL catalogURL = null;
        try {
            catalogURL = new URL(baseURL, catalogName);
            LOG.debug((Object)("Checking for " + catalogURL + " catalog."));
            catalogURL.openStream().close();
            CXFCatalogUtils.loadOASISCatalog(bus, catalogURL);
        }
        catch (MalformedURLException e) {
            LOG.warn((Object)("Error constructing catalog URL: " + baseURL + " " + catalogName));
        }
        catch (FileNotFoundException e) {
            LOG.debug((Object)("Catalog " + catalogURL + " is not present in the module"));
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed to load catalog file: " + catalogURL), (Throwable)e);
        }
    }

    private static void loadOASISCatalog(Bus bus, URL catalogURL) {
        OASISCatalogManager catalog = new OASISCatalogManager();
        try {
            catalog.loadCatalog(catalogURL);
            LOG.debug((Object)("Loaded " + catalogURL + " catalog."));
            bus.setExtension((Object)catalog.getCatalog(), Catalog.class);
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed to load catalog file: " + catalogURL), (Throwable)e);
        }
    }
}

