/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.cxf.pojo;

import java.net.URL;
import javax.naming.Context;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.jaxws.JAXWSMethodInvoker;
import org.apache.cxf.jaxws.context.WebServiceContextImpl;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.geronimo.cxf.CXFEndpoint;
import org.apache.geronimo.cxf.CXFServiceConfiguration;
import org.apache.geronimo.cxf.GeronimoJaxWsImplementorInfo;
import org.apache.geronimo.jaxws.JAXWSAnnotationProcessor;
import org.apache.geronimo.jaxws.JAXWSUtils;
import org.apache.geronimo.jaxws.JNDIResolver;
import org.apache.geronimo.jaxws.annotations.AnnotationHolder;

public class POJOEndpoint
extends CXFEndpoint {
    private static final Log LOG = LogFactory.getLog(POJOEndpoint.class);
    private AnnotationHolder holder;

    public POJOEndpoint(Bus bus, URL configurationBaseUrl, Class instance) {
        super(bus, instance);
        String bindingURI = null;
        if (this.portInfo.getProtocolBinding() != null) {
            bindingURI = JAXWSUtils.getBindingURI((String)this.portInfo.getProtocolBinding());
        }
        this.implInfo = new GeronimoJaxWsImplementorInfo(instance, bindingURI);
        this.serviceFactory = new JaxWsServiceFactoryBean(this.implInfo);
        this.serviceFactory.setBus(bus);
        String wsdlLocation = null;
        wsdlLocation = this.portInfo.getWsdlFile() != null ? this.portInfo.getWsdlFile() : this.implInfo.getWsdlLocation();
        URL wsdlURL = this.getWsdlURL(configurationBaseUrl, wsdlLocation);
        CXFServiceConfiguration configuration = new CXFServiceConfiguration(this.portInfo, wsdlURL);
        this.serviceFactory.getConfigurations().add(0, configuration);
        this.service = this.serviceFactory.create();
        this.holder = (AnnotationHolder)bus.getExtension(AnnotationHolder.class);
        Context context = (Context)bus.getExtension(Context.class);
        try {
            this.implementor = this.holder.newInstance(instance.getName(), instance.getClassLoader(), context);
        }
        catch (Exception e) {
            throw new WebServiceException("Service resource injection failed", (Throwable)e);
        }
        this.service.setInvoker((Invoker)new JAXWSMethodInvoker(this.implementor));
        JNDIResolver jndiResolver = (JNDIResolver)bus.getExtension(JNDIResolver.class);
        this.annotationProcessor = new JAXWSAnnotationProcessor(jndiResolver, (WebServiceContext)new WebServiceContextImpl());
    }

    protected void init() {
        try {
            this.initHandlers();
            this.injectHandlers();
        }
        catch (Exception e) {
            throw new WebServiceException("Error configuring handlers", (Throwable)e);
        }
    }

    public void stop() {
        this.destroyHandlers();
        if (this.implementor != null) {
            try {
                this.holder.destroyInstance(this.implementor);
            }
            catch (Exception e) {
                LOG.warn((Object)"Error calling @PreDestroy method", (Throwable)e);
            }
        }
        super.stop();
    }
}

