/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.cxf.ejb;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.interceptor.InvocationContext;
import javax.xml.ws.handler.MessageContext;
import org.apache.cxf.Bus;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker;
import org.apache.cxf.jaxws.context.WebServiceContextImpl;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.service.invoker.Factory;
import org.apache.geronimo.cxf.ejb.EJBEndpoint;
import org.apache.geronimo.cxf.ejb.EJBInterceptor;
import org.apache.geronimo.cxf.ejb.EJBMessageContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.RpcContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EJBMethodInvoker
extends AbstractJAXWSMethodInvoker {
    private static final Logger LOG = LoggerFactory.getLogger(EJBMethodInvoker.class);
    private static final String HANDLER_PROPERTIES = "HandlerProperties";
    private BeanContext beanContext;
    private Bus bus;
    private EJBEndpoint endpoint;

    public EJBMethodInvoker(EJBEndpoint endpoint, Bus bus, BeanContext beanContext) {
        super((Factory)null);
        this.endpoint = endpoint;
        this.bus = bus;
        this.beanContext = beanContext;
    }

    public Object getServiceObject(Exchange context) {
        return null;
    }

    public void releaseServiceObject(Exchange ex, Object obj) {
    }

    protected Object invoke(Exchange exchange, Object serviceObject, Method m, List<Object> params) {
        Object result = null;
        InvocationContext invContext = (InvocationContext)exchange.get(InvocationContext.class);
        if (invContext == null) {
            LOG.debug("PreEJBInvoke");
            result = this.preEjbInvoke(exchange, serviceObject, m, params);
        } else {
            LOG.debug("EJBInvoke");
            result = super.invoke(exchange, serviceObject, m, params);
        }
        return result;
    }

    protected Object performInvocation(Exchange exchange, Object serviceObject, Method m, Object[] paramArray) throws Exception {
        InvocationContext invContext = (InvocationContext)exchange.get(InvocationContext.class);
        invContext.setParameters(paramArray);
        Object res = invContext.proceed();
        EJBMessageContext ctx = (EJBMessageContext)((Object)invContext.getContextData());
        Map handlerProperties = (Map)exchange.get((Object)HANDLER_PROPERTIES);
        this.addHandlerProperties(ctx, handlerProperties);
        this.updateWebServiceContext(exchange, (MessageContext)ctx);
        return res;
    }

    private Object preEjbInvoke(Exchange exchange, Object serviceObject, Method method, List<Object> params) {
        EJBMessageContext ctx = new EJBMessageContext(exchange.getInMessage(), MessageContext.Scope.APPLICATION);
        WebServiceContextImpl.setMessageContext((MessageContext)ctx);
        Map handlerProperties = this.removeHandlerProperties(ctx);
        exchange.put((Object)HANDLER_PROPERTIES, (Object)handlerProperties);
        try {
            EJBInterceptor interceptor = new EJBInterceptor(params, method, this.endpoint, this.bus, exchange);
            Object[] arguments = new Object[]{ctx, interceptor, ctx};
            RpcContainer container = (RpcContainer)this.beanContext.getContainer();
            Class callInterface = this.beanContext.getServiceEndpointInterface();
            method = EJBMethodInvoker.getMostSpecificMethod((Method)method, (Class)callInterface);
            Object res = container.invoke(this.beanContext.getDeploymentID(), InterfaceType.SERVICE_ENDPOINT, callInterface, method, arguments, null);
            if (exchange.isOneWay()) {
                Object var12_14 = null;
                return var12_14;
            }
            MessageContentsList messageContentsList = new MessageContentsList(new Object[]{res});
            return messageContentsList;
        }
        catch (Fault f) {
            exchange.getInMessage().put(FaultMode.class, (Object)FaultMode.UNCHECKED_APPLICATION_FAULT);
            throw f;
        }
        catch (Exception e) {
            exchange.getInMessage().put(FaultMode.class, (Object)FaultMode.UNCHECKED_APPLICATION_FAULT);
            throw this.createFault(e, method, params, false);
        }
        finally {
            WebServiceContextImpl.clear();
        }
    }

    public Object directEjbInvoke(Exchange exchange, Method m, List<Object> params) throws Exception {
        Object[] paramArray = params != null ? params.toArray() : new Object[]{};
        return this.performInvocation(exchange, null, m, paramArray);
    }
}

