/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.converter.bea;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Weblogic81Utils {
    private static final Pattern ENCRYPTED_STRING = Pattern.compile("\\\"\\{\\S+\\}\\S+?\\\"");
    private Object decoder;
    private Method decode;
    private Object decrypter;
    private Method decrypt;
    private File domainDir;

    public Weblogic81Utils(String libDirPath, String domainDirPath) {
        File libDir = new File(libDirPath);
        if (!(libDir.exists() && libDir.canRead() && libDir.isDirectory())) {
            throw new IllegalArgumentException("Bad weblogic lib dir");
        }
        File weblogicJar = new File(libDir, "weblogic.jar");
        File securityJar = new File(libDir, "jsafeFIPS.jar");
        if (!weblogicJar.canRead()) {
            throw new IllegalArgumentException("Cannot find JARs in provided lib dir");
        }
        this.domainDir = new File(domainDirPath);
        if (!(this.domainDir.exists() && this.domainDir.canRead() && this.domainDir.isDirectory())) {
            throw new IllegalArgumentException("Bad domain directory");
        }
        File state = new File(this.domainDir, "SerializedSystemIni.dat");
        if (!state.canRead()) {
            throw new IllegalArgumentException("Cannot find serialized state in domain directory");
        }
        try {
            URL[] uRLArray;
            if (securityJar.exists()) {
                URL[] uRLArray2 = new URL[2];
                uRLArray2[0] = weblogicJar.toURL();
                uRLArray = uRLArray2;
                uRLArray2[1] = securityJar.toURL();
            } else {
                URL[] uRLArray3 = new URL[1];
                uRLArray = uRLArray3;
                uRLArray3[0] = weblogicJar.toURL();
            }
            URLClassLoader loader = new URLClassLoader(uRLArray, Weblogic81Utils.class.getClassLoader());
            this.initialize(loader, state);
        }
        catch (Exception e) {
            throw (RuntimeException)new IllegalArgumentException("Unable to initialize encryption routines from provided arguments").initCause(e);
        }
    }

    public Properties getBootProperties() {
        File boot = new File(this.domainDir, "boot.properties");
        FileInputStream bootIn = null;
        try {
            bootIn = new FileInputStream(boot);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        try {
            Properties props = new Properties();
            props.load(bootIn);
            bootIn.close();
            Iterator<Object> it = props.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = props.getProperty(key);
                if (value == null || !value.startsWith("{")) continue;
                props.setProperty(key, this.decryptString(value));
            }
            return props;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getConfigXML() throws FileNotFoundException {
        File config = new File(this.domainDir, "config.xml");
        BufferedReader in = new BufferedReader(new FileReader(config));
        StringWriter string = new StringWriter();
        PrintWriter out = new PrintWriter(string);
        Matcher m = ENCRYPTED_STRING.matcher("");
        try {
            String line;
            while ((line = in.readLine()) != null) {
                m.reset(line);
                int last = -1;
                while (m.find()) {
                    out.print(line.substring(last + 1, m.start()));
                    String s = line.substring(m.start(), m.end());
                    out.print("\"");
                    out.print(this.decryptString(s.substring(1, s.length() - 1)));
                    out.print("\"");
                    last = m.end() - 1;
                }
                if (last == -1) {
                    out.println(line);
                } else {
                    if (line.length() > last + 1) {
                        out.print(line.substring(last + 1));
                    }
                    out.println();
                }
                out.flush();
            }
            in.close();
            out.close();
        }
        catch (Exception e) {
            return null;
        }
        return string.getBuffer().toString();
    }

    private void initialize(ClassLoader loader, File state) throws IOException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, ClassNotFoundException, InstantiationException {
        byte[] salt = null;
        byte[] key = null;
        FileInputStream in = new FileInputStream(state);
        salt = Weblogic81Utils.readBytes(in);
        int i = in.read();
        if (i != -1) {
            if (i != 1) {
                throw new IllegalStateException();
            }
            key = Weblogic81Utils.readBytes(in);
        }
        in.close();
        this.decrypter = Weblogic81Utils.getEncryptionService(loader, salt, key);
        this.decoder = loader.loadClass("weblogic.utils.encoders.BASE64Decoder").newInstance();
        this.decode = this.decoder.getClass().getMethod("decodeBuffer", String.class);
        this.decrypt = this.decrypter.getClass().getMethod("decryptString", [B.class);
    }

    private static byte[] readBytes(InputStream in) throws IOException {
        int count;
        int len = in.read();
        if (len < 0) {
            throw new IOException("stream is empty");
        }
        byte[] result = new byte[len];
        for (int index = 0; index < len && (count = in.read(result, index, len - index)) != -1; index += count) {
        }
        return result;
    }

    private String decryptString(String string) throws IllegalAccessException, InvocationTargetException {
        if (string.indexOf(125) > -1) {
            string = string.substring(string.indexOf("}") + 1);
        }
        return (String)this.decrypt.invoke(this.decrypter, this.decode.invoke(this.decoder, string));
    }

    static Object getEncryptionService(ClassLoader loader, byte[] salt, byte[] key) throws NoSuchMethodException, ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        String magic = "0xccb97558940b82637c8bec3c770f86fa3a391a56";
        Object factory = loader.loadClass("weblogic.security.internal.encryption.JSafeEncryptionServiceImpl").getMethod("getFactory", new Class[0]).invoke(null, null);
        Method getter = factory.getClass().getMethod("getEncryptionService", [B.class, String.class, [B.class);
        return getter.invoke(factory, salt, magic, key);
    }
}

