/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.concurrent.impl.thread;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.util.concurrent.ManagedThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.concurrent.impl.thread.GeronimoManagedThreadFactory;
import org.apache.geronimo.concurrent.thread.ManagedThread;
import org.apache.geronimo.concurrent.thread.ThreadLifecycleListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackingManagedThreadFactory
implements ManagedThreadFactory,
ThreadLifecycleListener {
    private static final Log LOG = LogFactory.getLog(TrackingManagedThreadFactory.class);
    protected GeronimoManagedThreadFactory threadFactory;
    protected List<ManagedThread> threads = Collections.synchronizedList(new ArrayList());

    public TrackingManagedThreadFactory(GeronimoManagedThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        if (this.threadFactory == null) {
            throw new NullPointerException("threadFactory is null");
        }
    }

    public Thread newThread(Runnable runnable) {
        ManagedThread thread = (ManagedThread)this.threadFactory.newThread(runnable);
        thread.setThreadLifecycleListener((ThreadLifecycleListener)this);
        this.threads.add(thread);
        LOG.debug((Object)("Thread created: " + thread));
        return thread;
    }

    public void threadStarted(Thread thread) {
        this.threadFactory.threadStarted(thread);
        LOG.debug((Object)("Thread started: " + thread));
    }

    public void threadStopped(Thread thread) {
        this.threads.remove(thread);
        this.threadFactory.threadStopped(thread);
        LOG.debug((Object)("Thread stopped: " + thread));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ManagedThread> getThreadList() {
        List<ManagedThread> list = this.threads;
        synchronized (list) {
            return new ArrayList<ManagedThread>(this.threads);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void interruptThreads() {
        List<ManagedThread> list = this.threads;
        synchronized (list) {
            for (ManagedThread thread : this.threads) {
                thread.interrupt();
            }
        }
    }
}

