/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.concurrent.impl.thread;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.concurrent.impl.GBeanBuilder;
import org.apache.geronimo.concurrent.impl.NotificationHelper;
import org.apache.geronimo.concurrent.thread.ManagedThread;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.management.EventProvider;
import org.apache.geronimo.management.ManagedThread;

public class ManagedThreadGBean
implements GBeanLifecycle,
EventProvider,
ManagedThread {
    private static final Log LOG = LogFactory.getLog(ManagedThreadGBean.class);
    public static final GBeanInfo GBEAN_INFO;
    private AbstractName name;
    private org.apache.geronimo.concurrent.thread.ManagedThread thread;
    private NotificationHelper notificationHelper;

    public ManagedThreadGBean(Kernel kernel, ClassLoader classLoader, AbstractName name) {
        this.name = name;
        this.notificationHelper = new NotificationHelper(kernel, name);
    }

    protected void sendNotification(ManagedThread.TaskState state) {
        if (this.notificationHelper.isNotificationSupported()) {
            String taskName;
            String type = null;
            if (state == ManagedThread.TaskState.CANCELLED) {
                type = "task.state.cancelled";
            } else if (state == ManagedThread.TaskState.RELEASED) {
                type = "task.state.released";
            } else if (state == ManagedThread.TaskState.HUNG) {
                type = "task.state.hung";
            } else {
                return;
            }
            Properties userData = new Properties();
            userData.setProperty("managedthread", this.getObjectName());
            userData.setProperty("managedthread.threadID", String.valueOf(this.getThreadID()));
            userData.setProperty("managedthread.threadName", this.getThreadName());
            userData.setProperty("managedthread.taskRunTime", String.valueOf(this.getTaskRunTime()));
            String taskDescription = this.getTaskIdentityDescription();
            if (taskDescription != null) {
                userData.setProperty("managedthread.taskIdentityDescription", taskDescription);
            }
            if ((taskName = this.getTaskIdentityName()) != null) {
                userData.setProperty("managedthread.taskIdentityName", taskName);
            }
            this.notificationHelper.sendNotification(type, userData);
        }
    }

    protected void setManagedThread(org.apache.geronimo.concurrent.thread.ManagedThread thread) {
        this.thread = thread;
    }

    public void doFail() {
        this.thread = null;
    }

    public void doStart() throws Exception {
        LOG.debug((Object)("Thread gbean started: " + this.thread));
    }

    public void doStop() throws Exception {
        LOG.debug((Object)("Thread gbean stopped: " + this.thread));
        this.thread = null;
    }

    public boolean cancel() {
        return this.thread == null ? false : this.thread.cancelTask();
    }

    public long getHungTaskThreshold() {
        return this.thread == null ? -1L : this.thread.getHungTaskThreshold();
    }

    public void setHungTaskThreshold(long threshold) {
        if (this.thread != null) {
            this.thread.setHungTaskThreshold(threshold);
        }
    }

    public String getTaskIdentityDescription() {
        return this.thread == null ? null : this.thread.getTaskIdentityDescription();
    }

    public String getTaskIdentityDescription(String locale) {
        return this.thread == null ? null : this.thread.getTaskIdentityDescription(locale);
    }

    public String getTaskIdentityName() {
        return this.thread == null ? null : this.thread.getTaskIdentityName();
    }

    public long getTaskRunTime() {
        return this.thread == null ? 0L : this.thread.getTaskRunTime();
    }

    public long getThreadID() {
        return this.thread == null ? -1L : this.thread.getThreadID();
    }

    public String getThreadName() {
        return this.thread == null ? null : this.thread.getThreadName();
    }

    public boolean isTaskCancelled() {
        return this.thread == null ? false : this.thread.isTaskCancelled();
    }

    public boolean isTaskHung() {
        return this.thread == null ? false : this.thread.isTaskHung();
    }

    public AbstractName getName() {
        return this.name;
    }

    public String getObjectName() {
        return this.name.getObjectName().getCanonicalName();
    }

    public String[] getEventTypes() {
        return new String[]{"task.state.hung", "task.state.cancelled", "task.state.released"};
    }

    public boolean isEventProvider() {
        return true;
    }

    public boolean isStateManageable() {
        return true;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    protected void verifyObjectName() {
        GBeanBuilder.verifyObjectName(this.getObjectName(), "ManagedThread", "ManagedThread");
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(ManagedThreadGBean.class, (String)"ManagedThread");
        infoFactory.addAttribute("classLoader", ClassLoader.class, false, false);
        infoFactory.addAttribute("abstractName", AbstractName.class, false, false);
        infoFactory.addAttribute("kernel", Kernel.class, false, false);
        infoFactory.addInterface(ManagedThread.class);
        infoFactory.setConstructor(new String[]{"kernel", "classLoader", "abstractName"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

