/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.concurrent.impl.thread;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.concurrent.impl.GBeanBuilder;
import org.apache.geronimo.concurrent.impl.thread.GeronimoManagedThreadFactory;
import org.apache.geronimo.concurrent.impl.thread.GeronimoManagedThreadFactorySource;
import org.apache.geronimo.concurrent.impl.thread.ManagedThreadFactoryGBean;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.Kernel;

public class ManagedThreadFactoryWrapperGBean
extends GBeanBuilder
implements GBeanLifecycle,
GeronimoManagedThreadFactorySource {
    private static final Log LOG = LogFactory.getLog(ManagedThreadFactoryWrapperGBean.class);
    public static final GBeanInfo GBEAN_INFO;
    private AbstractName name;
    private String groupName;
    private boolean daemonThread;
    private int threadPriority;
    private long hungTaskThreshold;
    private long hungTaskMonitorFrequency;
    private String[] contextHandlerClasses;
    private AbstractName threadFactoryName;
    private ManagedThreadFactoryGBean threadFactoryGBean;

    public ManagedThreadFactoryWrapperGBean(Kernel kernel, ClassLoader classLoader, AbstractName name, String[] contextHandlerClasses, String groupName, int threadPriority, boolean daemonThread, long hungTaskThreshold, long hungTaskMonitorFrequency) {
        super(kernel, classLoader);
        this.name = name;
        this.contextHandlerClasses = contextHandlerClasses;
        this.groupName = groupName;
        this.daemonThread = daemonThread;
        this.threadPriority = threadPriority;
        this.hungTaskThreshold = hungTaskThreshold;
        this.hungTaskMonitorFrequency = hungTaskMonitorFrequency;
    }

    public GeronimoManagedThreadFactory getManagedThreadFactory() {
        return this.threadFactoryGBean == null ? null : this.threadFactoryGBean.getManagedThreadFactory();
    }

    public void doStart() throws Exception {
        String threadName = (String)this.name.getName().get("name");
        this.threadFactoryName = this.kernel.getNaming().createRootName(this.name.getArtifact(), threadName, "ManagedThreadFactory");
        GBeanData threadFactoryData = new GBeanData(this.threadFactoryName, ManagedThreadFactoryGBean.getGBeanInfo());
        threadFactoryData.setAttribute("contextHandlers", (Object)this.contextHandlerClasses);
        threadFactoryData.setAttribute("groupName", (Object)this.groupName);
        threadFactoryData.setAttribute("priority", (Object)this.threadPriority);
        threadFactoryData.setAttribute("daemon", (Object)this.daemonThread);
        threadFactoryData.setAttribute("hungTaskThreshold", (Object)this.hungTaskThreshold);
        threadFactoryData.setAttribute("hungTaskMonitorFrequency", (Object)this.hungTaskMonitorFrequency);
        this.addGBeanKernel(this.threadFactoryName, threadFactoryData);
        this.threadFactoryGBean = (ManagedThreadFactoryGBean)this.kernel.getGBean(this.threadFactoryName);
        this.threadFactoryGBean.verifyObjectName();
    }

    public void doFail() {
        try {
            this.doStop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doStop() throws Exception {
        this.threadFactoryGBean = null;
        if (this.threadFactoryName != null) {
            this.removeGBeanKernel(this.threadFactoryName);
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(ManagedThreadFactoryWrapperGBean.class, (String)"ManagedThreadFactoryBuilder");
        infoFactory.addAttribute("classLoader", ClassLoader.class, false, false);
        infoFactory.addAttribute("abstractName", AbstractName.class, false, false);
        infoFactory.addAttribute("kernel", Kernel.class, false, false);
        infoFactory.addAttribute("contextHandlers", String[].class, true, false);
        infoFactory.addAttribute("groupName", String.class, true);
        infoFactory.addAttribute("priority", Integer.TYPE, true);
        infoFactory.addAttribute("daemon", Boolean.TYPE, true);
        infoFactory.addAttribute("hungTaskThreshold", Long.TYPE, true);
        infoFactory.addAttribute("hungTaskMonitorFrequency", Long.TYPE, true);
        infoFactory.addInterface(GeronimoManagedThreadFactorySource.class);
        infoFactory.setConstructor(new String[]{"kernel", "classLoader", "abstractName", "contextHandlers", "groupName", "priority", "daemon", "hungTaskThreshold", "hungTaskMonitorFrequency"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

