/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.concurrent.impl.thread;

import java.util.ArrayList;
import java.util.List;
import org.apache.geronimo.concurrent.impl.thread.GeronimoManagedThread;
import org.apache.geronimo.concurrent.impl.thread.ManagedThreadFactoryGBean;
import org.apache.geronimo.concurrent.thread.BasicManagedThreadFactory;
import org.apache.geronimo.concurrent.thread.ManagedThread;
import org.apache.geronimo.concurrent.thread.ThreadLifecycleListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeronimoManagedThreadFactory
extends BasicManagedThreadFactory {
    private ManagedThreadFactoryGBean factoryGBean;
    private HungTaskMonitor hungTaskMonitor;
    private long hungTaskMonitorFrequency = 60000L;

    public GeronimoManagedThreadFactory(ManagedThreadFactoryGBean gbean) {
        this.factoryGBean = gbean;
    }

    public void setHungTaskMonitorFrequency(long newFrequency) {
        if (newFrequency <= 0L) {
            throw new IllegalArgumentException("Frequency must be greater than 0");
        }
        this.hungTaskMonitorFrequency = newFrequency;
    }

    public long getHungTaskMonitorFrequency() {
        return this.hungTaskMonitorFrequency;
    }

    protected ManagedThread createThread(ThreadGroup group, Runnable runnable, String name) {
        GeronimoManagedThread managedThread = new GeronimoManagedThread(group, runnable, name, (ThreadLifecycleListener)this);
        this.factoryGBean.addThreadGBean(managedThread);
        this.startHungTaskMonitor();
        return managedThread;
    }

    public void threadStopped(Thread thread) {
        super.threadStopped(thread);
        GeronimoManagedThread managedThread = (GeronimoManagedThread)((Object)thread);
        this.factoryGBean.removeThreadGBean(managedThread);
    }

    public String[] getThreads() {
        return GeronimoManagedThreadFactory.getThreads(this.getThreadList());
    }

    public String[] getHungTaskThreads() {
        return GeronimoManagedThreadFactory.getHungTaskThreads(this.getThreadList());
    }

    public static String[] getThreads(List<ManagedThread> threadList) {
        int size = threadList.size();
        String[] threadNames = new String[size];
        for (int i = 0; i < size; ++i) {
            GeronimoManagedThread thread = (GeronimoManagedThread)threadList.get(i);
            threadNames[i] = thread.getGbean().getObjectName();
        }
        return threadNames;
    }

    public static String[] getHungTaskThreads(List<ManagedThread> threadList) {
        int size = threadList.size();
        ArrayList<String> hungTaskThreads = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            GeronimoManagedThread thread = (GeronimoManagedThread)threadList.get(i);
            if (!thread.isTaskHung()) continue;
            hungTaskThreads.add(thread.getGbean().getObjectName());
        }
        return hungTaskThreads.toArray(new String[hungTaskThreads.size()]);
    }

    private synchronized void startHungTaskMonitor() {
        if (this.hungTaskMonitor == null) {
            this.hungTaskMonitor = new HungTaskMonitor();
            this.hungTaskMonitor.setFrequency(this.hungTaskMonitorFrequency);
            Thread thread = new Thread(this.threadGroup, this.hungTaskMonitor, "UpdateTaskStateThread");
            thread.start();
        }
    }

    private class HungTaskMonitor
    implements Runnable {
        private long frequency = 60000L;
        private boolean done = false;

        private HungTaskMonitor() {
        }

        public void setFrequency(long newFrequency) {
            this.frequency = newFrequency;
        }

        public long getFrequency() {
            return this.frequency;
        }

        public void stop() {
            this.done = true;
        }

        public void run() {
            while (!this.done) {
                try {
                    Thread.sleep(this.frequency);
                }
                catch (InterruptedException e) {
                    break;
                }
                GeronimoManagedThreadFactory.this.updateStatus();
            }
        }
    }
}

